/*
 * Decompiled with CFR 0.152.
 */
package com.github.dcysteine.neicustomdiagram.generators.gregtech5.recipedebugger;

import com.github.dcysteine.neicustomdiagram.api.diagram.CustomDiagramGroup;
import com.github.dcysteine.neicustomdiagram.api.diagram.Diagram;
import com.github.dcysteine.neicustomdiagram.api.diagram.DiagramGenerator;
import com.github.dcysteine.neicustomdiagram.api.diagram.DiagramGroupInfo;
import com.github.dcysteine.neicustomdiagram.api.diagram.component.Component;
import com.github.dcysteine.neicustomdiagram.api.diagram.component.ItemComponent;
import com.github.dcysteine.neicustomdiagram.api.diagram.interactable.Interactable;
import com.github.dcysteine.neicustomdiagram.api.diagram.matcher.CustomDiagramMatcher;
import com.github.dcysteine.neicustomdiagram.api.diagram.matcher.DiagramMatcher;
import com.github.dcysteine.neicustomdiagram.generators.gregtech5.recipedebugger.DiagramHandler;
import com.github.dcysteine.neicustomdiagram.generators.gregtech5.recipedebugger.LabelHandler;
import com.github.dcysteine.neicustomdiagram.generators.gregtech5.recipedebugger.LayoutFactory;
import com.github.dcysteine.neicustomdiagram.generators.gregtech5.recipedebugger.RecipeHandler;
import com.github.dcysteine.neicustomdiagram.main.Lang;
import com.github.dcysteine.neicustomdiagram.main.config.DiagramGroupVisibility;
import com.github.dcysteine.neicustomdiagram.util.gregtech5.GregTechOreDictUtil;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import gregtech.api.enums.ItemList;
import gregtech.api.util.GT_Utility;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.init.Items;

public final class GregTechRecipeDebugger
implements DiagramGenerator {
    public static final ItemComponent ICON = ItemComponent.create(GT_Utility.getIntegratedCircuit((int)0));
    private final DiagramGroupInfo info;
    private final LabelHandler labelHandler;
    private final LayoutFactory layoutFactory;
    private final RecipeHandler recipeHandler;
    private final DiagramHandler diagramHandler;

    public GregTechRecipeDebugger(String groupId) {
        this.info = DiagramGroupInfo.builder(Lang.GREGTECH_5_RECIPE_DEBUGGER.trans("groupname"), groupId, ICON, 1).setDefaultVisibility(DiagramGroupVisibility.DISABLED).setDescription("This diagram checks for recipe collisions and various other recipe issues.\nThis diagram is quite heavy, so you probably shouldn't enable it unless you need it.").build();
        this.labelHandler = new LabelHandler();
        this.layoutFactory = new LayoutFactory(this.info, this.labelHandler);
        this.recipeHandler = new RecipeHandler();
        this.diagramHandler = new DiagramHandler(this.info, this.layoutFactory, this.recipeHandler);
    }

    @Override
    public DiagramGroupInfo info() {
        return this.info;
    }

    @Override
    public CustomDiagramGroup generate() {
        this.labelHandler.initialize();
        this.layoutFactory.initialize();
        this.recipeHandler.initialize();
        this.diagramHandler.initialize();
        ImmutableMap.Builder customBehaviorMapBuilder = ImmutableMap.builder();
        Arrays.stream(View.values()).forEach(view -> customBehaviorMapBuilder.put((Object)view.behaviorId(this.info), () -> this.diagramHandler.getDiagrams((View)((Object)view))));
        return new CustomDiagramGroup(this.info, (DiagramMatcher)new CustomDiagramMatcher(this.diagramHandler.getMenuDiagram(), this::getDiagram), (Map<String, Supplier<Collection<Diagram>>>)customBehaviorMapBuilder.build());
    }

    private List<Diagram> getDiagram(Interactable.RecipeType unused, Component component) {
        if (component.type() == Component.ComponentType.ITEM && ((ItemComponent)component).item() == RecipeHandler.PROGRAMMED_CIRCUIT) {
            return this.diagramHandler.getDiagrams(View.PROGRAMMED_CIRCUITS);
        }
        return Lists.newArrayList();
    }

    public static enum View {
        PROGRAMMED_CIRCUITS("-programmed-circuits", ItemComponent.create(GT_Utility.getIntegratedCircuit((int)24)), "programmedcircuitsbutton"),
        CONSUME_CIRCUIT_RECIPES("-consume-circuit-recipes", ItemComponent.create(Items.field_151065_br, 0), "consumecircuitrecipesbutton"),
        UNNECESSARY_CIRCUIT_RECIPES("-unnecessary-circuit-recipes", ItemComponent.create(Items.field_151102_aT, 0), "unnecessarycircuitrecipesbutton"),
        COLLIDING_RECIPES("-colliding-recipes", ItemComponent.create(Items.field_151123_aH, 0), "collidingrecipesbutton"),
        VOIDING_RECIPES("-voiding-recipes", ItemComponent.create(Items.field_151064_bs, 0), "voidingrecipesbutton"),
        UNEQUAL_CELL_RECIPES("-unequal-cell-recipes", GregTechOreDictUtil.getComponent(ItemList.Cell_Empty), "unequalcellrecipesbutton");

        public final String suffix;
        public final ItemComponent icon;
        public final String tooltipKey;

        private View(String suffix, ItemComponent icon, String tooltipKey) {
            this.suffix = suffix;
            this.icon = icon;
            this.tooltipKey = tooltipKey;
        }

        public String behaviorId(DiagramGroupInfo info) {
            return info.groupId() + this.suffix;
        }
    }
}

