/*
 * Decompiled with CFR 0.152.
 */
package com.github.dcysteine.neicustomdiagram.main;

import codechicken.nei.event.NEIRegisterHandlerInfosEvent;
import codechicken.nei.guihook.GuiContainerManager;
import codechicken.nei.guihook.IContainerObjectHandler;
import codechicken.nei.recipe.GuiRecipe;
import codechicken.nei.recipe.IRecipeHandler;
import com.github.dcysteine.neicustomdiagram.api.diagram.DiagramGroup;
import com.github.dcysteine.neicustomdiagram.api.diagram.DiagramGroupInfo;
import com.github.dcysteine.neicustomdiagram.main.Logger;
import com.github.dcysteine.neicustomdiagram.main.config.ConfigOptions;
import com.github.dcysteine.neicustomdiagram.main.config.DiagramGroupVisibility;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.item.ItemStack;

public enum NeiIntegration {
    INSTANCE;

    private List<DiagramGroupInfo> infoList;

    public void initialize(List<DiagramGroupInfo> infoList) {
        this.infoList = infoList;
        GuiContainerManager.addObjectHandler((IContainerObjectHandler)new ObjectHandler());
    }

    @SubscribeEvent
    public void registerHandlers(NEIRegisterHandlerInfosEvent event) {
        Logger.MOD.info("Registering handlers for diagram groups...");
        for (DiagramGroupInfo info : this.infoList) {
            if (ConfigOptions.getDiagramGroupVisibility(info) == DiagramGroupVisibility.DISABLED) continue;
            event.registerHandlerInfo(info.groupId(), "NEI Custom Diagram", "neicustomdiagram", info::buildHandlerInfo);
            Logger.MOD.info("Registered handler for diagram group [{}]!", new Object[]{info.groupId()});
        }
        Logger.MOD.info("Registration complete!");
    }

    private static class ObjectHandler
    implements IContainerObjectHandler {
        private ObjectHandler() {
        }

        private static Optional<DiagramGroup> getDiagramGroup(GuiContainer guiContainer) {
            if (!(guiContainer instanceof GuiRecipe)) {
                return Optional.empty();
            }
            GuiRecipe gui = (GuiRecipe)guiContainer;
            IRecipeHandler handler = gui.getHandler();
            if (!(handler instanceof DiagramGroup)) {
                return Optional.empty();
            }
            return Optional.of((DiagramGroup)handler);
        }

        public void guiTick(GuiContainer guiContainer) {
        }

        public void refresh(GuiContainer guiContainer) {
        }

        public void load(GuiContainer guiContainer) {
        }

        public ItemStack getStackUnderMouse(GuiContainer guiContainer, int mousex, int mousey) {
            if (!(guiContainer instanceof GuiRecipe)) {
                return null;
            }
            Optional<DiagramGroup> diagramGroupOptional = ObjectHandler.getDiagramGroup(guiContainer);
            if (!diagramGroupOptional.isPresent()) {
                return null;
            }
            DiagramGroup diagramGroup = diagramGroupOptional.get();
            Iterator iterator = ((GuiRecipe)guiContainer).getRecipeIndices().iterator();
            while (iterator.hasNext()) {
                int i = (Integer)iterator.next();
                Optional<ItemStack> itemStackOptional = diagramGroup.getStackUnderMouse(i);
                if (!itemStackOptional.isPresent()) continue;
                return itemStackOptional.get();
            }
            return null;
        }

        public boolean objectUnderMouse(GuiContainer guiContainer, int mousex, int mousey) {
            return false;
        }

        public boolean shouldShowTooltip(GuiContainer guiContainer) {
            return ObjectHandler.getDiagramGroup(guiContainer).map(diagramGroup -> !diagramGroup.mouseInBounds()).orElse(true);
        }
    }
}

