/*
 * Decompiled with CFR 0.152.
 */
package tonius.neiintegration.mods.harvestcraft;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.PositionedStack;
import codechicken.nei.api.API;
import com.pam.harvestcraft.GuiPamPresser;
import com.pam.harvestcraft.PresserRecipes;
import java.util.Map;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.item.ItemStack;
import tonius.neiintegration.RecipeHandlerBase;
import tonius.neiintegration.Utils;

public class RecipeHandlerPresser
extends RecipeHandlerBase {
    @Override
    public void prepare() {
        API.setGuiOffset(GuiPamPresser.class, (int)7, (int)-18);
    }

    @Override
    public String getRecipeID() {
        return "harvestcraft.presser";
    }

    public String getRecipeName() {
        return Utils.translate("tile.presser.name", false);
    }

    public String getGuiTexture() {
        return "neiintegration:textures/harvestcraft/presser.png";
    }

    public void loadTransferRects() {
        this.addTransferRect(59, 27, 42, 11);
    }

    public Class<? extends GuiContainer> getGuiClass() {
        return GuiPamPresser.class;
    }

    public void drawBackground(int recipe) {
        this.changeToGuiTexture();
        GuiDraw.drawTexturedModalRect((int)0, (int)0, (int)0, (int)0, (int)160, (int)65);
    }

    public void drawExtras(int recipe) {
        this.drawProgressBar(59, 27, 160, 0, 42, 11, 40, 1);
    }

    @Override
    public void loadAllRecipes() {
        Map recipes = PresserRecipes.pressing().getPressingList();
        for (Map.Entry recipe : recipes.entrySet()) {
            ItemStack[] outputs = (ItemStack[])recipe.getValue();
            if (outputs.length != 2) continue;
            this.arecipes.add(new CachedPresserRecipe((ItemStack)recipe.getKey(), outputs[0], outputs[1]));
        }
    }

    @Override
    public void loadCraftingRecipes(ItemStack result) {
        Map recipes = PresserRecipes.pressing().getPressingList();
        for (Map.Entry recipe : recipes.entrySet()) {
            ItemStack[] outputs = (ItemStack[])recipe.getValue();
            if (outputs.length != 2 || !Utils.areStacksSameTypeCraftingSafe(outputs[0], result) && !Utils.areStacksSameTypeCraftingSafe(outputs[1], result)) continue;
            this.arecipes.add(new CachedPresserRecipe((ItemStack)recipe.getKey(), outputs[0], outputs[1]));
        }
    }

    @Override
    public void loadUsageRecipes(ItemStack ingredient) {
        Map recipes = PresserRecipes.pressing().getPressingList();
        for (Map.Entry recipe : recipes.entrySet()) {
            ItemStack[] outputs;
            if (!Utils.areStacksSameTypeCraftingSafe((ItemStack)recipe.getKey(), ingredient) || (outputs = (ItemStack[])recipe.getValue()).length != 2) continue;
            ingredient = ingredient.func_77946_l();
            ingredient.field_77994_a = 1;
            this.arecipes.add(new CachedPresserRecipe(ingredient, outputs[0], outputs[1]));
        }
    }

    public class CachedPresserRecipe
    extends RecipeHandlerBase.CachedBaseRecipe {
        public PositionedStack input;
        public PositionedStack outputPrimary;
        public PositionedStack outputSecondary;

        public CachedPresserRecipe(ItemStack input, ItemStack outputPrimary, ItemStack outputSecondary) {
            super(RecipeHandlerPresser.this);
            this.input = new PositionedStack((Object)input, 72, 9);
            this.outputPrimary = new PositionedStack((Object)outputPrimary, 54, 40);
            if (outputSecondary != null) {
                this.outputSecondary = new PositionedStack((Object)outputSecondary, 90, 40);
            }
        }

        public PositionedStack getIngredient() {
            this.randomRenderPermutation(this.input, RecipeHandlerPresser.this.cycleticks / 40);
            return this.input;
        }

        public PositionedStack getResult() {
            return this.outputPrimary;
        }

        public PositionedStack getOtherStack() {
            return this.outputSecondary;
        }
    }
}

