/*
 * Decompiled with CFR 0.152.
 */
package net.laurus.nettyfix.asm.transformer;

import net.laurus.nettyfix.utils.Logger;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;

public class ClassTransformer_Netty_Bootstrap {
    private final ClassReader reader;
    private final ClassWriter writer;

    public ClassTransformer_Netty_Bootstrap(String transformedName, byte[] basicClass) {
        ClassReader aTempReader = null;
        ClassWriter aTempWriter = null;
        aTempReader = new ClassReader(basicClass);
        aTempWriter = new ClassWriter(aTempReader, 2);
        this.reader = aTempReader;
        this.writer = aTempWriter;
        this.init(transformedName);
    }

    protected final void init(String transformedName) {
        Fix_CheckAddress aFix = new Fix_CheckAddress((ClassVisitor)this.writer);
        this.reader.accept((ClassVisitor)aFix, 0);
        boolean aFoundMethod = aFix.found;
        if (aFoundMethod) {
            this.log("Transforming " + transformedName);
            this.injectMethod(this.writer);
            this.log("Found method \"checkAddress\", your version of Netty *IS* susceptible to MC-108343, this has been patched.");
        }
        if (aFoundMethod) {
            boolean isValid = false;
            if (this.reader != null && this.writer != null) {
                isValid = true;
            }
            this.log("Valid? " + isValid + ".");
        }
    }

    public boolean injectMethod(ClassWriter cw) {
        boolean b = this.inject_checkAddress();
        if (!b) {
            this.log("Patching failed.");
            return false;
        }
        this.log("Patching Success.");
        return true;
    }

    private boolean inject_checkAddress() {
        MethodVisitor mv = this.getWriter().visitMethod(0, "checkAddress", "(Ljava/net/SocketAddress;)Lio/netty/channel/ChannelFuture;", null, null);
        mv.visitCode();
        Label l0 = new Label();
        mv.visitLabel(l0);
        mv.visitLineNumber(173, l0);
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitMethodInsn(184, "net/laurus/nettyfix/utils/NettyUtils", "checkAddress", "(Lio/netty/bootstrap/Bootstrap;Ljava/net/SocketAddress;)Lio/netty/channel/ChannelFuture;", false);
        mv.visitInsn(176);
        Label l1 = new Label();
        mv.visitLabel(l1);
        mv.visitLocalVariable("this", "Lio/netty/bootstrap/Bootstrap;", null, l0, l1, 0);
        mv.visitLocalVariable("remoteAddress", "Ljava/net/SocketAddress;", null, l0, l1, 1);
        mv.visitMaxs(2, 2);
        mv.visitEnd();
        return true;
    }

    public final ClassReader getReader() {
        return this.reader;
    }

    public final ClassWriter getWriter() {
        return this.writer;
    }

    public String getTransformerName() {
        return "Netty-Bootstrap";
    }

    protected void log(String s) {
        Logger.ASM(this.getTransformerName() + "  | " + s);
    }

    public class Fix_CheckAddress
    extends ClassVisitor {
        public boolean found;

        public Fix_CheckAddress(ClassVisitor cv) {
            super(327680, cv);
            this.found = false;
            this.cv = cv;
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            MethodVisitor methodVisitor;
            boolean foundMethod = false;
            if (name.equals("checkAddress") && desc.equals("(Ljava/net/SocketAddress;)Lio/netty/channel/ChannelFuture;")) {
                foundMethod = true;
            }
            if (foundMethod) {
                methodVisitor = null;
                ClassTransformer_Netty_Bootstrap.this.log("Found method " + name + ", removing.  Found matching desc: " + desc);
                this.found = true;
            } else {
                methodVisitor = super.visitMethod(access, name, desc, signature, exceptions);
            }
            return methodVisitor;
        }
    }
}

