/*
 * Decompiled with CFR 0.152.
 */
package com.github.vfyjxf.nee;

import com.github.vfyjxf.nee.NotEnoughEnergistics;
import com.github.vfyjxf.nee.config.NEEConfig;
import com.github.vfyjxf.nee.processor.IRecipeProcessor;
import com.github.vfyjxf.nee.processor.RecipeProcessor;
import com.github.vfyjxf.nee.utils.ItemUtils;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;

public class NEECommands
extends CommandBase {
    public String func_71517_b() {
        return "nee";
    }

    public String func_71518_a(ICommandSender sender) {
        return "See /nee help";
    }

    public void func_71515_b(ICommandSender sender, String[] args) {
        if (args.length != 0) {
            if ("help".equalsIgnoreCase(args[0])) {
                sender.func_145747_a((IChatComponent)new ChatComponentText("Usage:"));
                sender.func_145747_a((IChatComponent)new ChatComponentText("/nee add blacklist/priorityItem processor_id identifier"));
                sender.func_145747_a((IChatComponent)new ChatComponentText("/nee add blacklist/priorityItem/itemCombination identifier"));
            } else if ("processor".equalsIgnoreCase(args[0])) {
                for (IRecipeProcessor processor : RecipeProcessor.recipeProcessors) {
                    NotEnoughEnergistics.logger.info("RecipeProcessor:" + processor.getRecipeProcessorId() + "  identifier:");
                    for (String ident : processor.getAllOverlayIdentifier()) {
                        NotEnoughEnergistics.logger.info(ident);
                    }
                }
            } else if ("add".equalsIgnoreCase(args[0]) && args.length > 1) {
                if ("blacklist".equalsIgnoreCase(args[1]) || "priorityItem".equalsIgnoreCase(args[1])) {
                    ItemStack currentStack = Minecraft.func_71410_x().field_71439_g.func_71045_bC();
                    if (currentStack != null) {
                        String currentItemJsonString = ItemUtils.toItemJsonString(currentStack);
                        JsonObject itemJsonObject = new JsonParser().parse(currentItemJsonString).getAsJsonObject();
                        if (args.length >= 3) {
                            boolean hasRecipeProcessor = ItemUtils.hasRecipeProcessor(args[2]);
                            boolean hasOverlayIdentifier = ItemUtils.hasOverlayIdentifier(args[2]);
                            if (args.length == 4) {
                                hasOverlayIdentifier = ItemUtils.hasOverlayIdentifier(args[3]);
                            }
                            if (hasRecipeProcessor) {
                                itemJsonObject.addProperty("recipeProcessor", args[2]);
                            } else if (!hasOverlayIdentifier) {
                                sender.func_145747_a((IChatComponent)new ChatComponentText("Can't find processor: " + args[2]));
                            }
                            if (hasOverlayIdentifier) {
                                itemJsonObject.addProperty("identifier", args.length == 4 ? args[3] : args[2]);
                            } else if (!hasRecipeProcessor) {
                                sender.func_145747_a((IChatComponent)new ChatComponentText("Can't find identifier: " + args[2]));
                            }
                        }
                        String newJsonString = new Gson().toJson((JsonElement)itemJsonObject);
                        String[] oldList = "blacklist".equalsIgnoreCase(args[1]) ? NEEConfig.transformBlacklist : NEEConfig.transformPriorityList;
                        ArrayList<String> newList = new ArrayList<String>(Arrays.asList(oldList));
                        for (String currentJsonString : oldList) {
                            if (!currentJsonString.equals(newJsonString)) continue;
                            return;
                        }
                        newList.add(newJsonString);
                        if ("blacklist".equalsIgnoreCase(args[1])) {
                            NEEConfig.setTransformBlacklist(newList.toArray(new String[0]));
                        } else {
                            NEEConfig.setTransformPriorityList(newList.toArray(new String[0]));
                        }
                    }
                } else if ("priorityMod".equalsIgnoreCase(args[1]) && args.length == 3) {
                    String modid = args[2];
                    if (!ItemUtils.hasModId(modid)) {
                        ArrayList<String> newList = new ArrayList<String>(Arrays.asList(NEEConfig.transformPriorityModList));
                        newList.add(modid);
                        NEEConfig.setTransformPriorityModList(newList.toArray(new String[0]));
                    }
                } else if ("itemCombination".equalsIgnoreCase(args[1]) && args.length == 3) {
                    String identifier = args[2];
                    if (!Arrays.asList(NEEConfig.itemCombinationWhitelist).contains(identifier)) {
                        if (ItemUtils.hasOverlayIdentifier(args[2])) {
                            ArrayList<String> newLists = new ArrayList<String>(Arrays.asList(NEEConfig.itemCombinationWhitelist));
                            newLists.add(identifier);
                            NEEConfig.setItemCombinationWhitelist(newLists.toArray(new String[0]));
                        } else {
                            sender.func_145747_a((IChatComponent)new ChatComponentText("Can't find identifier: " + args[2]));
                        }
                    }
                }
            } else if ("reload".equalsIgnoreCase(args[0])) {
                NEEConfig.reload();
            }
        } else {
            throw new WrongUsageException("", new Object[0]);
        }
    }

    public List func_71516_a(ICommandSender sender, String[] args) {
        return args.length <= 1 ? CommandBase.func_71530_a((String[])args, (String[])new String[]{"help", "reload", "add", "processor"}) : (args.length == 2 ? CommandBase.func_71530_a((String[])args, (String[])new String[]{"blacklist", "priorityItem", "priorityMod", "itemCombination"}) : null);
    }

    public int func_82362_a() {
        return 1;
    }

    public boolean func_71519_b(ICommandSender sender) {
        return true;
    }
}

