/*
 * Decompiled with CFR 0.152.
 */
package openblocks.client.renderer.tileentity.guide;

import openblocks.client.renderer.tileentity.guide.IGuideRenderer;
import openblocks.client.renderer.tileentity.guide.MarkerRenderer;
import openblocks.common.tileentity.TileEntityGuide;
import openblocks.shapes.CoordShape;
import openmods.utils.TextureUtils;
import org.lwjgl.opengl.GL11;

public class GuideAdvancedRenderer
implements IGuideRenderer {
    private final MarkerRenderer mr;

    public GuideAdvancedRenderer(Runnable marker) {
        this.mr = new MarkerRenderer(marker);
    }

    @Override
    public void renderShape(TileEntityGuide guide) {
        CoordShape toDelete;
        float scaleDelta = guide.getTimeSinceChange();
        this.renderShape(guide.getShape(), guide.getColor(), scaleDelta);
        if ((double)scaleDelta < 1.0) {
            this.renderShape(guide.getPreviousShape(), guide.getColor(), 1.0f - scaleDelta);
        }
        if ((toDelete = guide.getAndDeleteShape()) != null && this.mr != null) {
            this.mr.deleteShape(toDelete);
        }
    }

    private void renderShape(CoordShape shape, int color, float scale) {
        if (shape == null) {
            return;
        }
        TextureUtils.bindDefaultTerrainTexture();
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)1);
        GL11.glDisable((int)2896);
        this.mr.drawInstanced(shape, color, scale);
        GL11.glEnable((int)2896);
        GL11.glDisable((int)3042);
    }

    @Override
    public void onTextureChange() {
        this.mr.reset();
    }
}

