/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.item.ItemExpireEvent;
import openblocks.common.item.ItemLuggage;
import openmods.utils.EntityUtils;

public class LuggageDropHandler {
    private static boolean shouldPreventDespawn(EntityItem entity) {
        ItemStack stack = entity.func_92059_d();
        if (stack == null) {
            return false;
        }
        return stack.func_77973_b() instanceof ItemLuggage && stack.func_77942_o();
    }

    @SubscribeEvent
    public void onItemDrop(EntityJoinWorldEvent evt) {
        Entity entity = evt.entity;
        if (entity instanceof EntityItem && LuggageDropHandler.shouldPreventDespawn((EntityItem)entity)) {
            EntityUtils.setEntityInvulnerable((Entity)entity, (boolean)true);
        }
    }

    @SubscribeEvent
    public void onItemExpire(ItemExpireEvent evt) {
        if (LuggageDropHandler.shouldPreventDespawn(evt.entityItem)) {
            evt.extraLife += 19880127;
            evt.setCanceled(true);
        }
    }
}

