/*
 * Decompiled with CFR 0.152.
 */
package li.cil.repack.org.luaj.vm2.ast;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import li.cil.repack.org.luaj.vm2.ast.Variable;

public class NameScope {
    private static final Set<String> LUA_KEYWORDS;
    public final Map<String, Variable> namedVariables = new HashMap<String, Variable>();
    public final NameScope outerScope;
    public int functionNestingCount;

    public NameScope() {
        this.outerScope = null;
        this.functionNestingCount = 0;
    }

    public NameScope(NameScope outerScope) {
        this.outerScope = outerScope;
        this.functionNestingCount = outerScope != null ? outerScope.functionNestingCount : 0;
    }

    public Variable find(String name) throws IllegalArgumentException {
        this.validateIsNotKeyword(name);
        NameScope n = this;
        while (n != null) {
            if (n.namedVariables.containsKey(name)) {
                return n.namedVariables.get(name);
            }
            n = n.outerScope;
        }
        Variable value = new Variable(name);
        this.namedVariables.put(name, value);
        return value;
    }

    public Variable define(String name) throws IllegalStateException, IllegalArgumentException {
        this.validateIsNotKeyword(name);
        Variable value = new Variable(name, this);
        this.namedVariables.put(name, value);
        return value;
    }

    private void validateIsNotKeyword(String name) {
        if (LUA_KEYWORDS.contains(name)) {
            throw new IllegalArgumentException("name is a keyword: '" + name + "'");
        }
    }

    static {
        String[] k;
        LUA_KEYWORDS = new HashSet<String>();
        for (String element : k = new String[]{"and", "break", "do", "else", "elseif", "end", "false", "for", "function", "if", "in", "local", "nil", "not", "or", "repeat", "return", "then", "true", "until", "while"}) {
            LUA_KEYWORDS.add(element);
        }
    }
}

