/*
 * Decompiled with CFR 0.152.
 */
package com.bymarcin.openglasses.surface;

import com.bymarcin.openglasses.lua.LuaReference;
import com.bymarcin.openglasses.surface.IRenderableWidget;
import com.bymarcin.openglasses.surface.WidgetType;
import com.bymarcin.openglasses.surface.widgets.core.AttributeRegistry;
import com.bymarcin.openglasses.surface.widgets.core.attribute.IAttribute;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.HashMap;
import net.minecraft.nbt.NBTTagCompound;

public abstract class Widget
implements IAttribute {
    boolean isVisable = true;

    public abstract void writeData(ByteBuf var1);

    public abstract void readData(ByteBuf var1);

    public final void write(ByteBuf buff) {
        buff.writeBoolean(this.isVisable);
        this.writeData(buff);
    }

    public final void read(ByteBuf buff) {
        this.isVisable = buff.readBoolean();
        this.readData(buff);
    }

    public void writeToNBT(NBTTagCompound nbt) {
        ByteBuf buff = Unpooled.buffer();
        this.write(buff);
        nbt.func_74773_a("WidgetData", buff.array());
    }

    public void readFromNBT(NBTTagCompound nbt) {
        if (!nbt.func_74764_b("WidgetData")) {
            return;
        }
        byte[] b = nbt.func_74770_j("WidgetData");
        ByteBuf buff = Unpooled.copiedBuffer((byte[])b);
        this.read(buff);
    }

    public Object[] getLuaObject(LuaReference ref) {
        HashMap<String, Object> luaObject = new HashMap<String, Object>();
        Class<?> current = this.getClass();
        do {
            for (Class<?> a : current.getInterfaces()) {
                if (!IAttribute.class.isAssignableFrom(a)) continue;
                luaObject.putAll(AttributeRegistry.getFunctions(a.asSubclass(IAttribute.class), ref));
            }
        } while (!(current = current.getSuperclass()).equals(Object.class));
        return new Object[]{luaObject};
    }

    public abstract WidgetType getType();

    @SideOnly(value=Side.CLIENT)
    public abstract IRenderableWidget getRenderable();

    public boolean isVisible() {
        return this.isVisable;
    }

    public void setVisable(boolean isVisable) {
        this.isVisable = isVisable;
    }
}

