/*
 * Decompiled with CFR 0.152.
 */
package com.bymarcin.openglasses.network.packet;

import com.bymarcin.openglasses.OpenGlasses;
import com.bymarcin.openglasses.network.Packet;
import com.bymarcin.openglasses.surface.ServerSurface;
import com.bymarcin.openglasses.utils.Location;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayer;
import org.apache.logging.log4j.Level;

public class GlassesEventPacket
extends Packet<GlassesEventPacket, IMessage> {
    EventType eventType;
    Location UUID;
    String player;

    public GlassesEventPacket(EventType eventType, Location UUID, EntityPlayer player) {
        this.player = player.func_146103_bH().getName();
        this.eventType = eventType;
        this.UUID = UUID;
    }

    public GlassesEventPacket() {
    }

    @Override
    protected void read() throws IOException {
        this.player = this.readString();
        this.eventType = EventType.values()[this.readInt()];
        if (EventType.UNEQUIPED_GLASSES == this.eventType) {
            return;
        }
        this.UUID = new Location(this.readInt(), this.readInt(), this.readInt(), this.readInt(), this.readLong());
    }

    @Override
    protected void write() throws IOException {
        this.writeString(this.player);
        this.writeInt(this.eventType.ordinal());
        if (EventType.UNEQUIPED_GLASSES == this.eventType) {
            return;
        }
        this.writeInt(this.UUID.x);
        this.writeInt(this.UUID.y);
        this.writeInt(this.UUID.z);
        this.writeInt(this.UUID.dimID);
        this.writeLong(this.UUID.uniqueKey);
    }

    @Override
    protected IMessage executeOnClient() {
        return null;
    }

    @Override
    protected IMessage executeOnServer() {
        OpenGlasses.logger.log(Level.INFO, "PACKET:" + (Object)((Object)this.eventType) + ":" + this.player);
        switch (this.eventType) {
            case EQUIPED_GLASSES: {
                ServerSurface.instance.subscribePlayer(this.player, this.UUID);
                break;
            }
            case UNEQUIPED_GLASSES: {
                ServerSurface.instance.unsubscribePlayer(this.player);
                break;
            }
        }
        return null;
    }

    public static enum EventType {
        EQUIPED_GLASSES,
        UNEQUIPED_GLASSES;

    }
}

