/*
 * Decompiled with CFR 0.152.
 */
package openmods.calc.parsing;

import com.google.common.collect.PeekingIterator;
import openmods.calc.IExecutable;
import openmods.calc.parsing.IPostfixCompilerState;
import openmods.calc.parsing.ITokenStreamCompiler;
import openmods.calc.parsing.Token;
import openmods.calc.parsing.TokenType;
import openmods.utils.Stack;

public abstract class PostfixCompiler<E>
implements ITokenStreamCompiler<E> {
    @Override
    public IExecutable<E> compile(PeekingIterator<Token> input) {
        Stack<IPostfixCompilerState<IPostfixCompilerState<E>>> stateStack = Stack.create();
        stateStack.push(this.createInitialState());
        block4: while (input.hasNext()) {
            Token token = (Token)input.next();
            if (token.type == TokenType.MODIFIER) {
                stateStack.push(this.createStateForModifier(token.value));
                continue;
            }
            if (token.type == TokenType.LEFT_BRACKET) {
                stateStack.push(this.createStateForBracket(token.value));
                continue;
            }
            IPostfixCompilerState currentState = (IPostfixCompilerState)stateStack.peek(0);
            IPostfixCompilerState.Result result = currentState.acceptToken(token);
            switch (result) {
                case ACCEPTED_AND_FINISHED: {
                    this.unwindStack(stateStack);
                }
                case ACCEPTED: {
                    continue block4;
                }
            }
            throw new IllegalStateException("Token  " + token + " not accepted in state " + currentState);
        }
        IPostfixCompilerState finalState = (IPostfixCompilerState)stateStack.popAndExpectEmptyStack();
        return finalState.exit();
    }

    private void unwindStack(Stack<IPostfixCompilerState<E>> stateStack) {
        IPostfixCompilerState<E> currentState = stateStack.pop();
        block4: while (true) {
            IExecutable<E> exitResult = currentState.exit();
            currentState = stateStack.peek(0);
            IPostfixCompilerState.Result acceptResult = currentState.acceptExecutable(exitResult);
            switch (acceptResult) {
                case ACCEPTED_AND_FINISHED: {
                    stateStack.pop();
                    continue block4;
                }
                case ACCEPTED: {
                    break block4;
                }
                default: {
                    throw new IllegalStateException("Executable  " + exitResult + " not accepted in state " + currentState);
                }
            }
            break;
        }
    }

    protected abstract IPostfixCompilerState<E> createInitialState();

    protected IPostfixCompilerState<E> createStateForModifier(String modifier) {
        throw new UnsupportedOperationException(modifier);
    }

    protected IPostfixCompilerState<E> createStateForBracket(String bracket) {
        throw new UnsupportedOperationException(bracket);
    }
}

