/*
 * Decompiled with CFR 0.152.
 */
package openmods.gui.component;

import net.minecraft.client.Minecraft;
import net.minecraft.util.MathHelper;
import openmods.api.IValueReceiver;
import openmods.gui.component.BaseComponent;
import openmods.gui.listener.IValueChangedListener;
import org.lwjgl.opengl.GL11;

public class GuiComponentSlider
extends BaseComponent
implements IValueReceiver<Integer> {
    private static final int HANDLE_SIZE = 8;
    private int width;
    private int min;
    private int max;
    private int value;
    private double stepSize;
    private boolean showValue = true;
    private IValueChangedListener<Integer> listener;

    public GuiComponentSlider(int x, int y, int width, int min, int max, int initialValue, boolean showValue) {
        this(x, y, width, min, max, initialValue);
        this.showValue = showValue;
    }

    public GuiComponentSlider(int x, int y, int width, int min, int max, int initialValue) {
        super(x, y);
        this.width = width;
        this.min = min;
        this.max = max;
        this.value = initialValue;
        int steps = max - min + 1;
        this.stepSize = (double)(width - 8 - 2) / (double)steps;
    }

    @Override
    public void render(Minecraft minecraft, int offsetX, int offsetY, int mouseX, int mouseY) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int left = offsetX + this.x;
        int top = offsetY + this.y;
        int barStartX = left + 1;
        GuiComponentSlider.bindComponentsSheet();
        this.func_73729_b(left, top, 0, 70, 1, this.getHeight());
        GL11.glPushMatrix();
        GL11.glTranslated((double)(left + 1), (double)top, (double)0.0);
        GL11.glScaled((double)(this.getWidth() - 2), (double)1.0, (double)1.0);
        this.func_73729_b(0, 0, 1, 70, 1, this.getHeight());
        GL11.glPopMatrix();
        this.func_73729_b(left + this.getWidth() - 1, top, 2, 70, 1, this.getHeight());
        int handleX = (int)Math.floor((double)barStartX + this.stepSize * (double)(this.value - this.min + 1));
        this.func_73729_b(handleX, top + 1, 3, 70, 9, 10);
        if (this.showValue) {
            String label = this.formatValue(this.value);
            int strWidth = minecraft.field_71466_p.func_78256_a(label);
            minecraft.field_71466_p.func_78276_b(label, handleX + 4 - strWidth / 2, top + 15, 0x404040);
        }
    }

    @Override
    public void renderOverlay(Minecraft minecraft, int offsetX, int offsetY, int mouseX, int mouseY) {
    }

    @Override
    public void mouseDrag(int mouseX, int mouseY, int button, long time) {
        super.mouseDrag(mouseX, mouseY, button, time);
        if (button == 0) {
            int offX = mouseX - 4;
            if (offX < 0) {
                return;
            }
            int newValue = this.min + MathHelper.func_76128_c((double)((double)offX / this.stepSize));
            int boundedValue = Math.max(this.min, Math.min(this.max, newValue));
            if (boundedValue != this.value) {
                this.value = boundedValue;
                if (this.listener != null) {
                    this.listener.valueChanged(this.value);
                }
            }
        }
    }

    public String formatValue(int value) {
        return Integer.toString(value);
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return 12;
    }

    public int getValue() {
        return this.value;
    }

    @Override
    public void setValue(Integer value) {
        this.value = value;
    }

    public void setListener(IValueChangedListener<Integer> listener) {
        this.listener = listener;
    }
}

