/*
 * Decompiled with CFR 0.152.
 */
package openmodularturrets.network.messages;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import openmodularturrets.tileentity.turretbase.TurretBase;
import openmodularturrets.util.PlayerUtil;

public class MessageAdjustYAxisDetect
implements IMessage {
    private int x;
    private int y;
    private int z;
    private int y_axis_detect;

    public MessageAdjustYAxisDetect() {
    }

    public MessageAdjustYAxisDetect(int x, int y, int z, int y_axis_detect) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.y_axis_detect = y_axis_detect;
    }

    public void fromBytes(ByteBuf buf) {
        this.x = buf.readInt();
        this.y = buf.readInt();
        this.z = buf.readInt();
        this.y_axis_detect = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.x);
        buf.writeInt(this.y);
        buf.writeInt(this.z);
        buf.writeInt(this.y_axis_detect);
    }

    private int getX() {
        return this.x;
    }

    private int getY() {
        return this.y;
    }

    private int getZ() {
        return this.z;
    }

    private int getYAxisDetect() {
        return this.y_axis_detect;
    }

    public static class MessageHandlerAdjustYAxisDetect
    implements IMessageHandler<MessageAdjustYAxisDetect, IMessage> {
        public IMessage onMessage(MessageAdjustYAxisDetect message, MessageContext ctx) {
            World world = ctx.getServerHandler().field_147369_b.func_130014_f_();
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            TileEntity entity = world.func_147438_o(message.getX(), message.getY(), message.getZ());
            TurretBase turret = null;
            if (entity instanceof TurretBase) {
                turret = (TurretBase)entity;
            }
            if (turret != null && PlayerUtil.isPlayerAdmin((EntityPlayer)player, turret)) {
                turret.setyAxisDetect(message.getYAxisDetect());
            }
            return null;
        }
    }
}

