/*
 * Decompiled with CFR 0.152.
 */
package openmodularturrets.network.messages;

import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import openmodularturrets.ModularTurrets;
import openmodularturrets.tileentity.turretbase.TrustedPlayer;
import openmodularturrets.tileentity.turretbase.TurretBase;

public class MessageTurretBase
implements IMessage {
    private int x;
    private int y;
    private int z;
    private int rfStorage;
    private int yAxisDetect;
    private boolean attacksMobs;
    private boolean attacksNeutrals;
    private boolean attacksPlayers;
    private boolean multiTargeting;
    private boolean waitForTrustedPlayer;
    private String owner;
    private String ownerName;
    private List<TrustedPlayer> trustedPlayers = new ArrayList<TrustedPlayer>();
    private ItemStack camoStack;

    public MessageTurretBase() {
    }

    public MessageTurretBase(TileEntity tileEntity) {
        if (tileEntity instanceof TurretBase) {
            TurretBase TurretBase2 = (TurretBase)tileEntity;
            this.x = TurretBase2.field_145851_c;
            this.y = TurretBase2.field_145848_d;
            this.z = TurretBase2.field_145849_e;
            this.owner = TurretBase2.getOwner();
            this.ownerName = TurretBase2.getOwnerName();
            this.rfStorage = TurretBase2.getEnergyStored(ForgeDirection.UNKNOWN);
            this.yAxisDetect = TurretBase2.getyAxisDetect();
            this.attacksMobs = TurretBase2.isAttacksMobs();
            this.attacksNeutrals = TurretBase2.isAttacksNeutrals();
            this.attacksPlayers = TurretBase2.isAttacksPlayers();
            this.multiTargeting = TurretBase2.isMultiTargeting();
            this.trustedPlayers = TurretBase2.getTrustedPlayers();
            this.waitForTrustedPlayer = TurretBase2.waitForTrustedPlayer;
            this.camoStack = TurretBase2.camoStack;
        }
    }

    public void fromBytes(ByteBuf buf) {
        this.x = buf.readInt();
        this.y = buf.readInt();
        this.z = buf.readInt();
        int ownerLength = buf.readInt();
        this.owner = new String(buf.readBytes(ownerLength).array());
        int ownerNameLength = buf.readInt();
        this.ownerName = new String(buf.readBytes(ownerNameLength).array());
        this.rfStorage = buf.readInt();
        this.yAxisDetect = buf.readInt();
        this.attacksMobs = buf.readBoolean();
        this.attacksNeutrals = buf.readBoolean();
        this.attacksPlayers = buf.readBoolean();
        this.multiTargeting = buf.readBoolean();
        this.waitForTrustedPlayer = buf.readBoolean();
        this.camoStack = ByteBufUtils.readItemStack((ByteBuf)buf);
        int lengthOfTPList = buf.readInt();
        if (lengthOfTPList > 0) {
            for (int i = 0; i < lengthOfTPList; ++i) {
                int length = buf.readInt();
                String name = new String(buf.readBytes(length).array());
                TrustedPlayer trustedPlayer = new TrustedPlayer(name);
                length = buf.readInt();
                trustedPlayer.uuid = UUID.fromString(new String(buf.readBytes(length).array()));
                trustedPlayer.canOpenGUI = buf.readBoolean();
                trustedPlayer.canChangeTargeting = buf.readBoolean();
                trustedPlayer.admin = buf.readBoolean();
                this.trustedPlayers.add(trustedPlayer);
            }
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.x);
        buf.writeInt(this.y);
        buf.writeInt(this.z);
        buf.writeInt(this.owner.length());
        buf.writeBytes(this.owner.getBytes());
        buf.writeInt(this.ownerName.length());
        buf.writeBytes(this.ownerName.getBytes());
        buf.writeInt(this.rfStorage);
        buf.writeInt(this.yAxisDetect);
        buf.writeBoolean(this.attacksMobs);
        buf.writeBoolean(this.attacksNeutrals);
        buf.writeBoolean(this.attacksPlayers);
        buf.writeBoolean(this.multiTargeting);
        buf.writeBoolean(this.waitForTrustedPlayer);
        ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)this.camoStack);
        buf.writeInt(this.trustedPlayers.size());
        if (this.trustedPlayers.size() > 0) {
            for (TrustedPlayer trustedPlayer : this.trustedPlayers) {
                buf.writeInt(trustedPlayer.getName().length());
                buf.writeBytes(trustedPlayer.getName().getBytes());
                buf.writeInt(trustedPlayer.uuid.toString().length());
                buf.writeBytes(trustedPlayer.uuid.toString().getBytes());
                buf.writeBoolean(trustedPlayer.canOpenGUI);
                buf.writeBoolean(trustedPlayer.canChangeTargeting);
                buf.writeBoolean(trustedPlayer.admin);
            }
        }
    }

    public static class MessageHandlerTurretBase
    implements IMessageHandler<MessageTurretBase, IMessage> {
        public IMessage onMessage(MessageTurretBase message, MessageContext ctx) {
            TileEntity tileEntity = ModularTurrets.proxy.getWorld().func_147438_o(message.x, message.y, message.z);
            if (tileEntity instanceof TurretBase) {
                ((TurretBase)tileEntity).setOwner(message.owner);
                ((TurretBase)tileEntity).setOwnerName(message.ownerName);
                ((TurretBase)tileEntity).setEnergyStored(message.rfStorage);
                ((TurretBase)tileEntity).setyAxisDetect(message.yAxisDetect);
                ((TurretBase)tileEntity).setAttacksMobs(message.attacksMobs);
                ((TurretBase)tileEntity).setAttacksNeutrals(message.attacksNeutrals);
                ((TurretBase)tileEntity).setAttacksPlayers(message.attacksPlayers);
                ((TurretBase)tileEntity).setMultiTargeting(message.multiTargeting);
                ((TurretBase)tileEntity).setTrustedPlayers(message.trustedPlayers);
                ((TurretBase)tileEntity).waitForTrustedPlayer = message.waitForTrustedPlayer;
                ((TurretBase)tileEntity).camoStack = message.camoStack;
            }
            return null;
        }
    }
}

