/*
 * Decompiled with CFR 0.152.
 */
package openmodularturrets.tileentity.turretbase;

import cofh.api.energy.EnergyStorage;
import cofh.api.energy.IEnergyHandler;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import gregtech.api.interfaces.tileentity.IEnergyConnected;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.logging.Logger;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.SimpleComponent;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.Packet;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import openmodularturrets.compatability.ModCompatibility;
import openmodularturrets.handler.ConfigHandler;
import openmodularturrets.handler.NetworkingHandler;
import openmodularturrets.network.messages.MessageTurretBase;
import openmodularturrets.tileentity.TileEntityContainer;
import openmodularturrets.tileentity.turretbase.TrustedPlayer;
import openmodularturrets.util.MathUtil;
import openmodularturrets.util.PlayerUtil;
import openmodularturrets.util.TurretHeadUtil;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.aspects.IAspectContainer;
import thaumcraft.api.aspects.IEssentiaTransport;
import thaumcraft.api.visnet.VisNetHandler;

@Optional.InterfaceList(value={@Optional.Interface(iface="dan200.computercraft.api.peripheral.IPeripheral", modid="ComputerCraft"), @Optional.Interface(iface="li.cil.oc.api.network.SimpleComponent", modid="OpenComputers"), @Optional.Interface(iface="thaumcraft.api.aspects.IAspectContainer", modid="Thaumcraft"), @Optional.Interface(iface="thaumcraft.api.aspects.IEssentiaTransport", modid="Thaumcraft"), @Optional.Interface(iface="gregtech.api.interfaces.tileentity.IEnergyConnected", modid="gregtech")})
public abstract class TurretBase
extends TileEntityContainer
implements IEnergyHandler,
SimpleComponent,
ISidedInventory,
IEssentiaTransport,
IAspectContainer,
IPeripheral,
IEnergyConnected {
    public int trustedPlayerIndex = 0;
    public ItemStack camoStack;
    public boolean shouldConcealTurrets;
    private boolean multiTargeting = false;
    private final EnergyStorage storage;
    private int yAxisDetect = 2;
    private boolean attacksMobs;
    private boolean attacksNeutrals;
    private boolean attacksPlayers;
    private String owner = "";
    private String ownerName = "";
    private List<TrustedPlayer> trustedPlayers;
    private int ticks;
    private boolean active;
    private boolean inverted;
    private boolean redstone;
    private boolean checkRedstone = false;
    private boolean computerAccessible = false;
    private float amountOfPotentia = 0.0f;
    private final float maxAmountOfPotentia = ConfigHandler.getPotentiaAddonCapacity();
    private ArrayList<IComputerAccess> comp;
    private double storageEU;
    private boolean wasAddedToEnergyNet = false;
    public boolean waitForTrustedPlayer = false;

    public TurretBase(int MaxEnergyStorage, int MaxIO) {
        this.storage = new EnergyStorage(MaxEnergyStorage, MaxIO);
        this.attacksMobs = true;
        this.attacksNeutrals = true;
        this.attacksPlayers = false;
        this.trustedPlayers = new ArrayList<TrustedPlayer>();
        this.inv = new ItemStack[this.func_70302_i_()];
        this.inverted = true;
        this.active = true;
        this.ticks = 0;
    }

    private static void updateRedstoneReactor(TurretBase base) {
        if (!TurretHeadUtil.hasRedstoneReactor(base)) {
            return;
        }
        if (ConfigHandler.getRedstoneReactorAddonGen() < base.getMaxEnergyStored(ForgeDirection.UNKNOWN) - base.getEnergyStored(ForgeDirection.UNKNOWN)) {
            ItemStack redstoneBlock = TurretHeadUtil.useSpecificItemStackBlockFromBase(base, new ItemStack(Blocks.field_150451_bX));
            if (redstoneBlock == null) {
                redstoneBlock = TurretHeadUtil.getSpecificItemFromInvExpanders(base.func_145831_w(), new ItemStack(Blocks.field_150451_bX), base);
            }
            if (redstoneBlock != null && ConfigHandler.getRedstoneReactorAddonGen() * 9 < base.getMaxEnergyStored(ForgeDirection.UNKNOWN) - base.getEnergyStored(ForgeDirection.UNKNOWN)) {
                base.storage.modifyEnergyStored(ConfigHandler.getRedstoneReactorAddonGen() * 9);
                return;
            }
            ItemStack redstone = TurretHeadUtil.useSpecificItemStackItemFromBase(base, Items.field_151137_ax);
            if (redstone == null) {
                redstone = TurretHeadUtil.getSpecificItemFromInvExpanders(base.func_145831_w(), new ItemStack(Items.field_151137_ax), base);
            }
            if (redstone != null) {
                base.storage.modifyEnergyStored(ConfigHandler.getRedstoneReactorAddonGen());
            }
        }
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.onChunkUnload();
    }

    public void onChunkUnload() {
    }

    private int getMaxEnergyStorageWithExtenders() {
        int tier = this.getBaseTier();
        switch (tier) {
            case 1: {
                return ConfigHandler.getBaseTierOneMaxCharge() + TurretHeadUtil.getPowerExpanderTotalExtraCapacity(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
            case 2: {
                return ConfigHandler.getBaseTierTwoMaxCharge() + TurretHeadUtil.getPowerExpanderTotalExtraCapacity(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
            case 3: {
                return ConfigHandler.getBaseTierThreeMaxCharge() + TurretHeadUtil.getPowerExpanderTotalExtraCapacity(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
            case 4: {
                return ConfigHandler.getBaseTierFourMaxCharge() + TurretHeadUtil.getPowerExpanderTotalExtraCapacity(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
            case 5: {
                return ConfigHandler.getBaseTierFiveMaxCharge() + TurretHeadUtil.getPowerExpanderTotalExtraCapacity(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
        }
        return 0;
    }

    public boolean addTrustedPlayer(String name) {
        this.waitForTrustedPlayer = false;
        TrustedPlayer trustedPlayer = new TrustedPlayer(name);
        trustedPlayer.uuid = PlayerUtil.getPlayerUUID(name);
        if (!PlayerUtil.isPlayerNameValid(name)) {
            return false;
        }
        if (ConfigHandler.offlineModeSupport && trustedPlayer.getName().equals(this.getOwnerName())) {
            return false;
        }
        if (trustedPlayer.uuid == null || trustedPlayer.uuid.toString().equals(this.getOwnerName())) {
            return false;
        }
        if (trustedPlayer.uuid != null || ConfigHandler.offlineModeSupport) {
            for (TrustedPlayer player : this.trustedPlayers) {
                if (!(ConfigHandler.offlineModeSupport ? player.getName().equalsIgnoreCase(name) || player.getName().equals(this.getOwnerName()) : player.getName().equalsIgnoreCase(name) || trustedPlayer.uuid.toString().equals(this.owner))) continue;
                return false;
            }
            this.trustedPlayers.add(trustedPlayer);
            return true;
        }
        return false;
    }

    public boolean removeTrustedPlayer(String name) {
        for (TrustedPlayer player : this.trustedPlayers) {
            if (!player.getName().equals(name)) continue;
            this.trustedPlayers.remove(player);
            return true;
        }
        return false;
    }

    public List<TrustedPlayer> getTrustedPlayers() {
        return this.trustedPlayers;
    }

    public TrustedPlayer getTrustedPlayer(String name) {
        for (TrustedPlayer trustedPlayer : this.trustedPlayers) {
            if (!trustedPlayer.name.equals(name)) continue;
            return trustedPlayer;
        }
        return null;
    }

    public TrustedPlayer getTrustedPlayer(UUID uuid) {
        for (TrustedPlayer trustedPlayer : this.trustedPlayers) {
            if (!trustedPlayer.uuid.equals(uuid)) continue;
            return trustedPlayer;
        }
        return null;
    }

    public void setTrustedPlayers(List<TrustedPlayer> list) {
        this.trustedPlayers = list;
    }

    private NBTTagList getTrustedPlayersAsNBT() {
        NBTTagList nbt = new NBTTagList();
        for (TrustedPlayer trustedPlayer : this.trustedPlayers) {
            NBTTagCompound nbtPlayer = new NBTTagCompound();
            nbtPlayer.func_74778_a("name", trustedPlayer.name);
            nbtPlayer.func_74757_a("canOpenGUI", trustedPlayer.canOpenGUI);
            nbtPlayer.func_74757_a("canChangeTargeting", trustedPlayer.canChangeTargeting);
            nbtPlayer.func_74757_a("admin", trustedPlayer.admin);
            if (trustedPlayer.uuid != null) {
                nbtPlayer.func_74778_a("UUID", trustedPlayer.uuid.toString());
            } else if (PlayerUtil.getPlayerUUID(trustedPlayer.name) != null) {
                nbtPlayer.func_74778_a("UUID", PlayerUtil.getPlayerUUID(trustedPlayer.name).toString());
            }
            nbt.func_74742_a((NBTBase)nbtPlayer);
        }
        return nbt;
    }

    private void buildTrustedPlayersFromNBT(NBTTagList nbt) {
        this.trustedPlayers.clear();
        for (int i = 0; i < nbt.func_74745_c(); ++i) {
            if (!nbt.func_150305_b(i).func_74779_i("name").equals("")) {
                NBTTagCompound nbtPlayer = nbt.func_150305_b(i);
                TrustedPlayer trustedPlayer = new TrustedPlayer(nbtPlayer.func_74779_i("name"));
                trustedPlayer.canOpenGUI = nbtPlayer.func_74767_n("canOpenGUI");
                trustedPlayer.canChangeTargeting = nbtPlayer.func_74767_n("canChangeTargeting");
                trustedPlayer.admin = nbtPlayer.func_74767_n("admin");
                trustedPlayer.uuid = nbtPlayer.func_74764_b("UUID") ? PlayerUtil.getPlayerUIDUnstable(nbtPlayer.func_74779_i("UUID")) : PlayerUtil.getPlayerUUID(trustedPlayer.name);
                if (trustedPlayer.uuid == null) continue;
                this.trustedPlayers.add(trustedPlayer);
                continue;
            }
            if (!nbt.func_150305_b(i).func_74779_i("name").equals("")) continue;
            TrustedPlayer trustedPlayer = new TrustedPlayer(nbt.func_150307_f(i));
            Logger.getGlobal().info("found legacy trusted Player: " + nbt.func_150307_f(i));
            trustedPlayer.uuid = PlayerUtil.getPlayerUUID(trustedPlayer.name);
            if (trustedPlayer.uuid == null) continue;
            this.trustedPlayers.add(trustedPlayer);
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound par1) {
        super.func_145841_b(par1);
        par1.func_74768_a("maxStorage", this.storage.getMaxEnergyStored());
        par1.func_74768_a("energyStored", this.getEnergyStored(ForgeDirection.UNKNOWN));
        par1.func_74776_a("amountOfPotentia", this.amountOfPotentia);
        par1.func_74768_a("maxIO", this.storage.getMaxReceive());
        par1.func_74768_a("yAxisDetect", this.yAxisDetect);
        par1.func_74757_a("attacksMobs", this.attacksMobs);
        par1.func_74757_a("attacksNeutrals", this.attacksNeutrals);
        par1.func_74757_a("attacksPlayers", this.attacksPlayers);
        if (ConfigHandler.offlineModeSupport && !this.ownerName.isEmpty()) {
            par1.func_74778_a("owner", this.ownerName);
        } else if (!ConfigHandler.offlineModeSupport) {
            par1.func_74778_a("owner", this.owner);
        }
        if (this.ownerName.isEmpty() && PlayerUtil.getPlayerNameFromUUID(this.owner) != null) {
            this.ownerName = PlayerUtil.getPlayerNameFromUUID(this.owner);
        }
        par1.func_74778_a("ownerName", this.ownerName);
        par1.func_74782_a("trustedPlayers", (NBTBase)this.getTrustedPlayersAsNBT());
        par1.func_74757_a("active", this.active);
        par1.func_74757_a("inverted", this.inverted);
        par1.func_74757_a("redstone", this.redstone);
        par1.func_74757_a("computerAccessible", this.computerAccessible);
        par1.func_74757_a("shouldConcealTurrets", this.shouldConcealTurrets);
        par1.func_74757_a("multiTargeting", this.multiTargeting);
        par1.func_74780_a("storageEU", this.storageEU);
        NBTTagList itemList = new NBTTagList();
        for (int i = 0; i < this.inv.length; ++i) {
            ItemStack stack = this.func_70301_a(i);
            if (stack == null) continue;
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74774_a("Slot", (byte)i);
            stack.func_77955_b(tag);
            itemList.func_74742_a((NBTBase)tag);
        }
        par1.func_74782_a("Inventory", (NBTBase)itemList);
        if (this.camoStack != null) {
            NBTTagCompound tag2 = new NBTTagCompound();
            this.camoStack.func_77955_b(tag2);
            par1.func_74782_a("CamoStack", (NBTBase)tag2);
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound par1) {
        super.func_145839_a(par1);
        this.storage.setCapacity(par1.func_74762_e("maxStorage"));
        this.storage.setEnergyStored(par1.func_74762_e("energyStored"));
        this.storage.setMaxReceive(par1.func_74762_e("maxIO"));
        this.amountOfPotentia = par1.func_74760_g("amountOfPotentia");
        this.yAxisDetect = par1.func_74762_e("yAxisDetect");
        this.attacksMobs = par1.func_74767_n("attacksMobs");
        this.attacksNeutrals = par1.func_74767_n("attacksNeutrals");
        this.attacksPlayers = par1.func_74767_n("attacksPlayers");
        this.shouldConcealTurrets = par1.func_74767_n("shouldConcealTurrets");
        this.multiTargeting = par1.func_74767_n("multiTargeting");
        if (PlayerUtil.getPlayerUIDUnstable(par1.func_74779_i("owner")) != null) {
            this.owner = PlayerUtil.getPlayerUIDUnstable(par1.func_74779_i("owner")).toString();
        } else if (PlayerUtil.getPlayerUUID(par1.func_74779_i("owner")) != null) {
            this.owner = PlayerUtil.getPlayerUUID(par1.func_74779_i("owner")).toString();
        } else if (PlayerUtil.getPlayerUUID(par1.func_74779_i("ownerName")) != null) {
            this.owner = PlayerUtil.getPlayerUUID(par1.func_74779_i("ownerName")).toString();
        } else if (!ConfigHandler.offlineModeSupport) {
            Logger.getGlobal().info("Found non existent owner: " + par1.func_74779_i("owner") + "at coordinates: " + this.field_145851_c + "," + this.field_145848_d + "," + this.field_145849_e + ". Dropping Turretbase");
            this.field_145850_b.func_147480_a(this.field_145851_c, this.field_145848_d, this.field_145849_e, true);
            return;
        }
        if (par1.func_74764_b("ownerName")) {
            this.ownerName = par1.func_74779_i("ownerName");
        }
        this.buildTrustedPlayersFromNBT(par1.func_150295_c("trustedPlayers", 10));
        if (this.trustedPlayers.size() == 0) {
            this.buildTrustedPlayersFromNBT(par1.func_150295_c("trustedPlayers", 8));
        }
        this.active = !par1.func_74764_b("active") || par1.func_74767_n("active");
        boolean bl = this.inverted = !par1.func_74764_b("inverted") || par1.func_74767_n("inverted");
        if (par1.func_74764_b("redstone")) {
            this.redstone = par1.func_74767_n("redstone");
        } else {
            this.checkRedstone = true;
        }
        this.computerAccessible = par1.func_74764_b("computerAccessible") && par1.func_74767_n("computerAccessible");
        this.storageEU = par1.func_74764_b("storageEU") ? par1.func_74769_h("storageEU") : 0.0;
        NBTTagList tagList = par1.func_150295_c("Inventory", 10);
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound tag = tagList.func_150305_b(i);
            byte slot = tag.func_74771_c("Slot");
            if (slot < 0 || slot >= this.inv.length) continue;
            this.inv[slot] = ItemStack.func_77949_a((NBTTagCompound)tag);
        }
        NBTTagCompound tag2 = par1.func_74775_l("CamoStack");
        if (tag2 != null) {
            this.camoStack = ItemStack.func_77949_a((NBTTagCompound)tag2);
        }
    }

    @Override
    public ItemStack func_70298_a(int slot, int amt) {
        ItemStack stack = this.func_70301_a(slot);
        if (stack != null) {
            if (stack.field_77994_a <= amt) {
                this.func_70299_a(slot, null);
            } else {
                stack = stack.func_77979_a(amt);
                if (stack.field_77994_a == 0) {
                    this.func_70299_a(slot, null);
                }
            }
        }
        return stack;
    }

    @Override
    public ItemStack func_70304_b(int slot) {
        ItemStack stack = this.func_70301_a(slot);
        if (stack != null) {
            this.func_70299_a(slot, null);
        }
        return stack;
    }

    @Override
    public void func_70299_a(int slot, ItemStack stack) {
        this.inv[slot] = stack;
        if (stack != null && stack.field_77994_a > this.func_70297_j_()) {
            stack.field_77994_a = this.func_70297_j_();
        }
    }

    @Override
    public boolean func_70300_a(EntityPlayer player) {
        return this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) == this && player.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) < 64.0;
    }

    @Optional.Method(modid="Thaumcraft")
    private IEssentiaTransport getConnectableTileWithoutOrientation() {
        if (this.field_145850_b.func_147438_o(this.field_145851_c + 1, this.field_145848_d, this.field_145849_e) instanceof IEssentiaTransport) {
            return (IEssentiaTransport)this.field_145850_b.func_147438_o(this.field_145851_c + 1, this.field_145848_d, this.field_145849_e);
        }
        if (this.field_145850_b.func_147438_o(this.field_145851_c - 1, this.field_145848_d, this.field_145849_e) instanceof IEssentiaTransport) {
            return (IEssentiaTransport)this.field_145850_b.func_147438_o(this.field_145851_c - 1, this.field_145848_d, this.field_145849_e);
        }
        if (this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e) instanceof IEssentiaTransport) {
            return (IEssentiaTransport)this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e);
        }
        if (this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e) instanceof IEssentiaTransport) {
            return (IEssentiaTransport)this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e);
        }
        if (this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e + 1) instanceof IEssentiaTransport) {
            return (IEssentiaTransport)this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e + 1);
        }
        if (this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e - 1) instanceof IEssentiaTransport) {
            return (IEssentiaTransport)this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e - 1);
        }
        return null;
    }

    @Optional.Method(modid="Thaumcraft")
    private int drawEssentia() {
        IEssentiaTransport ic = this.getConnectableTileWithoutOrientation();
        if (ic != null && ic.takeEssentia(Aspect.ENERGY, 1, ForgeDirection.UP) == 1) {
            return 1;
        }
        return 0;
    }

    @Optional.Method(modid="gregtech")
    public long injectEnergyUnits(ForgeDirection side, long aVoltage, long aAmperage) {
        if (this.storageEU < (double)(40000 * this.getBaseTier())) {
            this.storageEU += (double)(aVoltage * aAmperage);
            this.func_70296_d();
            return aAmperage;
        }
        return 0L;
    }

    @Optional.Method(modid="gregtech")
    public boolean inputEnergyFrom(ForgeDirection side) {
        return this.storageEU < (double)(40000 * this.getBaseTier());
    }

    @Optional.Method(modid="gregtech")
    public boolean outputsEnergyTo(ForgeDirection side) {
        return false;
    }

    @Optional.Method(modid="gregtech")
    public byte getColorization() {
        return -1;
    }

    @Optional.Method(modid="gregtech")
    public byte setColorization(byte aColor) {
        return -1;
    }

    public void func_145845_h() {
        ++this.ticks;
        if (!this.field_145850_b.field_72995_K && this.ticks % 5 == 0) {
            this.shouldConcealTurrets = TurretHeadUtil.hasConcealmentAddon(this);
            this.storage.setCapacity(this.getMaxEnergyStorageWithExtenders());
            if (ModCompatibility.ThaumcraftLoaded && this.amountOfPotentia <= this.maxAmountOfPotentia) {
                this.amountOfPotentia += (float)this.drawEssentia();
            }
            if (ModCompatibility.ThaumcraftLoaded && TurretHeadUtil.hasPotentiaUpgradeAddon(this) && this.storage.getMaxEnergyStored() - this.storage.getEnergyStored() <= ConfigHandler.getPotentiaToRFRatio() * 5 && this.amountOfPotentia >= 0.05f) {
                if (VisNetHandler.drainVis((World)this.field_145850_b, (int)this.field_145851_c, (int)this.field_145848_d, (int)this.field_145849_e, (Aspect)Aspect.ORDER, (int)5) == 5) {
                    this.amountOfPotentia -= 0.05f;
                    this.storage.modifyEnergyStored(ConfigHandler.getPotentiaToRFRatio() * 5);
                } else {
                    this.amountOfPotentia -= 0.05f;
                    this.storage.modifyEnergyStored(Math.round((float)ConfigHandler.getPotentiaToRFRatio() / 2.0f));
                }
            }
            if (ConfigHandler.EUSupport && this.storage.getMaxEnergyStored() != this.storage.getEnergyStored() && this.storageEU > 0.0) {
                int energyToAdd = MathUtil.truncateDoubleToInt(Math.min((double)(this.storage.getMaxEnergyStored() - this.storage.getEnergyStored()), this.storageEU * ConfigHandler.EUtoRFRatio));
                this.storage.modifyEnergyStored(energyToAdd);
                this.storageEU -= (double)energyToAdd / ConfigHandler.EUtoRFRatio;
            }
            if (this.ticks == 20) {
                this.ticks = 0;
                TurretBase.updateRedstoneReactor(this);
                this.computerAccessible = (ModCompatibility.OpenComputersLoaded || ModCompatibility.ComputercraftLoaded) && TurretHeadUtil.hasSerialPortAddon(this);
            }
        }
    }

    @Override
    public Packet func_145844_m() {
        return NetworkingHandler.INSTANCE.getPacketFrom((IMessage)new MessageTurretBase(this));
    }

    public abstract int getBaseTier();

    public boolean isAttacksMobs() {
        return this.attacksMobs;
    }

    public void setAttacksMobs(boolean attacksMobs) {
        this.attacksMobs = attacksMobs;
    }

    public boolean isAttacksNeutrals() {
        return this.attacksNeutrals;
    }

    public void setAttacksNeutrals(boolean attacksNeutrals) {
        this.attacksNeutrals = attacksNeutrals;
    }

    public boolean isAttacksPlayers() {
        return this.attacksPlayers;
    }

    public void setAttacksPlayers(boolean attacksPlayers) {
        this.attacksPlayers = attacksPlayers;
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public String getOwnerName() {
        return this.ownerName;
    }

    public void setOwnerName(String name) {
        this.ownerName = name;
    }

    public boolean isMultiTargeting() {
        return this.multiTargeting;
    }

    public void setMultiTargeting(boolean multiTargeting) {
        this.multiTargeting = multiTargeting;
    }

    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        return this.storage.receiveEnergy(maxReceive, simulate);
    }

    public int extractEnergy(ForgeDirection from, int maxExtract, boolean simulate) {
        return 0;
    }

    public int getEnergyStored(ForgeDirection from) {
        return this.storage.getEnergyStored();
    }

    public int getMaxEnergyStored(ForgeDirection from) {
        return this.storage.getMaxEnergyStored();
    }

    public void setEnergyStored(int energy) {
        this.storage.setEnergyStored(energy);
    }

    public boolean canConnectEnergy(ForgeDirection from) {
        return true;
    }

    @Override
    public boolean func_94041_b(int i, ItemStack itemstack) {
        return true;
    }

    public int getyAxisDetect() {
        return this.yAxisDetect;
    }

    public void setyAxisDetect(int yAxisDetect) {
        this.yAxisDetect = yAxisDetect;
        if (this.yAxisDetect > 9) {
            this.yAxisDetect = 9;
        }
        if (this.yAxisDetect < 0) {
            this.yAxisDetect = 0;
        }
    }

    public int[] func_94128_d(int side) {
        return new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8};
    }

    public boolean func_102007_a(int slotID, ItemStack itemstack, int side) {
        return this.func_94041_b(slotID, itemstack);
    }

    public boolean func_102008_b(int slotID, ItemStack itemstack, int side) {
        return true;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    private boolean getInverted() {
        return this.inverted;
    }

    private void setInverted(boolean inverted) {
        this.inverted = inverted;
        this.active = this.redstone ^ this.inverted;
    }

    private boolean getRedstone() {
        return this.redstone;
    }

    public void setRedstone(boolean redstone) {
        this.redstone = redstone;
        this.active = this.redstone ^ this.inverted;
    }

    @Optional.Method(modid="Thaumcraft")
    public boolean isConnectable(ForgeDirection face) {
        return TurretHeadUtil.hasPotentiaUpgradeAddon(this);
    }

    @Optional.Method(modid="Thaumcraft")
    public boolean canInputFrom(ForgeDirection face) {
        return TurretHeadUtil.hasPotentiaUpgradeAddon(this);
    }

    @Optional.Method(modid="Thaumcraft")
    public boolean canOutputTo(ForgeDirection face) {
        return false;
    }

    @Optional.Method(modid="Thaumcraft")
    public void setSuction(Aspect aspect, int amount) {
    }

    @Optional.Method(modid="Thaumcraft")
    public Aspect getSuctionType(ForgeDirection face) {
        return null;
    }

    @Optional.Method(modid="Thaumcraft")
    public int takeEssentia(Aspect aspect, int amount, ForgeDirection face) {
        return 0;
    }

    @Optional.Method(modid="Thaumcraft")
    public Aspect getEssentiaType(ForgeDirection face) {
        return null;
    }

    @Optional.Method(modid="Thaumcraft")
    public int getEssentiaAmount(ForgeDirection face) {
        return 0;
    }

    @Optional.Method(modid="Thaumcraft")
    public int getMinimumSuction() {
        return 0;
    }

    @Optional.Method(modid="Thaumcraft")
    public boolean renderExtendedTube() {
        return false;
    }

    @Optional.Method(modid="Thaumcraft")
    public AspectList getAspects() {
        if (TurretHeadUtil.hasPotentiaUpgradeAddon(this)) {
            return new AspectList().add(Aspect.ENERGY, (int)Math.floor(this.amountOfPotentia));
        }
        return null;
    }

    @Optional.Method(modid="Thaumcraft")
    public void setAspects(AspectList aspects) {
    }

    @Optional.Method(modid="Thaumcraft")
    public boolean doesContainerAccept(Aspect tag) {
        return tag.equals(Aspect.ENERGY);
    }

    @Optional.Method(modid="Thaumcraft")
    public int addToContainer(Aspect tag, int amount) {
        return 0;
    }

    @Optional.Method(modid="Thaumcraft")
    public int getSuctionAmount(ForgeDirection face) {
        return 64;
    }

    @Optional.Method(modid="Thaumcraft")
    public int addEssentia(Aspect aspect, int amount, ForgeDirection face) {
        return 0;
    }

    @Optional.Method(modid="Thaumcraft")
    public boolean takeFromContainer(Aspect tag, int amount) {
        return false;
    }

    @Optional.Method(modid="Thaumcraft")
    public boolean takeFromContainer(AspectList ot) {
        return false;
    }

    @Optional.Method(modid="Thaumcraft")
    public boolean doesContainerContainAmount(Aspect tag, int amount) {
        return false;
    }

    @Optional.Method(modid="Thaumcraft")
    public boolean doesContainerContain(AspectList ot) {
        return false;
    }

    @Optional.Method(modid="Thaumcraft")
    public int containerContains(Aspect tag) {
        if (tag.equals(Aspect.ENERGY)) {
            return Math.round(this.amountOfPotentia);
        }
        return 0;
    }

    @Optional.Method(modid="OpenComputers")
    @Callback(doc="function():string; returns owner of turret base.")
    public Object[] getOwner(Context context, Arguments args) {
        if (!this.computerAccessible) {
            return new Object[]{"Computer access deactivated!"};
        }
        return new Object[]{this.getOwnerName()};
    }

    @Optional.Method(modid="OpenComputers")
    @Callback(doc="function():boolean; returns if the turret is currently set to attack hostile mobs.")
    public Object[] isAttacksMobs(Context context, Arguments args) {
        if (!this.computerAccessible) {
            return new Object[]{"Computer access deactivated!"};
        }
        return new Object[]{this.isAttacksMobs()};
    }

    @Optional.Method(modid="OpenComputers")
    @Callback(doc="function():boolean;  sets to attack hostile mobs or not.")
    public Object[] setAttacksMobs(Context context, Arguments args) {
        if (!this.computerAccessible) {
            return new Object[]{"Computer access deactivated!"};
        }
        this.setAttacksMobs(args.checkBoolean(0));
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        return null;
    }

    @Optional.Method(modid="OpenComputers")
    @Callback(doc="function():boolean; returns if the turret is currently set to attack neutral mobs.")
    public Object[] isAttacksNeutrals(Context context, Arguments args) {
        if (!this.computerAccessible) {
            return new Object[]{"Computer access deactivated!"};
        }
        return new Object[]{this.isAttacksNeutrals()};
    }

    @Optional.Method(modid="OpenComputers")
    @Callback(doc="function():boolean; sets to attack neutral mobs or not.")
    public Object[] setAttacksNeutrals(Context context, Arguments args) {
        if (!this.computerAccessible) {
            return new Object[]{"Computer access deactivated!"};
        }
        this.setAttacksNeutrals(args.checkBoolean(0));
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        return null;
    }

    @Optional.Method(modid="OpenComputers")
    @Callback(doc="function():boolean; returns if the turret is currently set to attack players.")
    public Object[] isAttacksPlayers(Context context, Arguments args) {
        if (!this.computerAccessible) {
            return new Object[]{"Computer access deactivated!"};
        }
        return new Object[]{this.isAttacksPlayers()};
    }

    @Optional.Method(modid="OpenComputers")
    @Callback(doc="function():boolean; sets to attack players or not.")
    public Object[] setAttacksPlayers(Context context, Arguments args) {
        if (!this.computerAccessible) {
            return new Object[]{"Computer access deactivated!"};
        }
        this.setAttacksPlayers(args.checkBoolean(0));
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        return null;
    }

    @Optional.Method(modid="OpenComputers")
    @Callback(doc="function():table; returns a table of trusted players on this base.")
    public Object[] getTrustedPlayers(Context context, Arguments args) {
        if (!this.computerAccessible) {
            return new Object[]{"Computer access deactivated!"};
        }
        return new Object[]{this.getTrustedPlayers()};
    }

    @Optional.Method(modid="OpenComputers")
    @Callback(doc="function(name:String, [canOpenGUI:boolean , canChangeTargeting:boolean , admin:boolean]):string; adds Trusted player to Trustlist.")
    public Object[] addTrustedPlayer(Context context, Arguments args) {
        if (!this.computerAccessible) {
            return new Object[]{"Computer access deactivated!"};
        }
        if (!this.addTrustedPlayer(args.checkString(0))) {
            return new Object[]{"Name not valid!"};
        }
        TrustedPlayer trustedPlayer = this.getTrustedPlayer(args.checkString(0));
        trustedPlayer.canOpenGUI = args.optBoolean(1, false);
        trustedPlayer.canChangeTargeting = args.optBoolean(1, false);
        trustedPlayer.admin = args.optBoolean(1, false);
        trustedPlayer.uuid = PlayerUtil.getPlayerUUID(args.checkString(0));
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        return null;
    }

    @Optional.Method(modid="OpenComputers")
    @Callback(doc="function():string; removes Trusted player from Trustlist.")
    public Object[] removeTrustedPlayer(Context context, Arguments args) {
        if (!this.computerAccessible) {
            return new Object[]{"Computer access deactivated!"};
        }
        this.removeTrustedPlayer(args.checkString(0));
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        return null;
    }

    @Optional.Method(modid="OpenComputers")
    @Callback(doc="function():int; returns maxiumum energy storage.")
    public Object[] getMaxEnergyStorage(Context context, Arguments args) {
        if (!this.computerAccessible) {
            return new Object[]{"Computer access deactivated!"};
        }
        return new Object[]{this.storage.getMaxEnergyStored()};
    }

    @Optional.Method(modid="OpenComputers")
    @Callback(doc="function():int; returns current energy stored.")
    public Object[] getCurrentEnergyStorage(Context context, Arguments args) {
        if (!this.computerAccessible) {
            return new Object[]{"Computer access deactivated!"};
        }
        return new Object[]{this.getEnergyStored(ForgeDirection.UNKNOWN)};
    }

    @Optional.Method(modid="OpenComputers")
    @Callback(doc="function():boolean; returns if the turret is currently active.")
    public Object[] getActive(Context context, Arguments args) {
        if (!this.computerAccessible) {
            return new Object[]{"Computer access deactivated!"};
        }
        return new Object[]{this.isActive()};
    }

    @Optional.Method(modid="OpenComputers")
    @Callback(doc="function():boolean; toggles turret redstone inversion state.")
    public Object[] setInverted(Context context, Arguments args) {
        if (!this.computerAccessible) {
            return new Object[]{"Computer access deactivated!"};
        }
        this.setInverted(args.checkBoolean(0));
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        return null;
    }

    @Optional.Method(modid="OpenComputers")
    @Callback(doc="function():boolean; shows redstone inversion state.")
    public Object[] getInverted(Context context, Arguments args) {
        if (!this.computerAccessible) {
            return new Object[]{"Computer access deactivated!"};
        }
        return new Object[]{this.getInverted()};
    }

    @Optional.Method(modid="OpenComputers")
    @Callback(doc="function():boolean; shows redstone state.")
    public Object[] getRedstone(Context context, Arguments args) {
        if (!this.computerAccessible) {
            return new Object[]{"Computer access deactivated!"};
        }
        return new Object[]{this.getRedstone()};
    }

    @Optional.Method(modid="ComputerCraft")
    public String getType() {
        return "OMTBase";
    }

    @Optional.Method(modid="ComputerCraft")
    public String[] getMethodNames() {
        return new String[]{commands.getOwner.toString(), commands.attacksPlayers.toString(), commands.setAttacksPlayers.toString(), commands.attacksMobs.toString(), commands.setAttacksMobs.toString(), commands.attacksNeutrals.toString(), commands.setAttacksNeutrals.toString(), commands.getTrustedPlayers.toString(), commands.addTrustedPlayer.toString(), commands.removeTrustedPlayer.toString(), commands.getActive.toString(), commands.getInverted.toString(), commands.getRedstone.toString(), commands.setInverted.toString(), commands.getType.toString()};
    }

    @Optional.Method(modid="ComputerCraft")
    public Object[] callMethod(IComputerAccess computer, ILuaContext context, int method, Object[] arguments) throws LuaException, InterruptedException {
        if (!this.computerAccessible) {
            return new Object[]{"Computer access deactivated!"};
        }
        switch (commands.values()[method]) {
            case getOwner: {
                return new Object[]{this.getOwnerName()};
            }
            case attacksPlayers: {
                return new Object[]{this.attacksPlayers};
            }
            case setAttacksPlayers: {
                boolean b;
                if (!arguments[0].toString().equals("true") && !arguments[0].toString().equals("false")) {
                    return new Object[]{"wrong arguments"};
                }
                this.attacksPlayers = b = arguments[0].toString().equals("true");
                return new Object[]{true};
            }
            case attacksMobs: {
                return new Object[]{this.attacksMobs};
            }
            case setAttacksMobs: {
                boolean b;
                if (!arguments[0].toString().equals("true") && !arguments[0].toString().equals("false")) {
                    return new Object[]{"wrong arguments"};
                }
                this.attacksMobs = b = arguments[0].toString().equals("true");
                return new Object[]{true};
            }
            case attacksNeutrals: {
                return new Object[]{this.attacksNeutrals};
            }
            case setAttacksNeutrals: {
                boolean b;
                if (!arguments[0].toString().equals("true") && !arguments[0].toString().equals("false")) {
                    return new Object[]{"wrong arguments"};
                }
                this.attacksNeutrals = b = arguments[0].toString().equals("true");
                return new Object[]{true};
            }
            case getTrustedPlayers: {
                HashMap<String, Integer> result = new HashMap<String, Integer>();
                if (this.getTrustedPlayers() != null && this.getTrustedPlayers().size() > 0) {
                    for (TrustedPlayer trustedPlayer : this.getTrustedPlayers()) {
                        result.put(trustedPlayer.name, (trustedPlayer.canOpenGUI ? 1 : 0) + (trustedPlayer.canChangeTargeting ? 2 : 0) + (trustedPlayer.admin ? 4 : 0));
                    }
                }
                return new Object[]{result};
            }
            case addTrustedPlayer: {
                if (arguments[0].toString().equals("")) {
                    return new Object[]{"wrong arguments"};
                }
                if (!this.addTrustedPlayer(arguments[0].toString())) {
                    return new Object[]{"Name not valid!"};
                }
                if (arguments[1].toString().equals("")) {
                    return new Object[]{"successfully added"};
                }
                for (int i = 1; i <= 4; ++i) {
                    if (arguments.length <= i || arguments[i].toString().equals("true") || arguments[i].toString().equals("false")) continue;
                    return new Object[]{"wrong arguments"};
                }
                TrustedPlayer trustedPlayer = this.getTrustedPlayer(arguments[0].toString());
                trustedPlayer.canOpenGUI = arguments[1].toString().equals("true");
                trustedPlayer.canChangeTargeting = arguments[2].toString().equals("true");
                trustedPlayer.admin = arguments[3].toString().equals("true");
                trustedPlayer.uuid = PlayerUtil.getPlayerUUID(arguments[0].toString());
                this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                return new Object[]{"succesfully added player to trust list with parameters"};
            }
            case removeTrustedPlayer: {
                if (arguments[0].toString().equals("")) {
                    return new Object[]{"wrong arguments"};
                }
                this.removeTrustedPlayer(arguments[0].toString());
                this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                return new Object[]{"removed player from trusted list"};
            }
            case getActive: {
                return new Object[]{this.active};
            }
            case getInverted: {
                return new Object[]{this.inverted};
            }
            case getRedstone: {
                return new Object[]{this.redstone};
            }
            case setInverted: {
                if (!arguments[0].toString().equals("true") && !arguments[0].toString().equals("false")) {
                    return new Object[]{"wrong arguments"};
                }
                boolean b = arguments[0].toString().equals("true");
                this.setInverted(b);
                this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                return new Object[]{true};
            }
            case getType: {
                return new Object[]{this.getType()};
            }
        }
        return new Object[]{false};
    }

    @Optional.Method(modid="ComputerCraft")
    public void attach(IComputerAccess computer) {
        if (this.comp == null) {
            this.comp = new ArrayList();
        }
        this.comp.add(computer);
    }

    @Optional.Method(modid="ComputerCraft")
    public void detach(IComputerAccess computer) {
        if (this.comp == null) {
            this.comp = new ArrayList();
        }
        this.comp.remove(computer);
    }

    @Optional.Method(modid="ComputerCraft")
    public boolean equals(IPeripheral other) {
        return other.getType().equals(this.getType());
    }

    public static enum commands {
        getOwner,
        attacksPlayers,
        setAttacksPlayers,
        attacksMobs,
        setAttacksMobs,
        attacksNeutrals,
        setAttacksNeutrals,
        getTrustedPlayers,
        addTrustedPlayer,
        removeTrustedPlayer,
        getActive,
        getInverted,
        getRedstone,
        setInverted,
        getType;

    }
}

