/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.opis.swing.panels.timingserver;

import java.awt.Component;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.JButton;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableModel;
import mcp.mobius.opis.api.ITabPanel;
import mcp.mobius.opis.data.holders.ISerializable;
import mcp.mobius.opis.data.holders.newtypes.DataBlockTileEntityPerClass;
import mcp.mobius.opis.data.holders.newtypes.DataTiming;
import mcp.mobius.opis.helpers.ModIdentification;
import mcp.mobius.opis.network.PacketBase;
import mcp.mobius.opis.network.enums.AccessLevel;
import mcp.mobius.opis.network.enums.Message;
import mcp.mobius.opis.swing.SelectedTab;
import mcp.mobius.opis.swing.actions.ActionRunOpis;
import mcp.mobius.opis.swing.widgets.JButtonAccess;
import mcp.mobius.opis.swing.widgets.JPanelMsgHandler;
import mcp.mobius.opis.swing.widgets.JTableStats;
import mcp.mobius.shadow.net.miginfocom.swing.MigLayout;

public class PanelTimingTileEntsPerClass
extends JPanelMsgHandler
implements ITabPanel {
    private JButtonAccess btnRun;

    public PanelTimingTileEntsPerClass() {
        this.setLayout(new MigLayout("", "[grow][]", "[][grow]"));
        this.btnRun = new JButtonAccess("Run Opis", AccessLevel.PRIVILEGED);
        this.add((Component)this.btnRun, "cell 1 0");
        this.btnRun.addActionListener(new ActionRunOpis());
        JScrollPane scrollPane = new JScrollPane();
        this.add((Component)scrollPane, "cell 0 1 2 1,grow");
        this.table = new JTableStats(new String[]{"Name", "Mod", "Amount", "Timing", "Mean value"}, new Class[]{String.class, String.class, Integer.class, DataTiming.class, DataTiming.class}, new int[]{2, 0, 0, 0, 0});
        scrollPane.setViewportView(this.table);
    }

    @Override
    public boolean handleMessage(Message msg, PacketBase rawdata) {
        switch (msg) {
            case LIST_TIMING_TILEENTS_PER_CLASS: {
                this.cacheData(msg, rawdata);
                SwingUtilities.invokeLater(() -> {
                    this.getTable().setTableData(rawdata.array);
                    DefaultTableModel model = this.table.getModel();
                    int row = this.getTable().clearTable(DataBlockTileEntityPerClass.class);
                    HashMap<String, DataBlockTileEntityPerClass> cumData = new HashMap<String, DataBlockTileEntityPerClass>();
                    for (ISerializable o : rawdata.array) {
                        DataBlockTileEntityPerClass data = (DataBlockTileEntityPerClass)o;
                        String name = ModIdentification.getStackName(data.id, data.meta);
                        if (!cumData.containsKey(name)) {
                            cumData.put(name, new DataBlockTileEntityPerClass(data.id, data.meta));
                        }
                        ((DataBlockTileEntityPerClass)cumData.get(name)).add(data.amount, data.update.timing);
                    }
                    Iterator<ISerializable> iterator = cumData.keySet().iterator();
                    while (iterator.hasNext()) {
                        String s;
                        String name = s = (String)((Object)iterator.next());
                        String modID = ModIdentification.getModStackName(((DataBlockTileEntityPerClass)cumData.get((Object)s)).id, ((DataBlockTileEntityPerClass)cumData.get((Object)s)).meta);
                        model.addRow(new Object[]{name, modID, ((DataBlockTileEntityPerClass)cumData.get((Object)s)).amount, ((DataBlockTileEntityPerClass)cumData.get((Object)s)).update, new DataTiming(((DataBlockTileEntityPerClass)cumData.get((Object)s)).update.timing / (double)((DataBlockTileEntityPerClass)cumData.get((Object)s)).amount)});
                    }
                    this.getTable().dataUpdated(row);
                });
                break;
            }
            case STATUS_START: 
            case STATUS_RUNNING: {
                SwingUtilities.invokeLater(() -> this.getBtnRun().setText("Running..."));
                break;
            }
            case STATUS_STOP: {
                SwingUtilities.invokeLater(() -> this.getBtnRun().setText("Run Opis"));
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    @Override
    public SelectedTab getSelectedTab() {
        return SelectedTab.TIMINGTILEENTSPERCLASS;
    }

    public JButton getBtnRun() {
        return this.btnRun;
    }

    @Override
    public boolean refreshOnString() {
        return true;
    }
}

