/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.shadow.io.nettyopis.handler.codec.serialization;

import java.util.HashMap;
import mcp.mobius.shadow.io.nettyopis.handler.codec.serialization.CachingClassResolver;
import mcp.mobius.shadow.io.nettyopis.handler.codec.serialization.ClassLoaderClassResolver;
import mcp.mobius.shadow.io.nettyopis.handler.codec.serialization.ClassResolver;
import mcp.mobius.shadow.io.nettyopis.handler.codec.serialization.SoftReferenceMap;
import mcp.mobius.shadow.io.nettyopis.handler.codec.serialization.WeakReferenceMap;
import mcp.mobius.shadow.io.nettyopis.util.internal.PlatformDependent;

public final class ClassResolvers {
    public static ClassResolver cacheDisabled(ClassLoader classLoader) {
        return new ClassLoaderClassResolver(ClassResolvers.defaultClassLoader(classLoader));
    }

    public static ClassResolver weakCachingResolver(ClassLoader classLoader) {
        return new CachingClassResolver(new ClassLoaderClassResolver(ClassResolvers.defaultClassLoader(classLoader)), new WeakReferenceMap(new HashMap()));
    }

    public static ClassResolver softCachingResolver(ClassLoader classLoader) {
        return new CachingClassResolver(new ClassLoaderClassResolver(ClassResolvers.defaultClassLoader(classLoader)), new SoftReferenceMap(new HashMap()));
    }

    public static ClassResolver weakCachingConcurrentResolver(ClassLoader classLoader) {
        return new CachingClassResolver(new ClassLoaderClassResolver(ClassResolvers.defaultClassLoader(classLoader)), new WeakReferenceMap(PlatformDependent.newConcurrentHashMap()));
    }

    public static ClassResolver softCachingConcurrentResolver(ClassLoader classLoader) {
        return new CachingClassResolver(new ClassLoaderClassResolver(ClassResolvers.defaultClassLoader(classLoader)), new SoftReferenceMap(PlatformDependent.newConcurrentHashMap()));
    }

    static ClassLoader defaultClassLoader(ClassLoader classLoader) {
        if (classLoader != null) {
            return classLoader;
        }
        ClassLoader contextClassLoader = PlatformDependent.getContextClassLoader();
        if (contextClassLoader != null) {
            return contextClassLoader;
        }
        return PlatformDependent.getClassLoader(ClassResolvers.class);
    }

    private ClassResolvers() {
    }
}

