/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.shadow.org.jfree.data.contour;

import java.util.Arrays;
import java.util.Date;
import java.util.Vector;
import mcp.mobius.shadow.org.jfree.data.Range;
import mcp.mobius.shadow.org.jfree.data.contour.ContourDataset;
import mcp.mobius.shadow.org.jfree.data.xy.AbstractXYZDataset;

public class DefaultContourDataset
extends AbstractXYZDataset
implements ContourDataset {
    protected Comparable seriesKey = null;
    protected Number[] xValues = null;
    protected Number[] yValues = null;
    protected Number[] zValues = null;
    protected int[] xIndex = null;
    boolean[] dateAxis = new boolean[3];

    public DefaultContourDataset() {
    }

    public DefaultContourDataset(Comparable seriesKey, Object[] xData, Object[] yData, Object[] zData) {
        this.seriesKey = seriesKey;
        this.initialize(xData, yData, zData);
    }

    public void initialize(Object[] xData, Object[] yData, Object[] zData) {
        this.xValues = new Double[xData.length];
        this.yValues = new Double[yData.length];
        this.zValues = new Double[zData.length];
        Vector<Integer> tmpVector = new Vector<Integer>();
        double x = 1.123452E31;
        for (int k = 0; k < this.xValues.length; ++k) {
            Number xNumber;
            if (xData[k] == null) continue;
            if (xData[k] instanceof Number) {
                xNumber = (Number)xData[k];
            } else if (xData[k] instanceof Date) {
                this.dateAxis[0] = true;
                Date xDate = (Date)xData[k];
                xNumber = new Long(xDate.getTime());
            } else {
                xNumber = new Integer(0);
            }
            this.xValues[k] = new Double(xNumber.doubleValue());
            if (x == this.xValues[k].doubleValue()) continue;
            tmpVector.add(new Integer(k));
            x = this.xValues[k].doubleValue();
        }
        Object[] inttmp = tmpVector.toArray();
        this.xIndex = new int[inttmp.length];
        for (int i = 0; i < inttmp.length; ++i) {
            this.xIndex[i] = (Integer)inttmp[i];
        }
        for (int k = 0; k < this.yValues.length; ++k) {
            this.yValues[k] = (Double)yData[k];
            if (zData[k] == null) continue;
            this.zValues[k] = (Double)zData[k];
        }
    }

    public static Object[][] formObjectArray(double[][] data) {
        Object[][] object = new Double[data.length][data[0].length];
        for (int i = 0; i < object.length; ++i) {
            for (int j = 0; j < object[i].length; ++j) {
                object[i][j] = new Double(data[i][j]);
            }
        }
        return object;
    }

    public static Object[] formObjectArray(double[] data) {
        Object[] object = new Double[data.length];
        for (int i = 0; i < object.length; ++i) {
            object[i] = new Double(data[i]);
        }
        return object;
    }

    @Override
    public int getItemCount(int series) {
        if (series > 0) {
            throw new IllegalArgumentException("Only one series for contour");
        }
        return this.zValues.length;
    }

    @Override
    public double getMaxZValue() {
        double zMax = -1.0E20;
        for (int k = 0; k < this.zValues.length; ++k) {
            if (this.zValues[k] == null) continue;
            zMax = Math.max(zMax, this.zValues[k].doubleValue());
        }
        return zMax;
    }

    @Override
    public double getMinZValue() {
        double zMin = 1.0E20;
        for (int k = 0; k < this.zValues.length; ++k) {
            if (this.zValues[k] == null) continue;
            zMin = Math.min(zMin, this.zValues[k].doubleValue());
        }
        return zMin;
    }

    @Override
    public Range getZValueRange(Range x, Range y) {
        double minX = x.getLowerBound();
        double minY = y.getLowerBound();
        double maxX = x.getUpperBound();
        double maxY = y.getUpperBound();
        double zMin = 1.0E20;
        double zMax = -1.0E20;
        for (int k = 0; k < this.zValues.length; ++k) {
            if (!(this.xValues[k].doubleValue() >= minX) || !(this.xValues[k].doubleValue() <= maxX) || !(this.yValues[k].doubleValue() >= minY) || !(this.yValues[k].doubleValue() <= maxY) || this.zValues[k] == null) continue;
            zMin = Math.min(zMin, this.zValues[k].doubleValue());
            zMax = Math.max(zMax, this.zValues[k].doubleValue());
        }
        return new Range(zMin, zMax);
    }

    public double getMinZValue(double minX, double minY, double maxX, double maxY) {
        double zMin = 1.0E20;
        for (int k = 0; k < this.zValues.length; ++k) {
            if (this.zValues[k] == null) continue;
            zMin = Math.min(zMin, this.zValues[k].doubleValue());
        }
        return zMin;
    }

    @Override
    public int getSeriesCount() {
        return 1;
    }

    @Override
    public Comparable getSeriesKey(int series) {
        if (series > 0) {
            throw new IllegalArgumentException("Only one series for contour");
        }
        return this.seriesKey;
    }

    @Override
    public int[] getXIndices() {
        return this.xIndex;
    }

    @Override
    public Number[] getXValues() {
        return this.xValues;
    }

    @Override
    public Number getX(int series, int item) {
        if (series > 0) {
            throw new IllegalArgumentException("Only one series for contour");
        }
        return this.xValues[item];
    }

    public Number getXValue(int item) {
        return this.xValues[item];
    }

    @Override
    public Number[] getYValues() {
        return this.yValues;
    }

    @Override
    public Number getY(int series, int item) {
        if (series > 0) {
            throw new IllegalArgumentException("Only one series for contour");
        }
        return this.yValues[item];
    }

    @Override
    public Number[] getZValues() {
        return this.zValues;
    }

    @Override
    public Number getZ(int series, int item) {
        if (series > 0) {
            throw new IllegalArgumentException("Only one series for contour");
        }
        return this.zValues[item];
    }

    @Override
    public int[] indexX() {
        int[] index = new int[this.xValues.length];
        for (int k = 0; k < index.length; ++k) {
            index[k] = this.indexX(k);
        }
        return index;
    }

    public int indexX(int k) {
        int i = Arrays.binarySearch(this.xIndex, k);
        if (i >= 0) {
            return i;
        }
        return -1 * i - 2;
    }

    public int indexY(int k) {
        return k / this.xValues.length;
    }

    public int indexZ(int i, int j) {
        return this.xValues.length * j + i;
    }

    @Override
    public boolean isDateAxis(int axisNumber) {
        if (axisNumber < 0 || axisNumber > 2) {
            return false;
        }
        return this.dateAxis[axisNumber];
    }

    public void setSeriesKeys(Comparable[] seriesKeys) {
        if (seriesKeys.length > 1) {
            throw new IllegalArgumentException("Contours only support one series");
        }
        this.seriesKey = seriesKeys[0];
        this.fireDatasetChanged();
    }
}

