/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.opis;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.event.FMLServerStoppedEvent;
import cpw.mods.fml.common.registry.GameRegistry;
import mcp.mobius.mobiuscore.profiler.ProfilerSection;
import mcp.mobius.opis.commands.client.CommandOpis;
import mcp.mobius.opis.commands.server.CommandAddPrivileged;
import mcp.mobius.opis.commands.server.CommandAmountEntities;
import mcp.mobius.opis.commands.server.CommandChunkList;
import mcp.mobius.opis.commands.server.CommandEntityCreate;
import mcp.mobius.opis.commands.server.CommandFrequency;
import mcp.mobius.opis.commands.server.CommandHelp;
import mcp.mobius.opis.commands.server.CommandKill;
import mcp.mobius.opis.commands.server.CommandKillAll;
import mcp.mobius.opis.commands.server.CommandReset;
import mcp.mobius.opis.commands.server.CommandRmPrivileged;
import mcp.mobius.opis.commands.server.CommandStart;
import mcp.mobius.opis.commands.server.CommandStop;
import mcp.mobius.opis.commands.server.CommandTicks;
import mcp.mobius.opis.commands.server.CommandTimingEntities;
import mcp.mobius.opis.commands.server.CommandTimingTileEntities;
import mcp.mobius.opis.data.holders.basetypes.CoordinatesBlock;
import mcp.mobius.opis.data.profilers.ProfilerDimBlockTick;
import mcp.mobius.opis.data.profilers.ProfilerDimTick;
import mcp.mobius.opis.data.profilers.ProfilerEntityUpdate;
import mcp.mobius.opis.data.profilers.ProfilerEvent;
import mcp.mobius.opis.data.profilers.ProfilerNetworkTick;
import mcp.mobius.opis.data.profilers.ProfilerPacket;
import mcp.mobius.opis.data.profilers.ProfilerRenderBlock;
import mcp.mobius.opis.data.profilers.ProfilerRenderEntity;
import mcp.mobius.opis.data.profilers.ProfilerRenderTileEntity;
import mcp.mobius.opis.data.profilers.ProfilerTick;
import mcp.mobius.opis.data.profilers.ProfilerTileEntityUpdate;
import mcp.mobius.opis.events.OpisClientEventHandler;
import mcp.mobius.opis.events.OpisClientTickHandler;
import mcp.mobius.opis.events.OpisServerEventHandler;
import mcp.mobius.opis.events.OpisServerTickHandler;
import mcp.mobius.opis.events.PlayerTracker;
import mcp.mobius.opis.helpers.ModIdentification;
import mcp.mobius.opis.network.PacketManager;
import mcp.mobius.opis.network.enums.AccessLevel;
import mcp.mobius.opis.network.enums.Message;
import mcp.mobius.opis.proxy.ProxyServer;
import mcp.mobius.opis.tools.BlockDebug;
import mcp.mobius.opis.tools.BlockLag;
import mcp.mobius.opis.tools.TileDebug;
import mcp.mobius.opis.tools.TileLag;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.command.ICommand;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="Opis", name="Opis", version="1.3.6-mapless", acceptableRemoteVersions="*")
public class modOpis {
    @Mod.Instance(value="Opis")
    public static modOpis instance;
    public static Logger log;
    @SidedProxy(clientSide="mcp.mobius.opis.proxy.ProxyClient", serverSide="mcp.mobius.opis.proxy.ProxyServer")
    public static ProxyServer proxy;
    public static int profilerDelay;
    public static boolean profilerRun;
    public static boolean profilerRunClient;
    public static int profilerMaxTicks;
    public static int rconport;
    public static boolean rconactive;
    public static String rconpass;
    public static boolean microseconds;
    private static int lagGenID;
    public static volatile CoordinatesBlock selectedBlock;
    public static boolean swingOpen;
    public Configuration config = null;
    public static String commentTables;
    public static String commentOpis;
    public static String commentPrivileged;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        this.config = new Configuration(event.getSuggestedConfigurationFile());
        profilerDelay = this.config.get("general", "profiler.delay", 1).getInt();
        lagGenID = this.config.get("general", "laggenerator_id", -1).getInt();
        profilerMaxTicks = this.config.get("general", "profiler.maxpts", 250).getInt();
        microseconds = this.config.get("general", "display.microseconds", true).getBoolean(true);
        rconport = this.config.get("REMOTE_CONSOLE", "opisrcon.port", 25566).getInt();
        rconactive = this.config.get("REMOTE_CONSOLE", "opisrcon.active", false).getBoolean(false);
        rconpass = this.config.get("REMOTE_CONSOLE", "opisrcon.password", "").getString();
        String[] users = this.config.get("ACCESS_RIGHTS", "privileged", new String[0], commentPrivileged).getStringList();
        AccessLevel minTables = AccessLevel.PRIVILEGED;
        AccessLevel openOpis = AccessLevel.PRIVILEGED;
        try {
            openOpis = AccessLevel.valueOf(this.config.get("ACCESS_RIGHTS", "opis", "NONE", commentTables).getString());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            minTables = AccessLevel.valueOf(this.config.get("ACCESS_RIGHTS", "tables", "NONE", commentTables).getString());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        Message.setTablesMinimumLevel(minTables);
        Message.setOpisMinimumLevel(openOpis);
        for (String s : users) {
            PlayerTracker.INSTANCE.addPrivilegedPlayer(s, false);
        }
        this.config.save();
        MinecraftForge.EVENT_BUS.register((Object)new OpisClientEventHandler());
        MinecraftForge.EVENT_BUS.register((Object)new OpisServerEventHandler());
        FMLCommonHandler.instance().bus().register((Object)OpisClientTickHandler.INSTANCE);
        FMLCommonHandler.instance().bus().register((Object)OpisServerTickHandler.INSTANCE);
        FMLCommonHandler.instance().bus().register((Object)PlayerTracker.INSTANCE);
        PacketManager.init();
    }

    @Mod.EventHandler
    public void load(FMLInitializationEvent event) {
        if (lagGenID != -1) {
            BlockLag blockDemo = new BlockLag(Material.field_151575_d);
            GameRegistry.registerBlock((Block)blockDemo, (String)"opis.laggen");
            GameRegistry.registerTileEntity(TileLag.class, (String)"opis.laggen");
            BlockDebug blockDebug = new BlockDebug(Material.field_151575_d);
            GameRegistry.registerBlock((Block)blockDebug, (String)"opis.debug");
            GameRegistry.registerTileEntity(TileDebug.class, (String)"opis.debug");
        }
        ProfilerSection.RENDER_TILEENTITY.setProfiler(new ProfilerRenderTileEntity());
        ProfilerSection.RENDER_ENTITY.setProfiler(new ProfilerRenderEntity());
        ProfilerSection.RENDER_BLOCK.setProfiler(new ProfilerRenderBlock());
        ProfilerSection.EVENT_INVOKE.setProfiler(new ProfilerEvent());
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        ModIdentification.init();
        proxy.init();
    }

    @Mod.EventHandler
    public void serverStarting(FMLServerStartingEvent event) {
        ProfilerSection.DIMENSION_TICK.setProfiler(new ProfilerDimTick());
        ProfilerSection.DIMENSION_BLOCKTICK.setProfiler(new ProfilerDimBlockTick());
        ProfilerSection.ENTITY_UPDATETIME.setProfiler(new ProfilerEntityUpdate());
        ProfilerSection.TICK.setProfiler(new ProfilerTick());
        ProfilerSection.TILEENT_UPDATETIME.setProfiler(new ProfilerTileEntityUpdate());
        ProfilerSection.PACKET_INBOUND.setProfiler(new ProfilerPacket());
        ProfilerSection.PACKET_OUTBOUND.setProfiler(new ProfilerPacket());
        ProfilerSection.NETWORK_TICK.setProfiler(new ProfilerNetworkTick());
        event.registerServerCommand((ICommand)new CommandChunkList());
        event.registerServerCommand((ICommand)new CommandFrequency());
        event.registerServerCommand((ICommand)new CommandStart());
        event.registerServerCommand((ICommand)new CommandStop());
        event.registerServerCommand((ICommand)new CommandTimingTileEntities());
        event.registerServerCommand((ICommand)new CommandTicks());
        event.registerServerCommand((ICommand)new CommandTimingEntities());
        event.registerServerCommand((ICommand)new CommandAmountEntities());
        event.registerServerCommand((ICommand)new CommandKill());
        event.registerServerCommand((ICommand)new CommandKillAll());
        event.registerServerCommand((ICommand)new CommandReset());
        event.registerServerCommand((ICommand)new CommandEntityCreate());
        event.registerServerCommand((ICommand)new CommandOpis());
        event.registerServerCommand((ICommand)new CommandAddPrivileged());
        event.registerServerCommand((ICommand)new CommandRmPrivileged());
        event.registerServerCommand((ICommand)new CommandHelp());
    }

    @Mod.EventHandler
    public void serverStopped(FMLServerStoppedEvent event) {
        OpisServerTickHandler.INSTANCE.purgeScheduledCallQueue();
    }

    static {
        log = LogManager.getLogger((String)"Opis");
        profilerDelay = 1;
        profilerRun = false;
        profilerRunClient = false;
        profilerMaxTicks = 250;
        rconport = 25566;
        rconactive = false;
        rconpass = "";
        microseconds = true;
        lagGenID = -1;
        selectedBlock = null;
        swingOpen = false;
        commentTables = "Minimum access level to be able to view tables in /opis command. Valid values : NONE, PRIVILEGED, ADMIN";
        commentOpis = "Minimum access level to be open Opis interface. Valid values : NONE, PRIVILEGED, ADMIN";
        commentPrivileged = "List of players with PRIVILEGED access level.";
    }
}

