/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.opis.network.rcon.nexus;

import com.mojang.authlib.GameProfile;
import io.nettyopis.channel.ChannelHandlerContext;
import io.nettyopis.channel.ChannelInboundHandlerAdapter;
import io.nettyopis.util.ReferenceCountUtil;
import java.lang.ref.WeakReference;
import java.util.UUID;
import mcp.mobius.opis.data.holders.basetypes.SerialInt;
import mcp.mobius.opis.data.holders.basetypes.SerialLong;
import mcp.mobius.opis.data.holders.newtypes.ConnectionProperties;
import mcp.mobius.opis.data.holders.newtypes.NexusAuth;
import mcp.mobius.opis.data.managers.StringCache;
import mcp.mobius.opis.events.PlayerTracker;
import mcp.mobius.opis.modOpis;
import mcp.mobius.opis.network.PacketBase;
import mcp.mobius.opis.network.enums.Message;
import mcp.mobius.opis.network.packets.client.PacketReqData;
import mcp.mobius.opis.network.packets.server.NetDataValue;
import mcp.mobius.opis.network.rcon.RConHandler;
import mcp.mobius.opis.network.rcon.nexus.EventTimerRing;
import mcp.mobius.opis.network.rcon.nexus.NexusClient;
import mcp.mobius.opis.swing.SelectedTab;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;

public class NexusInboundHandler
extends ChannelInboundHandlerAdapter {
    public EventTimerRing timers = new EventTimerRing();

    @Override
    public void handlerAdded(ChannelHandlerContext ctx) {
        NexusClient.instance.ctx = new WeakReference<ChannelHandlerContext>(ctx);
        RConHandler.sendToContext(new NetDataValue(Message.NEXUS_UUID, new NexusAuth(NexusClient.instance.uuid, NexusClient.instance.pass, NexusClient.instance.reconnect)), ctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        try {
            FakePlayer fakePlayer = (FakePlayer)RConHandler.fakePlayersNexus.inverse().get((Object)ctx);
            PacketBase packet = (PacketBase)msg;
            if (packet instanceof PacketReqData && ((PacketReqData)packet).dataReq == Message.CONNECTION_STATUS) {
                PacketReqData pck = (PacketReqData)packet;
                int status = ((SerialInt)pck.param1).value;
                if (status == 0) {
                    modOpis.log.error(String.format("Connection refused. Wrong uuid or pass.", new Object[0]));
                    NexusClient.instance.shouldRetry = false;
                } else if (status == 1) {
                    this.registerFakePlayer(ctx);
                    this.timers = new EventTimerRing(((ConnectionProperties)pck.param2).prop);
                }
            } else {
                packet.actionServer(null, (EntityPlayerMP)fakePlayer);
            }
        }
        finally {
            ReferenceCountUtil.release(msg);
        }
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        RConHandler.exceptionCaught(ctx, cause);
    }

    private void registerFakePlayer(ChannelHandlerContext ctx) {
        UUID fakeUUID = UUID.randomUUID();
        FakePlayer fakePlayer = FakePlayerFactory.get((WorldServer)DimensionManager.getWorld((int)0), (GameProfile)new GameProfile(fakeUUID, ctx.name()));
        RConHandler.fakePlayersNexus.put((Object)fakePlayer, (Object)ctx);
        PlayerTracker.INSTANCE.playersSwing.add((EntityPlayerMP)fakePlayer);
        PlayerTracker.INSTANCE.playerTab.put((EntityPlayerMP)fakePlayer, SelectedTab.ALL);
        RConHandler.sendToContext(new NetDataValue(Message.STATUS_CURRENT_TIME, new SerialLong(System.currentTimeMillis())), ctx);
        StringCache.INSTANCE.syncCache((EntityPlayerMP)fakePlayer);
        modOpis.log.info(String.format("FakePlayer %s with uuid %s registered.", ctx.name(), fakeUUID));
    }
}

