/*
 * Decompiled with CFR 0.152.
 */
package gcewing.projectblue;

import gcewing.projectblue.BaseContainer;
import gcewing.projectblue.BaseMod;
import gcewing.projectblue.BaseModClient;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import org.lwjgl.opengl.GL11;

public class BaseGuiContainer
extends GuiContainer
implements BaseMod.ISetMod {
    static final int defaultTextColor = 0x404040;
    BaseMod mod;
    double uscale;
    double vscale;
    float red = 1.0f;
    float green = 1.0f;
    float blue = 1.0f;
    public int textColor = 0x404040;
    public boolean textShadow = false;

    public BaseGuiContainer(Container container, int n, int n2) {
        super(container);
        this.field_146999_f = n;
        this.field_147000_g = n2;
    }

    public BaseGuiContainer(BaseContainer baseContainer) {
        this(baseContainer, baseContainer.xSize, baseContainer.ySize);
    }

    @Override
    public void setMod(BaseMod baseMod) {
        this.mod = baseMod;
    }

    public void func_73863_a(int n, int n2, float f) {
        this.resetColor();
        this.textColor = 0x404040;
        this.textShadow = false;
        super.func_73863_a(n, n2, f);
    }

    protected void func_146976_a(float f, int n, int n2) {
        GL11.glPushMatrix();
        GL11.glTranslatef((float)this.field_147003_i, (float)this.field_147009_r, (float)0.0f);
        this.drawBackgroundLayer();
        GL11.glPopMatrix();
    }

    protected void drawBackgroundLayer() {
    }

    protected void func_146979_b(int n, int n2) {
        this.drawForegroundLayer();
    }

    protected void drawForegroundLayer() {
    }

    void close() {
        this.field_146297_k.field_71439_g.func_71053_j();
    }

    public void bindTexture(String string) {
        this.bindTexture(string, 1, 1);
    }

    public void bindTexture(String string, int n, int n2) {
        this.bindTexture(((BaseModClient)this.mod.client).textureLocation(string), n, n2);
    }

    public void bindTexture(ResourceLocation resourceLocation) {
        this.bindTexture(resourceLocation, 1, 1);
    }

    public void bindTexture(ResourceLocation resourceLocation, int n, int n2) {
        this.field_146297_k.func_110434_K().func_110577_a(resourceLocation);
        this.uscale = 1.0 / (double)n;
        this.vscale = 1.0 / (double)n2;
    }

    public void drawRect(double d, double d2, double d3, double d4) {
        GL11.glDisable((int)3553);
        GL11.glColor3d((double)this.red, (double)this.green, (double)this.blue);
        GL11.glBegin((int)7);
        GL11.glVertex3d((double)d, (double)(d2 + d4), (double)this.field_73735_i);
        GL11.glVertex3d((double)(d + d3), (double)(d2 + d4), (double)this.field_73735_i);
        GL11.glVertex3d((double)(d + d3), (double)d2, (double)this.field_73735_i);
        GL11.glVertex3d((double)d, (double)d2, (double)this.field_73735_i);
        GL11.glEnd();
        GL11.glEnable((int)3553);
    }

    public void drawTexturedRect(double d, double d2, double d3, double d4) {
        this.drawTexturedRectUV(d, d2, d3, d4, 0.0, 0.0, 1.0, 1.0);
    }

    public void drawTexturedRect(double d, double d2, double d3, double d4, double d5, double d6) {
        this.drawTexturedRect(d, d2, d3, d4, d5, d6, d3, d4);
    }

    public void drawTexturedRect(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8) {
        this.drawTexturedRectUV(d, d2, d3, d4, d5 * this.uscale, d6 * this.vscale, d7 * this.uscale, d8 * this.vscale);
    }

    public void drawTexturedRectUV(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8) {
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78386_a(this.red, this.green, this.blue);
        tessellator.func_78374_a(d, d2 + d4, (double)this.field_73735_i, d5, d6 + d8);
        tessellator.func_78374_a(d + d3, d2 + d4, (double)this.field_73735_i, d5 + d7, d6 + d8);
        tessellator.func_78374_a(d + d3, d2, (double)this.field_73735_i, d5 + d7, d6);
        tessellator.func_78374_a(d, d2, (double)this.field_73735_i, d5, d6);
        tessellator.func_78381_a();
    }

    public void setColor(int n) {
        this.setColor((double)(n >> 16) / 255.0, (double)(n >> 8 & 0xFF) / 255.0, (double)(n & 0xFF) / 255.0);
    }

    public void setColor(double d, double d2, double d3) {
        this.red = (float)d;
        this.green = (float)d2;
        this.blue = (float)d3;
    }

    public void resetColor() {
        this.setColor(1.0, 1.0, 1.0);
    }

    public void drawString(String string, int n, int n2) {
        this.field_146289_q.func_85187_a(string, n, n2, this.textColor, this.textShadow);
    }

    public void drawCenteredString(String string, int n, int n2) {
        this.field_146289_q.func_85187_a(string, n - this.field_146289_q.func_78256_a(string) / 2, n2, this.textColor, this.textShadow);
    }

    public void drawRightAlignedString(String string, int n, int n2) {
        this.field_146289_q.func_85187_a(string, n - this.field_146289_q.func_78256_a(string), n2, this.textColor, this.textShadow);
    }

    public void drawInventoryName(IInventory iInventory, int n, int n2) {
        this.drawString(BaseGuiContainer.inventoryName(iInventory), n, n2);
    }

    public void drawPlayerInventoryName() {
        this.drawString(BaseGuiContainer.playerInventoryName(), 8, this.field_147000_g - 96 + 2);
    }

    public static String inventoryName(IInventory iInventory) {
        String string = iInventory.func_145825_b();
        if (!iInventory.func_145818_k_()) {
            string = StatCollector.func_74838_a((String)string);
        }
        return string;
    }

    public static String playerInventoryName() {
        return StatCollector.func_74838_a((String)"container.inventory");
    }
}

