/*
 * Decompiled with CFR 0.152.
 */
package gcewing.projectblue;

import codechicken.lib.vec.BlockCoord;
import codechicken.lib.vec.Rotation;
import codechicken.multipart.TMultiPart;
import codechicken.multipart.TileMultipart;
import mrtjp.projectred.api.IBundledEmitter;
import mrtjp.projectred.core.libmc.PRLib;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;

public class BundledUtils {
    static byte[] signal = new byte[16];

    public static byte[] getAllSignals(TMultiPart tMultiPart, int n) {
        return BundledUtils.getAllSignals(tMultiPart, n, 3);
    }

    public static byte[] getAllSignals(TMultiPart tMultiPart, int n, int n2) {
        BundledUtils.clearSignal(signal);
        for (int i = 0; i <= 3; ++i) {
            if ((n2 & 1 << i) == 0) continue;
            BundledUtils.addSignal(signal, BundledUtils.getCornerSignal(tMultiPart, n, i));
            BundledUtils.addSignal(signal, BundledUtils.getStraightSignal(tMultiPart, n, i));
            BundledUtils.addSignal(signal, BundledUtils.getInternalSignal(tMultiPart, n, i));
        }
        BundledUtils.addSignal(signal, BundledUtils.getCenterSignal(tMultiPart, n));
        return signal;
    }

    public static void clearSignal(byte[] byArray) {
        for (int i = 0; i <= 15; ++i) {
            byArray[i] = 0;
        }
    }

    public static void addSignal(byte[] byArray, byte[] byArray2) {
        if (byArray2 != null) {
            for (int i = 0; i <= 15; ++i) {
                if ((byArray[i] & 0xFF) >= (byArray2[i] & 0xFF)) continue;
                byArray[i] = byArray2[i];
            }
        }
    }

    public static byte[] getCornerSignal(TMultiPart tMultiPart, int n, int n2) {
        int n3 = Rotation.rotateSide((int)n, (int)n2);
        BlockCoord blockCoord = new BlockCoord((TileEntity)tMultiPart.tile()).offset(n3).offset(n);
        TileMultipart tileMultipart = PRLib.getMultipartTile((IBlockAccess)tMultiPart.world(), (BlockCoord)blockCoord);
        if (tileMultipart != null) {
            return BundledUtils.getBundledPartSignal(tileMultipart.partMap(n3 ^ 1), Rotation.rotationTo((int)(n3 ^ 1), (int)(n ^ 1)));
        }
        return null;
    }

    public static byte[] getStraightSignal(TMultiPart tMultiPart, int n, int n2) {
        int n3 = Rotation.rotateSide((int)n, (int)n2);
        BlockCoord blockCoord = new BlockCoord((TileEntity)tMultiPart.tile()).offset(n3);
        TileEntity tileEntity = tMultiPart.world().func_147438_o(blockCoord.x, blockCoord.y, blockCoord.z);
        if (tileEntity instanceof IBundledEmitter) {
            return BundledUtils.getBundledPartSignal(tileEntity, n3 ^ 1);
        }
        if (tileEntity instanceof TileMultipart) {
            return BundledUtils.getBundledPartSignal(((TileMultipart)tileEntity).partMap(n), (n2 + 2) % 4);
        }
        return null;
    }

    public static byte[] getInternalSignal(TMultiPart tMultiPart, int n, int n2) {
        int n3 = Rotation.rotateSide((int)n, (int)n2);
        TMultiPart tMultiPart2 = tMultiPart.tile().partMap(n3);
        return BundledUtils.getBundledPartSignal(tMultiPart2, Rotation.rotationTo((int)n3, (int)n));
    }

    public static byte[] getCenterSignal(TMultiPart tMultiPart, int n) {
        TMultiPart tMultiPart2 = tMultiPart.tile().partMap(6);
        if (tMultiPart2 != tMultiPart) {
            return BundledUtils.getBundledPartSignal(tMultiPart2, n);
        }
        return null;
    }

    public static byte[] getBundledPartSignal(Object object, int n) {
        if (object instanceof IBundledEmitter) {
            return ((IBundledEmitter)object).getBundledSignal(n);
        }
        return null;
    }
}

