/*
 * Decompiled with CFR 0.152.
 */
package gcewing.projectblue;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import codechicken.lib.vec.Cuboid6;
import codechicken.multipart.MultiPartRegistry;
import codechicken.multipart.TMultiPart;
import gcewing.projectblue.BundledUtils;
import gcewing.projectblue.ControlPanelMaterial;
import gcewing.projectblue.ControlPanelRenderer;
import gcewing.projectblue.FaceUtils;
import gcewing.projectblue.Matrix3;
import gcewing.projectblue.PBFacePart;
import gcewing.projectblue.ProjectBlue;
import gcewing.projectblue.Trans3;
import gcewing.projectblue.Vector3;
import java.util.ArrayList;
import mrtjp.projectred.api.IBundledEmitter;
import mrtjp.projectred.api.IConnectable;
import mrtjp.projectred.core.ItemScrewdriver;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;

public class ControlPanelPart
extends PBFacePart
implements IConnectable,
IBundledEmitter {
    static final int buttonDownTime = 20;
    static Cuboid6[] bounds = ControlPanelPart.newBounds(0.0, 0.0, 0.0, 1.0, 0.125, 1.0);
    static Matrix3 surfaceMountRotation = Matrix3.rotZ(180.0);
    public int mounting;
    public int connectionMask;
    byte[] controlTypes = new byte[16];
    byte[] controlStates = new byte[16];
    byte[] controlMetadata = new byte[16];
    public String[][] labels = new String[16][2];
    public ControlPanelMaterial base;
    long[] releaseTime = new long[16];
    byte[] signal = new byte[16];
    static long lastActivateTime = 0L;

    public ControlPanelPart() {
        for (int i = 0; i < 16; ++i) {
            for (int j = 0; j < 2; ++j) {
                this.labels[i][j] = "";
            }
        }
    }

    public ControlPanelPart(String string, int n) {
        this(string, n, null);
    }

    public ControlPanelPart(String string, int n, NBTTagCompound nBTTagCompound) {
        this(ControlPanelMaterial.forName(string), n, nBTTagCompound);
    }

    public ControlPanelPart(ControlPanelMaterial controlPanelMaterial, int n, NBTTagCompound nBTTagCompound) {
        this();
        this.base = controlPanelMaterial;
        this.side = n;
        this.mounting = 1;
        if (nBTTagCompound != null) {
            this.loadControls(nBTTagCompound);
        }
    }

    @Override
    public Cuboid6[] getBoundsArray() {
        return bounds;
    }

    void setMaterial(String string) {
        this.base = ControlPanelMaterial.forName(string);
    }

    public ControlType getControlType(int n) {
        return ControlType.values[this.controlTypes[n]];
    }

    public void setControlType(int n, ControlType controlType) {
        this.controlTypes[n] = (byte)controlType.ordinal();
    }

    public int getControlState(int n) {
        return this.controlStates[n];
    }

    public void setControlState(int n, int n2) {
        this.controlStates[n] = (byte)n2;
    }

    public int getControlMeta(int n) {
        return this.controlMetadata[n] & 0xFF;
    }

    public void setControlMeta(int n, int n2) {
        this.controlMetadata[n] = (byte)n2;
    }

    public void setFlushMounting() {
        this.mounting = 0;
    }

    public void setSurfaceMounting() {
        this.mounting = 1;
    }

    @Override
    public String getType() {
        return "pb_controlpanel";
    }

    @Override
    public Cuboid6 getBounds() {
        return bounds[this.side];
    }

    @Override
    public void writeDesc(MCDataOutput mCDataOutput) {
        super.writeDesc(mCDataOutput);
        mCDataOutput.writeString(this.base.name);
        mCDataOutput.writeByte(this.mounting);
        for (int i = 0; i < 16; ++i) {
            mCDataOutput.writeByte((int)this.controlTypes[i]);
            mCDataOutput.writeByte((int)this.controlStates[i]);
            mCDataOutput.writeByte((int)this.controlMetadata[i]);
            for (int j = 0; j < 2; ++j) {
                mCDataOutput.writeString(this.labels[i][j]);
            }
        }
    }

    @Override
    public void readDesc(MCDataInput mCDataInput) {
        super.readDesc(mCDataInput);
        String string = mCDataInput.readString();
        if (this.base == null) {
            this.setMaterial(string);
        }
        this.mounting = mCDataInput.readByte();
        for (int i = 0; i < 16; ++i) {
            this.controlTypes[i] = mCDataInput.readByte();
            this.controlStates[i] = mCDataInput.readByte();
            this.controlMetadata[i] = mCDataInput.readByte();
            for (int j = 0; j < 2; ++j) {
                this.labels[i][j] = mCDataInput.readString();
            }
        }
    }

    @Override
    public void save(NBTTagCompound nBTTagCompound) {
        super.save(nBTTagCompound);
        nBTTagCompound.func_74778_a("material", this.base.name);
        nBTTagCompound.func_74768_a("mounting", this.mounting);
        nBTTagCompound.func_74768_a("connectionMask", this.connectionMask);
        this.saveControls(nBTTagCompound);
        nBTTagCompound.func_74773_a("controlStates", this.controlStates);
    }

    public void saveControls(NBTTagCompound nBTTagCompound) {
        nBTTagCompound.func_74773_a("controlTypes", this.controlTypes);
        nBTTagCompound.func_74773_a("controlMetadata", this.controlMetadata);
        NBTTagList nBTTagList = new NBTTagList();
        for (int i = 0; i < 16; ++i) {
            for (int j = 0; j < 2; ++j) {
                nBTTagList.func_74742_a((NBTBase)new NBTTagString(this.labels[i][j]));
            }
        }
        nBTTagCompound.func_74782_a("labels", (NBTBase)nBTTagList);
    }

    @Override
    public void load(NBTTagCompound nBTTagCompound) {
        super.load(nBTTagCompound);
        if (nBTTagCompound.func_74764_b("material")) {
            this.setMaterial(nBTTagCompound.func_74779_i("material"));
        } else {
            this.setMaterial("tile.wood");
        }
        this.mounting = nBTTagCompound.func_74762_e("mounting");
        this.connectionMask = nBTTagCompound.func_74764_b("connectionMask") ? nBTTagCompound.func_74762_e("connectionMask") : 3;
        this.loadControls(nBTTagCompound);
        if (nBTTagCompound.func_74764_b("controlStates")) {
            this.controlStates = nBTTagCompound.func_74770_j("controlStates");
        }
    }

    public void loadControls(NBTTagCompound nBTTagCompound) {
        if (nBTTagCompound.func_74764_b("controlTypes")) {
            this.controlTypes = nBTTagCompound.func_74770_j("controlTypes");
        }
        if (nBTTagCompound.func_74764_b("controlMetadata")) {
            this.controlMetadata = nBTTagCompound.func_74770_j("controlMetadata");
        }
        if (nBTTagCompound.func_74764_b("labels")) {
            NBTTagList nBTTagList = nBTTagCompound.func_150295_c("labels", 8);
            for (int i = 0; i < 16; ++i) {
                for (int j = 0; j < 2; ++j) {
                    int n = i * 2 + j;
                    this.labels[i][j] = nBTTagList.func_150307_f(n);
                }
            }
        }
    }

    @Override
    public boolean renderStatic(codechicken.lib.vec.Vector3 vector3, int n) {
        if (n == 0) {
            ControlPanelRenderer.instance.renderStaticInWorld(this, vector3.x, vector3.y, vector3.z);
        }
        return false;
    }

    @Override
    public void renderDynamic(codechicken.lib.vec.Vector3 vector3, float f, int n) {
        if (n == 0) {
            ControlPanelRenderer.instance.renderDynamicInWorld(this, vector3.x, vector3.y, vector3.z, f);
        }
    }

    public void onPartChanged(TMultiPart tMultiPart) {
        this.updateInputs();
    }

    public void onNeighborChanged() {
        this.updateInputs();
    }

    void updateInputs() {
        if (!this.world().field_72995_K) {
            this.getInputs();
            this.tile().func_70296_d();
            this.sendDescUpdate();
        }
    }

    void getInputs() {
        byte[] byArray = BundledUtils.getAllSignals(this, this.side, this.connectionMask);
        for (int i = 0; i <= 15; ++i) {
            switch (this.getControlType(i)) {
                case LAMP: {
                    this.setControlState(i, byArray[i] != 0 ? 1 : 0);
                }
            }
        }
    }

    public void click(EntityPlayer entityPlayer, MovingObjectPosition movingObjectPosition, ItemStack itemStack) {
        System.out.printf("ControlPanelPart.click: remote = %s with %s\n", this.world().field_72995_K, itemStack);
        if (!this.world().field_72995_K && entityPlayer.func_70093_af() && itemStack.func_77973_b() instanceof ItemScrewdriver) {
            this.harvest(movingObjectPosition, entityPlayer);
        }
    }

    public boolean activate(EntityPlayer entityPlayer, MovingObjectPosition movingObjectPosition, ItemStack itemStack) {
        long l;
        if (!this.world().field_72995_K && (l = this.world().func_82737_E()) != lastActivateTime) {
            lastActivateTime = l;
            Trans3 trans3 = this.localToGlobalTransformation(movingObjectPosition.field_72311_b, movingObjectPosition.field_72312_c, movingObjectPosition.field_72309_d);
            Vector3 vector3 = trans3.ip(movingObjectPosition.field_72307_f.field_72450_a, movingObjectPosition.field_72307_f.field_72448_b, movingObjectPosition.field_72307_f.field_72449_c);
            int n = (int)Math.floor((vector3.z + 0.5) * 4.0);
            int n2 = (int)Math.floor((-vector3.x + 0.5) * 4.0);
            if (n >= 0 && n <= 3 && n2 >= 0 && n2 <= 3) {
                this.activateCell(n * 4 + n2, entityPlayer, itemStack);
            }
        }
        return true;
    }

    void activateCell(int n, EntityPlayer entityPlayer, ItemStack itemStack) {
        System.out.printf("ControlPanelPart.activateCell: %s containing %s with %s\n", new Object[]{n, this.getControlType(n), itemStack});
        if (itemStack != null) {
            Item item = itemStack.func_77973_b();
            int n2 = itemStack.func_77960_j();
            NBTTagCompound nBTTagCompound = itemStack.func_77978_p();
            if (item instanceof ItemScrewdriver) {
                if (entityPlayer.func_70093_af()) {
                    this.changeMounting();
                } else if (this.getControlType(n) != ControlType.NONE) {
                    this.removeControl(n, entityPlayer);
                } else {
                    this.changeRotation();
                }
                return;
            }
            if (item == Items.field_151044_h && n2 == 1) {
                this.editText(n, entityPlayer);
                return;
            }
            if (this.getControlType(n) == ControlType.NONE) {
                if (item == ProjectBlue.miniatureLever) {
                    this.placeControl(n, ControlType.LEVER, entityPlayer, n2, itemStack);
                    return;
                }
                if (item == ProjectBlue.miniatureButton) {
                    this.placeControl(n, ControlType.BUTTON, entityPlayer, n2, itemStack);
                    return;
                }
                if (item == ProjectBlue.miniatureLamp) {
                    this.placeControl(n, ControlType.LAMP, entityPlayer, n2, itemStack);
                    return;
                }
                if (item == ProjectBlue.miniatureCover && nBTTagCompound.func_74779_i("mat").equals(this.base.name)) {
                    this.placeControl(n, ControlType.BLANK, entityPlayer, 0, itemStack);
                    return;
                }
            }
        }
        this.activateControl(n);
    }

    void placeControl(int n, ControlType controlType, EntityPlayer entityPlayer, int n2, ItemStack itemStack) {
        if (!entityPlayer.field_71075_bZ.field_75098_d) {
            --itemStack.field_77994_a;
        }
        this.setControlType(n, controlType);
        this.setControlMeta(n, n2);
        this.getInputs();
        this.changed();
    }

    void removeControl(int n, EntityPlayer entityPlayer) {
        if (!entityPlayer.field_71075_bZ.field_75098_d) {
            this.drop(this.stackForControl(n));
        }
        this.setControlType(n, ControlType.NONE);
        this.setControlState(n, 0);
        this.changed();
    }

    void changeMounting() {
        this.mounting ^= 1;
        this.changed();
    }

    void changeRotation() {
        System.out.printf("ControlPanelPart.changeRotation\n", new Object[0]);
        this.rot = this.rot + 1 & 3;
        this.changed();
    }

    void editText(int n, EntityPlayer entityPlayer) {
        ProjectBlue.channel.sendEditControlPanelText(entityPlayer, this, n);
    }

    public void harvest(MovingObjectPosition movingObjectPosition, EntityPlayer entityPlayer) {
        this.tile().dropItems(this.getDrops());
        this.tile().remPart((TMultiPart)this);
    }

    public Iterable<ItemStack> getDrops() {
        ArrayList<ItemStack> arrayList = new ArrayList<ItemStack>();
        ItemStack itemStack = this.base.newStack();
        this.saveControls(itemStack.func_77978_p());
        arrayList.add(itemStack);
        return arrayList;
    }

    ItemStack stackForControl(int n) {
        ItemStack itemStack = null;
        NBTTagCompound nBTTagCompound = null;
        int n2 = this.getControlMeta(n);
        switch (this.getControlType(n)) {
            case LEVER: {
                itemStack = new ItemStack(ProjectBlue.miniatureLever, 1, n2);
                break;
            }
            case BUTTON: {
                itemStack = new ItemStack(ProjectBlue.miniatureButton, 1, n2);
                break;
            }
            case LAMP: {
                itemStack = new ItemStack(ProjectBlue.miniatureLamp, 1, n2);
                break;
            }
            case BLANK: {
                itemStack = new ItemStack(ProjectBlue.miniatureCover);
                nBTTagCompound = new NBTTagCompound();
                nBTTagCompound.func_74778_a("mat", this.base.name);
            }
        }
        if (itemStack != null) {
            itemStack.func_77982_d(nBTTagCompound);
        }
        return itemStack;
    }

    void drop(ItemStack itemStack) {
        if (itemStack != null) {
            Trans3 trans3 = this.localToGlobalTransformation();
            Vector3 vector3 = trans3.p(0.0, -0.6, 0.0);
            World world = this.world();
            EntityItem entityItem = new EntityItem(world, vector3.x, vector3.y, vector3.z, itemStack);
            entityItem.field_70159_w = world.field_73012_v.nextGaussian() * 0.05;
            entityItem.field_70181_x = world.field_73012_v.nextGaussian() * 0.05 + 0.2;
            entityItem.field_70179_y = world.field_73012_v.nextGaussian() * 0.05;
            entityItem.field_145804_b = 10;
            world.func_72838_d((Entity)entityItem);
        }
    }

    void activateControl(int n) {
        switch (this.getControlType(n)) {
            case LEVER: {
                this.toggleLever(n);
                break;
            }
            case BUTTON: {
                this.pressButton(n);
            }
        }
    }

    void toggleLever(int n) {
        int n2 = this.getControlState(n) ^ 1;
        this.setControlState(n, n2);
        this.playClick(n2 > 0 ? 0.6 : 0.5);
        this.changed();
    }

    void pressButton(int n) {
        this.setControlState(n, 1);
        this.releaseTime[n] = this.world().func_82737_E() + 20L;
        this.scheduleTick(20);
        this.playClick(0.6);
        this.changed();
    }

    public void scheduledTick() {
        long l = this.world().func_82737_E();
        long l2 = -1L;
        boolean bl = false;
        block3: for (int i = 0; i < 16; ++i) {
            switch (this.getControlType(i)) {
                case BUTTON: {
                    if (this.getControlState(i) <= 0) continue block3;
                    if (l >= this.releaseTime[i]) {
                        this.setControlState(i, 0);
                        bl = true;
                        continue block3;
                    }
                    if (l2 >= 0L && l2 <= this.releaseTime[i]) continue block3;
                    l2 = this.releaseTime[i];
                }
            }
        }
        if (l2 >= 0L) {
            this.scheduleTick((int)(l2 - l));
        }
        if (bl) {
            this.playClick(0.5);
            this.changed();
        }
    }

    void playClick(double d) {
        this.world().func_72908_a((double)this.x() + 0.5, (double)this.y() + 0.5, (double)this.z() + 0.5, "random.click", 0.3f, (float)d);
    }

    public void setLabel(int n, int n2, String string) {
        this.labels[n][n2] = string;
        this.changed();
    }

    @Override
    public void changed() {
        FaceUtils.notifyAllNeighbors(this, this.side);
        super.changed();
    }

    public Trans3 localToGlobalTransformation() {
        return this.localToGlobalTransformation(this.x(), this.y(), this.z());
    }

    public Trans3 localToGlobalTransformation(double d, double d2, double d3) {
        Trans3 trans3 = new Trans3(d + 0.5, d2 + 0.5, d3 + 0.5).side(this.side).turn(this.rot).translate(0.0, -0.4375, 0.0);
        if (this.mounting == 1) {
            trans3 = trans3.rotate(surfaceMountRotation);
        }
        return trans3;
    }

    public boolean connectStraight(IConnectable iConnectable, int n, int n2) {
        return this.connectTo(iConnectable, n);
    }

    public boolean connectInternal(IConnectable iConnectable, int n) {
        return this.connectTo(iConnectable, n);
    }

    public boolean connectCorner(IConnectable iConnectable, int n, int n2) {
        return this.connectTo(iConnectable, n);
    }

    public boolean canConnectCorner(int n) {
        return true;
    }

    boolean connectTo(IConnectable iConnectable, int n) {
        if (!(iConnectable instanceof ControlPanelPart)) {
            this.connectionMask |= 1 << n;
            this.markDirty();
            return true;
        }
        return false;
    }

    public byte[] getBundledSignal(int n) {
        block3: for (int i = 0; i < 16; ++i) {
            switch (this.getControlType(i)) {
                case LEVER: 
                case BUTTON: {
                    this.signal[i] = (byte)(255 * this.getControlState(i));
                    continue block3;
                }
                default: {
                    this.signal[i] = 0;
                }
            }
        }
        return this.signal;
    }

    public static enum ControlType {
        NONE,
        BLANK,
        LEVER,
        BUTTON,
        LAMP;

        public static ControlType[] values;

        static {
            values = ControlType.values();
        }
    }

    public static class Factory
    implements MultiPartRegistry.IPartFactory {
        public TMultiPart createPart(String string, boolean bl) {
            ControlPanelPart controlPanelPart = new ControlPanelPart();
            return controlPanelPart;
        }
    }
}

