/*
 * Decompiled with CFR 0.152.
 */
package gcewing.projectblue;

import codechicken.lib.vec.BlockCoord;
import codechicken.microblock.FacePlacementGrid;
import gcewing.projectblue.BaseBlockRenderer;
import gcewing.projectblue.ControlItem;
import gcewing.projectblue.ControlPanelMaterial;
import gcewing.projectblue.ControlPanelPart;
import gcewing.projectblue.Matrix3;
import gcewing.projectblue.PBModel;
import gcewing.projectblue.ProjectBlue;
import gcewing.projectblue.Trans3;
import gcewing.projectblue.Trans3GL;
import gcewing.projectblue.Utils;
import gcewing.projectblue.Vector3;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.util.Vec3;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.client.event.DrawBlockHighlightEvent;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;

public class ControlPanelRenderer
extends BaseBlockRenderer<Block> {
    static final double h = 0.0625;
    static final double d1 = 0.001;
    static final double d2 = 0.01;
    static float[] sideShading = new float[]{0.5f, 1.0f, 0.8f, 0.8f, 0.6f, 0.6f};
    static double[][] colors = new double[][]{{1.0, 1.0, 1.0}, {1.0, 0.5, 0.0}, {1.0, 0.0, 1.0}, {0.5, 0.5, 1.0}, {1.0, 1.0, 0.0}, {0.5, 1.0, 0.5}, {1.0, 0.5, 0.5}, {0.5, 0.5, 0.5}, {0.75, 0.75, 0.75}, {0.0, 1.0, 1.0}, {0.5, 0.0, 1.0}, {0.0, 0.0, 1.0}, {0.5, 0.25, 0.0}, {0.0, 1.0, 0.0}, {1.0, 0.0, 0.0}, {0.25, 0.25, 0.25}};
    static AxisAlignedBB panelBox = AxisAlignedBB.func_72330_a((double)-0.5, (double)-0.0635, (double)-0.5, (double)0.5, (double)0.0635, (double)0.5);
    static Matrix3[] leverRotations = new Matrix3[]{Matrix3.rotX(45.0), Matrix3.rotX(-45.0)};
    public static ControlPanelRenderer instance;
    static IIcon frontCutoutIcon;
    static IIcon backCutoutIcon;
    static IIcon lampIcon;
    static PBModel leverBaseModel;
    static PBModel leverHandleModel;
    static PBModel buttonModel;
    static PBModel lampModel;
    static PBModel coverModel;
    ControlPanelPart part;
    Phase phase;
    int globalSide;
    float alpha;
    boolean renderingInInventory;
    boolean debugLightVertex = false;

    public static void init() {
        leverBaseModel = ProjectBlue.getModel("lever_base");
        leverHandleModel = ProjectBlue.getModel("lever_handle");
        buttonModel = ProjectBlue.getModel("button");
        lampModel = ProjectBlue.getModel("lamp");
        coverModel = ProjectBlue.getModel("cover");
        instance = new ControlPanelRenderer();
    }

    public static void registerIcons(IIconRegister iIconRegister) {
        frontCutoutIcon = iIconRegister.func_94245_a("gcewing_projectblue:controlpanel_cutout_front");
        backCutoutIcon = iIconRegister.func_94245_a("gcewing_projectblue:controlpanel_cutout_back");
        lampIcon = iIconRegister.func_94245_a("gcewing_projectblue:controlpanel_lamp");
        System.out.printf("ControlPanelRenderer.registerIcons: icons = %s %s %s\n", frontCutoutIcon, backCutoutIcon, lampIcon);
    }

    void bindBlockTextures() {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(TextureMap.field_110575_b);
    }

    public void renderStaticInWorld(ControlPanelPart controlPanelPart, double d, double d2, double d3) {
        this.renderInWorld(controlPanelPart, d, d2, d3, Phase.STATIC);
    }

    public void renderDynamicInWorld(ControlPanelPart controlPanelPart, double d, double d2, double d3, float f) {
        this.bindBlockTextures();
        this.renderInWorld(controlPanelPart, d, d2, d3, Phase.DYNAMIC);
    }

    public boolean renderHighlight(ControlPanelPart controlPanelPart, DrawBlockHighlightEvent drawBlockHighlightEvent, BlockCoord blockCoord) {
        EntityPlayer entityPlayer = drawBlockHighlightEvent.player;
        Vec3 vec3 = drawBlockHighlightEvent.target.field_72307_f;
        int n = drawBlockHighlightEvent.target.field_72310_e;
        float f = drawBlockHighlightEvent.partialTicks;
        GL11.glPushMatrix();
        GL11.glPushAttrib((int)8192);
        GL11.glTranslated((double)(-(entityPlayer.field_70142_S + (entityPlayer.field_70165_t - entityPlayer.field_70142_S) * (double)f)), (double)(-(entityPlayer.field_70137_T + (entityPlayer.field_70163_u - entityPlayer.field_70137_T) * (double)f)), (double)(-(entityPlayer.field_70136_U + (entityPlayer.field_70161_v - entityPlayer.field_70136_U) * (double)f)));
        FacePlacementGrid.render((codechicken.lib.vec.Vector3)Utils.ccVector3(vec3), (int)n);
        this.setup(controlPanelPart.base);
        this.world = entityPlayer.field_70170_p;
        this.blockX = blockCoord.x;
        this.blockY = blockCoord.y;
        this.blockZ = blockCoord.z;
        Trans3 trans3 = controlPanelPart.localToGlobalTransformation(blockCoord.x, blockCoord.y, blockCoord.z);
        this.phase = Phase.STATIC;
        this.bindBlockTextures();
        GL11.glEnable((int)3042);
        this.alpha = 0.5f;
        this.tess.func_78382_b();
        this.debugLightVertex = true;
        this.renderPart(trans3);
        this.debugLightVertex = false;
        this.tess.func_78381_a();
        GL11.glPopAttrib();
        GL11.glPopMatrix();
        return true;
    }

    public void renderStack(ItemStack itemStack, IItemRenderer.ItemRenderType itemRenderType) {
        ControlPanelMaterial controlPanelMaterial = ControlPanelMaterial.forStack(itemStack);
        this.setup(controlPanelMaterial);
        int n = 2;
        if (itemRenderType == IItemRenderer.ItemRenderType.INVENTORY) {
            this.renderingInInventory = true;
            n = 3;
        }
        this.part = new ControlPanelPart(controlPanelMaterial, n, itemStack.func_77978_p());
        Trans3 trans3 = new Trans3(0.5, 0.5, 0.5).side(this.part.side);
        this.phase = Phase.STATIC;
        this.tess.func_78382_b();
        this.renderPart(trans3);
        this.tess.func_78381_a();
        this.phase = Phase.DYNAMIC;
        this.renderPart(trans3);
    }

    public void renderControlItemStack(ItemStack itemStack, IItemRenderer.ItemRenderType itemRenderType) {
        this.setup(ControlPanelMaterial.forStack(itemStack));
        this.renderControlItem((ControlItem)itemStack.func_77973_b(), itemStack.func_77960_j(), itemRenderType);
    }

    void renderControlItem(ControlItem controlItem, int n, IItemRenderer.ItemRenderType itemRenderType) {
        this.renderingInInventory = false;
        this.bindBlockTextures();
        Trans3 trans3 = new Trans3(0.5, 0.5, 0.5);
        switch (itemRenderType) {
            case INVENTORY: {
                this.renderingInInventory = true;
                trans3 = trans3.side(3).scale(4.0);
                break;
            }
            case EQUIPPED: {
                trans3 = trans3.side(3).scale(3.0).translate(0.0, 0.2, 0.05);
                break;
            }
            case EQUIPPED_FIRST_PERSON: {
                trans3 = trans3.side(2).translate(0.0, -0.5, 0.15);
                break;
            }
            default: {
                trans3 = trans3.side(2).scale(2.0);
            }
        }
        this.phase = Phase.STATIC;
        this.tess.func_78382_b();
        this.renderControlType(trans3, controlItem.type, n);
        this.tess.func_78381_a();
        this.phase = Phase.DYNAMIC;
        this.renderControlType(trans3, controlItem.type, n);
    }

    void renderControlType(Trans3 trans3, ControlPanelPart.ControlType controlType, int n) {
        switch (controlType) {
            case LEVER: {
                this.renderLever(trans3, n, 0);
                break;
            }
            case BUTTON: {
                this.renderButton(trans3, n, 0);
                break;
            }
            case LAMP: {
                this.renderLamp(trans3, n, 0);
                break;
            }
            case BLANK: {
                this.renderCover(trans3);
            }
        }
    }

    void setup(ControlPanelMaterial controlPanelMaterial) {
        if (controlPanelMaterial != null) {
            this.setup(controlPanelMaterial.block, controlPanelMaterial.metadata);
        } else {
            this.setup(Blocks.field_150344_f, 0);
        }
    }

    void setup(Block block, int n) {
        this.renderingInInventory = false;
        this.part = null;
        this.world = null;
        this.block = block;
        this.metadata = n;
        this.blockX = 0;
        this.blockY = 0;
        this.blockZ = 0;
        this.setUpTextureOverride(null);
        this.blockBrightness = 0xF000F0;
        this.setColorMultiplier(0xFFFFFF);
        this.alpha = 1.0f;
        this.tess = Tessellator.field_78398_a;
    }

    void renderInWorld(ControlPanelPart controlPanelPart, double d, double d2, double d3, Phase phase) {
        this.renderingInInventory = false;
        this.part = controlPanelPart;
        this.phase = phase;
        this.world = controlPanelPart.world();
        this.block = controlPanelPart.base.block;
        this.metadata = controlPanelPart.base.metadata;
        this.blockX = controlPanelPart.x();
        this.blockY = controlPanelPart.y();
        this.blockZ = controlPanelPart.z();
        this.setUpTextureOverride(null);
        this.blockBrightness = this.block.func_149677_c(this.world, this.blockX, this.blockY, this.blockZ);
        this.setColorMultiplier(this.block.func_149720_d(this.world, this.blockX, this.blockY, this.blockZ));
        this.alpha = 1.0f;
        this.tess = Tessellator.field_78398_a;
        this.tess.func_78386_a(1.0f, 1.0f, 1.0f);
        Trans3 trans3 = controlPanelPart.localToGlobalTransformation(d, d2, d3);
        this.renderPart(trans3);
    }

    void renderPart(Trans3 trans3) {
        this.renderPanel(trans3);
        this.renderLabels(trans3);
        this.renderControls(trans3);
    }

    void renderPanel(Trans3 trans3) {
        switch (this.phase) {
            case STATIC: {
                this.pbtBox(trans3, panelBox);
                this.renderBackCutouts(trans3);
            }
        }
    }

    void renderLabels(Trans3 trans3) {
        if (this.part != null) {
            switch (this.phase) {
                case DYNAMIC: {
                    FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
                    GL11.glPushAttrib((int)262208);
                    GL11.glPushMatrix();
                    Trans3GL.glMultTrans3(trans3);
                    GL11.glRotatef((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                    GL11.glRotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                    GL11.glTranslated((double)-0.5, (double)-0.5, (double)-0.0645);
                    GL11.glScaled((double)0.00625, (double)0.00625, (double)1.0);
                    for (int i = 0; i < 4; ++i) {
                        for (int j = 0; j < 4; ++j) {
                            for (int k = 0; k < 2; ++k) {
                                String string = this.part.labels[4 * i + j][k];
                                if (string == null) continue;
                                int n = fontRenderer.func_78256_a(string) / 2;
                                fontRenderer.func_78276_b(string, j * 40 + 20 - n, 1 + i * 40 + k * 30, 0);
                            }
                        }
                    }
                    GL11.glPopMatrix();
                    GL11.glPopAttrib();
                }
            }
        }
    }

    void renderControls(Trans3 trans3) {
        this.selectSide(trans3, 0);
        this.lightVertex(trans3, 0.0, 0.0, 0.0);
        for (int i = 0; i < 4; ++i) {
            block7: for (int j = 0; j < 4; ++j) {
                Trans3 trans32 = trans3.translate(0.375 - (double)j * 0.25, -0.0625, -0.375 + (double)i * 0.25);
                int n = 4 * i + j;
                if (this.part == null) {
                    this.renderFrontCutout(trans32);
                    continue;
                }
                int n2 = this.part.getControlMeta(n);
                int n3 = this.part.getControlState(n);
                switch (this.part.getControlType(n)) {
                    case NONE: {
                        this.renderFrontCutout(trans32);
                        continue block7;
                    }
                    case LEVER: {
                        this.renderLever(trans32, n2, n3);
                        continue block7;
                    }
                    case BUTTON: {
                        this.renderButton(trans32, n2, n3);
                        continue block7;
                    }
                    case LAMP: {
                        this.renderLamp(trans32, n2, n3);
                    }
                }
            }
        }
    }

    void renderBackCutouts(Trans3 trans3) {
        this.selectSideAndTile(trans3, 1, backCutoutIcon);
        this.lightVertex(trans3, 0.0, 0.0625, 0.0);
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                this.face(trans3, -0.5 + (double)i * 0.25, 0.0725, -0.5 + (double)j * 0.25, 0.0, 0.0, 0.25, 0.25, 0.0, 0.0, 0.0, 0.0, 1.0, 1.0);
            }
        }
    }

    void renderFrontCutout(Trans3 trans3) {
        switch (this.phase) {
            case STATIC: {
                this.selectSideAndTile(trans3, 0, this.renderingInInventory ? backCutoutIcon : frontCutoutIcon);
                this.lightVertex(trans3, 0.0, -0.0625, 0.0);
                this.face(trans3, -0.125, -0.01, 0.125, 0.0, 0.0, -0.25, 0.25, 0.0, 0.0, 0.0, 0.0, 1.0, 1.0);
            }
        }
    }

    void renderLever(Trans3 trans3, int n, int n2) {
        switch (this.phase) {
            case STATIC: {
                IIcon iIcon = n == 16 ? Blocks.field_150347_e.func_149691_a(0, 0) : Blocks.field_150325_L.func_149691_a(0, n & 0xF);
                leverBaseModel.tessellate(trans3, iIcon);
                break;
            }
            case DYNAMIC: {
                Trans3 trans32 = trans3.translate(0.0, -0.0625, 0.0).rotate(leverRotations[n2]);
                GL11.glColor3d((double)1.0, (double)1.0, (double)1.0);
                leverHandleModel.draw(trans32, Blocks.field_150442_at.func_149691_a(0, 0));
            }
        }
    }

    void renderButton(Trans3 trans3, int n, int n2) {
        switch (this.phase) {
            case DYNAMIC: {
                IIcon iIcon = n == 16 ? Blocks.field_150348_b.func_149691_a(0, 0) : (n == 17 ? Blocks.field_150344_f.func_149691_a(0, 0) : Blocks.field_150325_L.func_149691_a(0, n & 0xF));
                Trans3 trans32 = trans3.translate(0.0, 0.03125 * (double)n2, 0.0);
                GL11.glColor3d((double)1.0, (double)1.0, (double)1.0);
                buttonModel.draw(trans32, iIcon);
            }
        }
    }

    void renderLamp(Trans3 trans3, int n, int n2) {
        switch (this.phase) {
            case DYNAMIC: {
                GL11.glPushAttrib((int)64);
                this.setLightingDisabled(n2 != 0);
                double d = 0.25 + (double)n2 * 0.75;
                double[] dArray = colors[n & 0xF];
                GL11.glColor3d((double)(d * dArray[0]), (double)(d * dArray[1]), (double)(d * dArray[2]));
                lampModel.draw(trans3, lampIcon);
                this.setLightingDisabled(false);
                GL11.glPopAttrib();
            }
        }
    }

    void renderCover(Trans3 trans3) {
        switch (this.phase) {
            case DYNAMIC: {
                GL11.glColor3d((double)1.0, (double)1.0, (double)1.0);
                coverModel.draw(trans3, this.block.func_149691_a(0, 0));
            }
        }
    }

    void pbtBox(Trans3 trans3, AxisAlignedBB axisAlignedBB) {
        this.pbtBox(trans3, axisAlignedBB.field_72340_a, axisAlignedBB.field_72338_b, axisAlignedBB.field_72339_c, axisAlignedBB.field_72336_d - axisAlignedBB.field_72340_a, axisAlignedBB.field_72337_e - axisAlignedBB.field_72338_b, axisAlignedBB.field_72334_f - axisAlignedBB.field_72339_c);
    }

    void pbtBox(Trans3 trans3, double d, double d2, double d3, double d4, double d5, double d6) {
        double d7 = d + d4;
        double d8 = d2 + d5;
        double d9 = d3 + d6;
        this.pbtBoxFace(trans3, 0, d, d2, d9, 0.0, 0.0, -d6, d4, 0.0, 0.0);
        this.pbtBoxFace(trans3, 1, d, d8, d3, 0.0, 0.0, d6, d4, 0.0, 0.0);
        this.pbtBoxFace(trans3, 2, d7, d8, d3, 0.0, -d5, 0.0, -d4, 0.0, 0.0);
        this.pbtBoxFace(trans3, 3, d, d8, d9, 0.0, -d5, 0.0, d4, 0.0, 0.0);
        this.pbtBoxFace(trans3, 4, d, d8, d3, 0.0, -d5, 0.0, 0.0, 0.0, d6);
        this.pbtBoxFace(trans3, 5, d7, d8, d9, 0.0, -d5, 0.0, 0.0, 0.0, -d6);
    }

    void pbtBoxFace(Trans3 trans3, int n, double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9) {
        this.selectSideAndTile(trans3, n, this.block.func_149691_a(n, this.metadata));
        this.ptRect(trans3, d, d2, d3, d4, d5, d6, d7, d8, d9);
    }

    void ptRect(Trans3 trans3, double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9) {
        this.lightVertex(trans3, d + 0.5 * (d4 + d7), d2 + 0.5 * (d5 + d8), d3 + 0.5 * (d6 + d9));
        this.ptVertex(trans3, d, d2, d3);
        this.ptVertex(trans3, d + d4, d2 + d5, d3 + d6);
        this.ptVertex(trans3, d + d4 + d7, d2 + d5 + d8, d3 + d6 + d9);
        this.ptVertex(trans3, d + d7, d2 + d8, d3 + d9);
    }

    void ptVertex(Trans3 trans3, double d, double d2, double d3) {
        Vector3 vector3 = trans3.p(d, d2, d3);
        double d4 = 0.0;
        double d5 = 0.0;
        switch (this.globalSide) {
            case 0: 
            case 1: {
                d4 = vector3.x - (double)this.blockX;
                d5 = vector3.z - (double)this.blockZ;
                break;
            }
            case 2: 
            case 3: {
                d4 = vector3.x - (double)this.blockX;
                d5 = -vector3.y + (double)this.blockY + 1.0;
                break;
            }
            case 4: 
            case 5: {
                d4 = vector3.z - (double)this.blockZ;
                d5 = -vector3.y + (double)this.blockY + 1.0;
            }
        }
        this.tess.func_78374_a(vector3.x, vector3.y, vector3.z, this.u0 + d4 * this.us, this.v0 + d5 * this.vs);
    }

    void selectSideAndTile(Trans3 trans3, int n, IIcon iIcon) {
        this.selectSide(trans3, n);
        this.selectTile(iIcon, 1.0, 1.0);
    }

    void selectSide(Trans3 trans3, int n) {
        ForgeDirection forgeDirection = ForgeDirection.getOrientation((int)n);
        ForgeDirection forgeDirection2 = trans3.t(forgeDirection);
        this.globalSide = forgeDirection2.ordinal();
        this.tess.func_78375_b((float)forgeDirection2.offsetX, (float)forgeDirection2.offsetY, (float)forgeDirection2.offsetZ);
    }

    void lightVertex(Trans3 trans3, double d, double d2, double d3) {
        if (this.world != null) {
            Vector3 vector3 = trans3.p(d, d2, d3);
            ForgeDirection forgeDirection = ForgeDirection.getOrientation((int)this.globalSide);
            int n = this.block.func_149677_c(this.world, (int)Math.floor(vector3.x + 0.01 * (double)forgeDirection.offsetX), (int)Math.floor(vector3.y + 0.01 * (double)forgeDirection.offsetY), (int)Math.floor(vector3.z + 0.01 * (double)forgeDirection.offsetZ));
            this.tess.func_78380_c(n);
            float f = sideShading[this.globalSide];
            this.tess.func_78369_a(f * this.cmr, f * this.cmg, f * this.cmb, this.alpha);
        } else {
            this.tess.func_78386_a(1.0f, 1.0f, 1.0f);
            this.tess.func_78380_c(this.blockBrightness);
        }
    }

    public void setLightingDisabled(boolean bl) {
        OpenGlHelper.func_77473_a((int)OpenGlHelper.field_77476_b);
        if (bl) {
            GL11.glDisable((int)2896);
            if (!this.renderingInInventory) {
                GL11.glDisable((int)3553);
            }
        } else {
            GL11.glEnable((int)2896);
            if (!this.renderingInInventory) {
                GL11.glEnable((int)3553);
            }
        }
        OpenGlHelper.func_77473_a((int)OpenGlHelper.field_77478_a);
    }

    public static enum Phase {
        STATIC,
        DYNAMIC,
        BREAKING;

    }
}

