/*
 * Decompiled with CFR 0.152.
 */
package gcewing.projectblue;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import codechicken.lib.vec.BlockCoord;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Rotation;
import codechicken.lib.vec.Transformation;
import codechicken.lib.vec.Vector3;
import codechicken.multipart.MultiPartRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gcewing.projectblue.BaseModClient;
import gcewing.projectblue.IPBRenderer;
import gcewing.projectblue.ItemMultiPartJ;
import gcewing.projectblue.ItemRendererBase;
import gcewing.projectblue.JCuboidFacePart;
import gcewing.projectblue.PBDynamicRenderer;
import gcewing.projectblue.PBStaticRenderer;
import gcewing.projectblue.Trans3;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class PBFacePart
extends JCuboidFacePart {
    public String type;
    public int side;
    public int rot;

    public static Cuboid6[] newBounds(double d, double d2, double d3, double d4, double d5, double d6) {
        Cuboid6[] cuboid6Array = new Cuboid6[6];
        for (int i = 0; i < 6; ++i) {
            Transformation transformation = Rotation.sideRotations[i].at(Vector3.center);
            cuboid6Array[i] = new Cuboid6(d, d2, d3, d4, d5, d6).apply(transformation);
        }
        return cuboid6Array;
    }

    protected PBFacePart() {
    }

    public String getType() {
        return this.type;
    }

    public Cuboid6 getBounds() {
        return this.getBoundsArray()[this.side];
    }

    public abstract Cuboid6[] getBoundsArray();

    public int getSlotMask() {
        return 1 << this.side;
    }

    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister iIconRegister) {
    }

    public boolean renderStatic(Vector3 vector3, int n) {
        return this.renderStatic(this.transformation(vector3.x, vector3.y, vector3.z), n, new PBStaticRenderer(this));
    }

    public void renderDynamic(Vector3 vector3, float f, int n) {
        this.renderDynamic(this.transformation(vector3.x, vector3.y, vector3.z), f, n, new PBDynamicRenderer());
    }

    public Trans3 transformation(double d, double d2, double d3) {
        return new Trans3(d + 0.5, d2 + 0.5, d3 + 0.5).side(this.side);
    }

    public void renderStack(ItemStack itemStack, IItemRenderer.ItemRenderType itemRenderType) {
        this.renderStack(this.transformation(0.0, 0.0, 0.0), itemStack, itemRenderType, new PBDynamicRenderer());
    }

    public boolean renderStatic(Trans3 trans3, int n, IPBRenderer iPBRenderer) {
        return false;
    }

    public void renderDynamic(Trans3 trans3, float f, int n, IPBRenderer iPBRenderer) {
    }

    public void renderStack(Trans3 trans3, ItemStack itemStack, IItemRenderer.ItemRenderType itemRenderType, IPBRenderer iPBRenderer) {
        this.renderStatic(trans3, 0, iPBRenderer);
    }

    public void writeDesc(MCDataOutput mCDataOutput) {
        mCDataOutput.writeByte(this.side);
        mCDataOutput.writeByte(this.rot);
    }

    public void readDesc(MCDataInput mCDataInput) {
        this.side = mCDataInput.readByte();
        this.rot = mCDataInput.readByte();
    }

    public void save(NBTTagCompound nBTTagCompound) {
        nBTTagCompound.func_74768_a("side", this.side);
        nBTTagCompound.func_74768_a("rot", this.rot);
    }

    public void load(NBTTagCompound nBTTagCompound) {
        this.side = nBTTagCompound.func_74762_e("side");
        this.rot = nBTTagCompound.func_74762_e("rot");
    }

    public TileEntity getAdjacentTileEntity() {
        ForgeDirection forgeDirection = ForgeDirection.getOrientation((int)this.side);
        return this.world().func_147438_o(this.x() + forgeDirection.offsetX, this.y() + forgeDirection.offsetY, this.z() + forgeDirection.offsetZ);
    }

    public void markDirty() {
        this.tile().func_70296_d();
    }

    public void changed() {
        this.markDirty();
        this.sendDescUpdate();
    }

    public static class ItemRenderer
    extends ItemRendererBase {
        FaceItem item;

        public ItemRenderer(FaceItem faceItem) {
            this.item = faceItem;
        }

        @Override
        void renderStack(ItemStack itemStack, IItemRenderer.ItemRenderType itemRenderType) {
            this.item.proxy.renderStack(itemStack, itemRenderType);
        }
    }

    public static class FaceItem
    extends ItemMultiPartJ {
        static List<FaceItem> instances = new ArrayList<FaceItem>();
        Factory factory;
        PBFacePart proxy;

        public FaceItem(Factory factory) {
            this.factory = factory;
            this.proxy = factory.createPart(0, 0);
            instances.add(this);
        }

        public static void registerRenderers(BaseModClient baseModClient) {
            for (FaceItem faceItem : instances) {
                baseModClient.addItemRenderer(faceItem, (IItemRenderer)new ItemRenderer(faceItem));
            }
        }

        public int func_94901_k() {
            return 0;
        }

        @SideOnly(value=Side.CLIENT)
        public void func_94581_a(IIconRegister iIconRegister) {
            this.proxy.registerIcons(iIconRegister);
        }

        @Override
        public PBFacePart newPart(ItemStack itemStack, EntityPlayer entityPlayer, World world, BlockCoord blockCoord, int n, Vector3 vector3) {
            int n2 = n ^ 1;
            int n3 = Trans3.turnFor((Entity)entityPlayer, n2);
            return this.factory.createPart(n2, n3);
        }
    }

    public static class Factory
    implements MultiPartRegistry.IPartFactory {
        String type;
        Class<? extends PBFacePart> cls;

        public Factory(Class<? extends PBFacePart> clazz, String string) {
            this.type = string;
            this.cls = clazz;
        }

        public PBFacePart createPart(String string, boolean bl) {
            return this.createPart(0, 0);
        }

        public PBFacePart createPart(int n, int n2) {
            try {
                PBFacePart pBFacePart = this.cls.newInstance();
                pBFacePart.type = this.type;
                pBFacePart.side = n;
                pBFacePart.rot = n2;
                return pBFacePart;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
    }
}

