/*
 * Decompiled with CFR 0.152.
 */
package gcewing.projectblue;

import gcewing.projectblue.IPBRenderer;
import gcewing.projectblue.Vector3;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;

public class PBTexture {
    public ResourceLocation location;
    public IIcon icon;
    public double red = 1.0;
    public double green = 1.0;
    public double blue = 1.0;
    public boolean isEmissive = false;

    public PBTexture(PBTexture pBTexture) {
        this(pBTexture.icon);
        this.location = pBTexture.location;
    }

    public PBTexture(IIcon iIcon) {
        this.icon = iIcon;
    }

    public PBTexture tinted(int n) {
        return this.tinted((double)(n >> 16 & 0xFF) / 255.0, (double)(n >> 8 & 0xFF) / 255.0, (double)(n & 0xFF) / 255.0);
    }

    public PBTexture tinted(double d, double d2, double d3) {
        PBTexture pBTexture = new PBTexture(this);
        pBTexture.red = d;
        pBTexture.green = d2;
        pBTexture.blue = d3;
        return pBTexture;
    }

    public PBTexture emissive(int n) {
        return this.emissive((double)(n >> 16 & 0xFF) / 255.0, (double)(n >> 8 & 0xFF) / 255.0, (double)(n & 0xFF) / 255.0);
    }

    public PBTexture emissive(double d, double d2, double d3) {
        PBTexture pBTexture = this.tinted(d, d2, d3);
        pBTexture.isEmissive = true;
        return pBTexture;
    }

    public void activate(IPBRenderer iPBRenderer) {
        if (this.location != null) {
            iPBRenderer.bindTexture(this.location);
        }
        iPBRenderer.setColor(this.red, this.green, this.blue);
        iPBRenderer.setEmissive(this.isEmissive);
    }

    public void renderVertex(IPBRenderer iPBRenderer, int n, Vector3 vector3, Vector3 vector32, double d, double d2) {
        iPBRenderer.renderVertex(n, vector3, vector32, this.interpolateU(d), this.interpolateV(d2));
    }

    double interpolateU(double d) {
        double d2 = this.icon.func_94209_e();
        double d3 = this.icon.func_94212_f();
        return d2 + d * (d3 - d2);
    }

    double interpolateV(double d) {
        double d2 = this.icon.func_94206_g();
        double d3 = this.icon.func_94210_h();
        return d2 + d * (d3 - d2);
    }
}

