/*
 * Decompiled with CFR 0.152.
 */
package gcewing.projectblue;

import cpw.mods.fml.common.registry.GameRegistry;
import gcewing.projectblue.BaseMod;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BaseContainerBlock<TE extends TileEntity>
extends BlockContainer
implements BaseMod.IBlock {
    static Random random = new Random();
    public int renderID = 0;
    Class<? extends TileEntity> tileEntityClass = null;
    protected String[] iconNames = null;
    protected IIcon[] icons;

    public BaseContainerBlock(Material material) {
        this(material, null);
    }

    public BaseContainerBlock(Material material, Class<TE> teClass) {
        super(material);
        this.tileEntityClass = teClass;
        if (teClass != null) {
            try {
                GameRegistry.registerTileEntity(teClass, (String)teClass.getName());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    public static IIcon getIcon(Block block, IIconRegister reg, String name) {
        if (name.indexOf(":") < 0) {
            String assetKey = block.getClass().getPackage().getName().replace(".", "_");
            name = assetKey + ":" + name;
        }
        return reg.func_94245_a(name);
    }

    protected IIcon getIcon(IIconRegister reg, String name) {
        return BaseContainerBlock.getIcon((Block)this, reg, name);
    }

    public static IIcon[] getIcons(Block block, IIconRegister reg, String ... names) {
        IIcon[] result = new IIcon[names.length];
        for (int i = 0; i < names.length; ++i) {
            result[i] = BaseContainerBlock.getIcon(block, reg, names[i]);
        }
        return result;
    }

    protected IIcon[] getIcons(IIconRegister reg, String ... names) {
        return BaseContainerBlock.getIcons((Block)this, reg, names);
    }

    public void func_149651_a(IIconRegister reg) {
        if (this.iconNames != null) {
            this.icons = this.getIcons(reg, this.iconNames);
        } else {
            super.func_149651_a(reg);
            this.icons = new IIcon[]{this.field_149761_L};
        }
    }

    public void setIconNames(String ... names) {
        this.iconNames = names;
    }

    public void setPrefixedIconNames(String prefix, String ... suffixes) {
        String[] names = new String[suffixes.length];
        for (int i = 0; i < names.length; ++i) {
            names[i] = prefix + "-" + suffixes[i];
        }
        this.setIconNames(names);
    }

    public int func_149645_b() {
        return this.renderID;
    }

    @Override
    public void setRenderType(int id) {
        this.renderID = id;
    }

    @Override
    public String getQualifiedRendererClassName() {
        String name = this.getRendererClassName();
        if (name != null) {
            name = this.getClass().getPackage().getName() + "." + name;
        }
        return name;
    }

    protected String getRendererClassName() {
        return null;
    }

    public boolean func_149686_d() {
        return this.renderID == 0;
    }

    public IIcon func_149691_a(int side, int data) {
        return this.getLocalIcon(side, data);
    }

    IIcon getLocalIcon(int side, int data) {
        if (this.icons != null) {
            if (side < this.icons.length) {
                return this.icons[side];
            }
            return this.icons[this.icons.length - 1];
        }
        return null;
    }

    public boolean hasTileEntity(int metadata) {
        return this.tileEntityClass != null;
    }

    public TE getTileEntity(IBlockAccess world, int x, int y, int z) {
        if (this.func_149716_u()) {
            return (TE)world.func_147438_o(x, y, z);
        }
        return null;
    }

    public TileEntity func_149915_a(World world, int metadata) {
        if (this.tileEntityClass != null) {
            try {
                return this.tileEntityClass.newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    public void func_149726_b(World world, int x, int y, int z) {
        super.func_149726_b(world, x, y, z);
        TE te = this.getTileEntity((IBlockAccess)world, x, y, z);
        if (te instanceof BaseMod.ITileEntity) {
            ((BaseMod.ITileEntity)te).onAddedToWorld();
        }
    }

    public void func_149749_a(World world, int x, int y, int z, Block par5, int par6) {
        IInventory var7;
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof IInventory && (var7 = (IInventory)te) != null) {
            for (int var8 = 0; var8 < var7.func_70302_i_(); ++var8) {
                ItemStack var9 = var7.func_70301_a(var8);
                if (var9 == null) continue;
                this.scatterNearby(world, x, y, z, var9);
            }
        }
        super.func_149749_a(world, x, y, z, par5, par6);
    }

    public void scatterNearby(World world, int x, int y, int z, ItemStack stack) {
        float var10 = random.nextFloat() * 0.8f + 0.1f;
        float var11 = random.nextFloat() * 0.8f + 0.1f;
        float var12 = random.nextFloat() * 0.8f + 0.1f;
        while (stack.field_77994_a > 0) {
            int var13 = random.nextInt(21) + 10;
            if (var13 > stack.field_77994_a) {
                var13 = stack.field_77994_a;
            }
            stack.field_77994_a -= var13;
            EntityItem var14 = new EntityItem(world, (double)((float)x + var10), (double)((float)y + var11), (double)((float)z + var12), new ItemStack(stack.func_77973_b(), var13, stack.func_77960_j()));
            float var15 = 0.05f;
            var14.field_70159_w = (float)random.nextGaussian() * var15;
            var14.field_70181_x = (float)random.nextGaussian() * var15 + 0.2f;
            var14.field_70179_y = (float)random.nextGaussian() * var15;
            if (stack.func_77942_o()) {
                var14.func_92059_d().func_77982_d((NBTTagCompound)stack.func_77978_p().func_74737_b());
            }
            world.func_72838_d((Entity)var14);
        }
    }
}

