/*
 * Decompiled with CFR 0.152.
 */
package rwg.biomes.realistic.coast;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import rwg.api.RWGBiomes;
import rwg.biomes.realistic.RealisticBiomeBase;
import rwg.deco.DecoBlob;
import rwg.deco.DecoFlowers;
import rwg.deco.DecoGrass;
import rwg.deco.DecoLog;
import rwg.util.CellNoise;
import rwg.util.CliffCalculator;
import rwg.util.PerlinNoise;

public class RealisticBiomeCoastColdSlope
extends RealisticBiomeBase {
    public RealisticBiomeCoastColdSlope() {
        super(0, RWGBiomes.baseColdPlains);
    }

    @Override
    public void rDecorate(World world, Random rand, int chunkX, int chunkY, PerlinNoise perlin, CellNoise cell, float strength, float river) {
        int z22;
        int x22;
        int y22;
        int l = 0;
        while ((float)l < 2.0f * strength) {
            int j1;
            int i1 = chunkX + rand.nextInt(16) + 8;
            int k1 = world.func_72976_f(i1, j1 = chunkY + rand.nextInt(16) + 8);
            if (k1 < 68 || rand.nextInt(4) == 0) {
                new DecoBlob(Blocks.field_150347_e, 0).func_76484_a(world, rand, i1, k1, j1);
            }
            ++l;
        }
        if (rand.nextInt((int)(4.0f / strength)) == 0 && (y22 = world.func_72976_f(x22 = chunkX + rand.nextInt(16) + 8, z22 = chunkY + rand.nextInt(16) + 8)) < 70) {
            new DecoLog(1, 3 + rand.nextInt(4), false).func_76484_a(world, rand, x22, y22, z22);
        }
        int f23 = 0;
        while ((float)f23 < 1.0f * strength) {
            int j15 = chunkX + rand.nextInt(16) + 8;
            int j17 = 64 + rand.nextInt(64);
            int j20 = chunkY + rand.nextInt(16) + 8;
            new DecoFlowers(new int[]{9, 0, 3}).func_76484_a(world, rand, j15, j17, j20);
            ++f23;
        }
        int l14 = 0;
        while ((float)l14 < 3.0f * strength) {
            int l19 = chunkX + rand.nextInt(16) + 8;
            int k22 = 64 + rand.nextInt(64);
            int j24 = chunkY + rand.nextInt(16) + 8;
            new DecoGrass((Block)Blocks.field_150329_H, 1).func_76484_a(world, rand, l19, k22, j24);
            ++l14;
        }
    }

    @Override
    public float rNoise(PerlinNoise perlin, CellNoise cell, int x, int y, float ocean, float border, float river) {
        river = river > 0.5f ? 1.0f : river * 2.0f;
        float start = perlin.noise2((float)x / 90.0f, (float)y / 90.0f) * 1.0f + perlin.noise2((float)x / 40.0f, (float)y / 40.0f) * 0.15f + perlin.noise2((float)x / 9.0f, (float)y / 9.0f) * 0.07f;
        float h = 0.0f;
        h = ocean < 1.0f ? ocean * 15.0f : 15.0f;
        float c = 0.0f;
        if (ocean + start > 0.8f) {
            c = ocean + start > 1.5f ? 0.7f : ocean + start - 0.8f;
            c *= 35.0f + perlin.noise2((float)x / 50.0f, (float)y / 50.0f) * 8.0f;
        }
        if (ocean < 1.6f) {
            float st = (1.2f - ocean) * 20.0f;
            st = st > 1.0f ? 1.0f : st;
            h += perlin.noise2((float)x / 12.0f, (float)y / 12.0f);
            h += perlin.noise2((float)x / 20.0f, (float)y / 20.0f) * 2.0f;
        }
        return 55.0f + h + c * river;
    }

    @Override
    public void rReplace(Block[] blocks, byte[] metadata, int i, int j, int x, int y, int depth, World world, Random rand, PerlinNoise perlin, CellNoise cell, float[] noise, float river, BiomeGenBase[] base) {
        float c = CliffCalculator.calc(x, y, noise);
        boolean cliff = c > 0.5f;
        boolean gravel = false;
        for (int k = 255; k > -1; --k) {
            Block b = blocks[(y * 16 + x) * 256 + k];
            if (b == Blocks.field_150350_a) {
                depth = -1;
                continue;
            }
            if (b != Blocks.field_150348_b) continue;
            ++depth;
            if (cliff) {
                if (depth > -1 && depth < 2) {
                    blocks[(y * 16 + x) * 256 + k] = rand.nextInt(3) == 0 ? Blocks.field_150347_e : Blocks.field_150348_b;
                    continue;
                }
                if (depth >= 10) continue;
                blocks[(y * 16 + x) * 256 + k] = Blocks.field_150348_b;
                continue;
            }
            if (depth == 0) {
                if (k > 64) {
                    blocks[(y * 16 + x) * 256 + k] = Blocks.field_150349_c;
                    continue;
                }
                blocks[(y * 16 + x) * 256 + k] = Blocks.field_150351_n;
                gravel = true;
                continue;
            }
            if (depth >= 4) continue;
            blocks[(y * 16 + x) * 256 + k] = gravel ? Blocks.field_150351_n : Blocks.field_150346_d;
        }
    }
}

