/*
 * Decompiled with CFR 0.152.
 */
package rwg.biomes.realistic.coast;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import rwg.api.RWGBiomes;
import rwg.biomes.realistic.RealisticBiomeBase;
import rwg.deco.DecoBlob;
import rwg.deco.DecoWaterGrass;
import rwg.deco.trees.DecoMangrove;
import rwg.util.CellNoise;
import rwg.util.CliffCalculator;
import rwg.util.PerlinNoise;

public class RealisticBiomeCoastMangrove
extends RealisticBiomeBase {
    public RealisticBiomeCoastMangrove() {
        super(0, RWGBiomes.baseOceanOasis);
    }

    @Override
    public void rDecorate(World world, Random rand, int chunkX, int chunkY, PerlinNoise perlin, CellNoise cell, float strength, float river) {
        int l = 0;
        while ((float)l < 2.0f * strength) {
            int j1;
            int i1 = chunkX + rand.nextInt(16) + 8;
            int k1 = world.func_72976_f(i1, j1 = chunkY + rand.nextInt(16) + 8);
            if (k1 < 68) {
                new DecoBlob(Blocks.field_150347_e, 0).func_76484_a(world, rand, i1, k1, j1);
            }
            ++l;
        }
        int a = 0;
        while ((float)a < 5.0f * strength) {
            int j6 = chunkX + rand.nextInt(16) + 8;
            int k10 = chunkY + rand.nextInt(16) + 8;
            int z52 = world.func_72976_f(j6, k10);
            DecoMangrove worldgenerator = new DecoMangrove(Blocks.field_150364_r, 0, (Block)Blocks.field_150362_t, 0, 1 + rand.nextInt(4), 4 + rand.nextInt(2), 5.0f, 2, 0.32f, 0.14f);
            worldgenerator.func_76487_a(1.0, 1.0, 1.0);
            worldgenerator.func_76484_a(world, rand, j6, z52, k10);
            ++a;
        }
        int l14 = 0;
        while ((float)l14 < 9.0f * strength) {
            int l19 = chunkX + rand.nextInt(16) + 8;
            int k22 = 64 + rand.nextInt(64);
            int j24 = chunkY + rand.nextInt(16) + 8;
            new DecoWaterGrass((Block)Blocks.field_150398_cm, 2).func_76484_a(world, rand, l19, k22, j24);
            ++l14;
        }
    }

    @Override
    public float rNoise(PerlinNoise perlin, CellNoise cell, int x, int y, float ocean, float border, float river) {
        float h;
        river = river > 0.5f ? 1.0f : river * 2.0f;
        float f = h = ocean < 0.5f ? ocean * 14.0f : 7.0f;
        if (ocean < 1.9f) {
            float st = (1.9f - ocean) * 20.0f;
            st = st > 1.0f ? 1.0f : st;
            h += perlin.noise2((float)x / 12.0f, (float)y / 12.0f) * 1.5f;
            h += perlin.noise2((float)x / 20.0f, (float)y / 20.0f) * 3.0f;
        }
        return 55.0f + h;
    }

    @Override
    public void rReplace(Block[] blocks, byte[] metadata, int i, int j, int x, int y, int depth, World world, Random rand, PerlinNoise perlin, CellNoise cell, float[] noise, float river, BiomeGenBase[] base) {
        float c = CliffCalculator.calc(x, y, noise);
        boolean cliff = c > 1.3f;
        boolean sand = false;
        for (int k = 255; k > -1; --k) {
            Block b = blocks[(y * 16 + x) * 256 + k];
            if (b == Blocks.field_150350_a) {
                depth = -1;
                continue;
            }
            if (b != Blocks.field_150348_b) continue;
            ++depth;
            if (cliff) {
                if (depth > -1 && depth < 2) {
                    blocks[(y * 16 + x) * 256 + k] = rand.nextInt(3) == 0 ? Blocks.field_150347_e : Blocks.field_150348_b;
                    continue;
                }
                if (depth >= 10) continue;
                blocks[(y * 16 + x) * 256 + k] = Blocks.field_150348_b;
                continue;
            }
            if (depth == 0) {
                if (k > 67) {
                    blocks[(y * 16 + x) * 256 + k] = Blocks.field_150349_c;
                    continue;
                }
                blocks[(y * 16 + x) * 256 + k] = Blocks.field_150354_m;
                sand = true;
                continue;
            }
            if (depth >= 5) continue;
            if (sand) {
                if (depth < 4) {
                    blocks[(y * 16 + x) * 256 + k] = Blocks.field_150354_m;
                    continue;
                }
                blocks[(y * 16 + x) * 256 + k] = Blocks.field_150322_A;
                continue;
            }
            blocks[(y * 16 + x) * 256 + k] = Blocks.field_150346_d;
        }
    }
}

