/*
 * Decompiled with CFR 0.152.
 */
package rwg.surface;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import rwg.api.RWGBiomes;
import rwg.surface.SurfaceBase;
import rwg.util.CellNoise;
import rwg.util.PerlinNoise;

public class SurfaceDuneValley
extends SurfaceBase {
    private float valley;
    private boolean dirt;
    private boolean mix;

    public SurfaceDuneValley(Block top, Block fill, float valleySize, boolean d, boolean m) {
        super(top, fill);
        this.valley = valleySize;
        this.dirt = d;
        this.mix = m;
    }

    @Override
    public void paintTerrain(Block[] blocks, byte[] metadata, int i, int j, int x, int y, int depth, World world, Random rand, PerlinNoise perlin, CellNoise cell, float[] noise, float river, BiomeGenBase[] base) {
        float h = (perlin.noise2((float)i / this.valley, (float)j / this.valley) + 0.25f) * 65.0f;
        h = h < 1.0f ? 1.0f : h;
        float m = perlin.noise2((float)i / 12.0f, (float)j / 12.0f);
        boolean sand = false;
        for (int k = 255; k > -1; --k) {
            Block b = blocks[(y * 16 + x) * 256 + k];
            if (b == Blocks.field_150350_a) {
                depth = -1;
                continue;
            }
            if (b != Blocks.field_150348_b) continue;
            if (++depth == 0) {
                if ((float)k > 90.0f + perlin.noise2((float)i / 24.0f, (float)j / 24.0f) * 10.0f - h || m < -0.28f && this.mix) {
                    blocks[(y * 16 + x) * 256 + k] = Blocks.field_150354_m;
                    base[x * 16 + y] = RWGBiomes.baseHotDesert;
                    sand = true;
                    continue;
                }
                if (this.dirt && m < 0.22f || k < 62) {
                    blocks[(y * 16 + x) * 256 + k] = Blocks.field_150346_d;
                    metadata[(y * 16 + x) * 256 + k] = 1;
                    continue;
                }
                blocks[(y * 16 + x) * 256 + k] = this.topBlock;
                continue;
            }
            if (depth >= 6) continue;
            if (sand) {
                if (depth < 4) {
                    blocks[(y * 16 + x) * 256 + k] = Blocks.field_150354_m;
                    continue;
                }
                blocks[(y * 16 + x) * 256 + k] = Blocks.field_150322_A;
                continue;
            }
            blocks[(y * 16 + x) * 256 + k] = this.fillerBlock;
        }
    }
}

