/*
 * Decompiled with CFR 0.152.
 */
package rwg.world;

import cpw.mods.fml.common.eventhandler.Event;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFalling;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.init.Blocks;
import net.minecraft.util.IProgressUpdate;
import net.minecraft.util.MathHelper;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.SpawnerAnimals;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.MapGenBase;
import net.minecraft.world.gen.MapGenCaves;
import net.minecraft.world.gen.feature.WorldGenDungeons;
import net.minecraft.world.gen.feature.WorldGenFlowers;
import net.minecraft.world.gen.feature.WorldGenLakes;
import net.minecraft.world.gen.feature.WorldGenLiquids;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraft.world.gen.structure.MapGenMineshaft;
import net.minecraft.world.gen.structure.MapGenStronghold;
import net.minecraft.world.gen.structure.MapGenVillage;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.terraingen.ChunkProviderEvent;
import net.minecraftforge.event.terraingen.DecorateBiomeEvent;
import net.minecraftforge.event.terraingen.InitMapGenEvent;
import net.minecraftforge.event.terraingen.OreGenEvent;
import net.minecraftforge.event.terraingen.PopulateChunkEvent;
import net.minecraftforge.event.terraingen.TerrainGen;
import rwg.biomes.realistic.RealisticBiomeBase;
import rwg.config.ConfigRWG;
import rwg.deco.DecoClay;
import rwg.util.CanyonColor;
import rwg.util.CellNoise;
import rwg.util.PerlinNoise;
import rwg.world.ChunkManagerRealistic;

public class ChunkGeneratorRealistic
implements IChunkProvider {
    private Random rand;
    private Random mapRand;
    private World worldObj;
    private ChunkManagerRealistic cmr;
    private final MapGenBase caves;
    private final MapGenStronghold strongholdGenerator;
    private final MapGenMineshaft mineshaftGenerator;
    private final MapGenVillage villageGenerator;
    private PerlinNoise perlin;
    private CellNoise cell;
    private RealisticBiomeBase[] biomesForGeneration;
    private BiomeGenBase[] baseBiomesList;
    private final int sampleSize = 8;
    private final int sampleArraySize;
    private final int parabolicSize;
    private final int parabolicArraySize;
    private final float[] parabolicField;
    private float parabolicFieldTotal;
    private int[] biomeData;
    private float[][] hugeRender;
    private float[][] smallRender;
    private float[] testHeight;
    private float[] mapGenBiomes;
    private float[] borderNoise;
    private long worldSeed;
    private WorldGenMinable ore_dirt = new WorldGenMinable(Blocks.field_150346_d, 32);
    private WorldGenMinable ore_gravel = new WorldGenMinable(Blocks.field_150351_n, 32);
    private WorldGenMinable ore_coal = new WorldGenMinable(Blocks.field_150365_q, 16);
    private WorldGenMinable ore_iron = new WorldGenMinable(Blocks.field_150366_p, 8);
    private WorldGenMinable ore_gold = new WorldGenMinable(Blocks.field_150352_o, 8);
    private WorldGenMinable ore_redstone = new WorldGenMinable(Blocks.field_150450_ax, 7);
    private WorldGenMinable ore_diamond = new WorldGenMinable(Blocks.field_150482_ag, 7);
    private WorldGenMinable ore_lapis = new WorldGenMinable(Blocks.field_150369_x, 6);

    public ChunkGeneratorRealistic(World world, long l) {
        this.caves = TerrainGen.getModdedMapGen((MapGenBase)new MapGenCaves(), (InitMapGenEvent.EventType)InitMapGenEvent.EventType.CAVE);
        this.worldObj = world;
        this.cmr = (ChunkManagerRealistic)this.worldObj.func_72959_q();
        this.rand = new Random(l);
        this.perlin = new PerlinNoise(l);
        this.cell = new CellNoise(l, 0);
        this.cell.setUseDistance(true);
        this.mapRand = new Random(l);
        this.worldSeed = l;
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("size", "0");
        m.put("distance", "24");
        this.villageGenerator = (MapGenVillage)TerrainGen.getModdedMapGen((MapGenBase)new MapGenVillage(m), (InitMapGenEvent.EventType)InitMapGenEvent.EventType.VILLAGE);
        this.strongholdGenerator = (MapGenStronghold)TerrainGen.getModdedMapGen((MapGenBase)new MapGenStronghold(), (InitMapGenEvent.EventType)InitMapGenEvent.EventType.STRONGHOLD);
        this.mineshaftGenerator = (MapGenMineshaft)TerrainGen.getModdedMapGen((MapGenBase)new MapGenMineshaft(), (InitMapGenEvent.EventType)InitMapGenEvent.EventType.MINESHAFT);
        CanyonColor.init(l);
        this.sampleArraySize = 21;
        this.parabolicSize = 8;
        this.parabolicArraySize = this.parabolicSize * 2 + 1;
        this.parabolicField = new float[this.parabolicArraySize * this.parabolicArraySize];
        for (int j = -this.parabolicSize; j <= this.parabolicSize; ++j) {
            for (int k = -this.parabolicSize; k <= this.parabolicSize; ++k) {
                float f;
                this.parabolicField[j + this.parabolicSize + (k + this.parabolicSize) * this.parabolicArraySize] = f = 0.445f / MathHelper.func_76129_c((float)((float)(j * 1 * (j * 1) + k * 1 * (k * 1)) + 0.3f));
                this.parabolicFieldTotal += f;
            }
        }
        this.baseBiomesList = new BiomeGenBase[256];
        this.biomeData = new int[this.sampleArraySize * this.sampleArraySize];
        this.hugeRender = new float[81][256];
        this.smallRender = new float[625][256];
        this.testHeight = new float[256];
        this.mapGenBiomes = new float[258];
        this.borderNoise = new float[256];
    }

    public Chunk func_73154_d(int cx, int cy) {
        int k;
        this.rand.setSeed((long)cx * 341873128712L + (long)cy * 132897987541L);
        Block[] blocks = new Block[65536];
        byte[] metadata = new byte[65536];
        float[] noise = new float[256];
        this.biomesForGeneration = new RealisticBiomeBase[256];
        this.generateTerrain(this.cmr, cx, cy, blocks, metadata, this.biomesForGeneration, noise);
        for (k = 0; k < 256; ++k) {
            if (this.mapGenBiomes[k] > 0.0f) {
                RealisticBiomeBase.getBiome(k).generateMapGen(blocks, metadata, this.worldSeed, this.worldObj, this.cmr, this.mapRand, cx, cy, this.perlin, this.cell, noise);
                this.mapGenBiomes[k] = 0.0f;
            }
            this.baseBiomesList[k] = this.biomesForGeneration[k].baseBiome;
        }
        this.replaceBlocksForBiome(cx, cy, blocks, metadata, this.biomesForGeneration, this.baseBiomesList, noise);
        this.caves.func_151539_a((IChunkProvider)this, this.worldObj, cx, cy, blocks);
        this.mineshaftGenerator.func_151539_a((IChunkProvider)this, this.worldObj, cx, cy, blocks);
        this.strongholdGenerator.func_151539_a((IChunkProvider)this, this.worldObj, cx, cy, blocks);
        this.villageGenerator.func_151539_a((IChunkProvider)this, this.worldObj, cx, cy, blocks);
        long second = System.currentTimeMillis();
        Chunk chunk = new Chunk(this.worldObj, blocks, metadata, cx, cy);
        byte[] abyte1 = chunk.func_76605_m();
        for (k = 0; k < abyte1.length; ++k) {
            abyte1[k] = (byte)this.baseBiomesList[k].field_76756_M;
        }
        chunk.func_76603_b();
        return chunk;
    }

    public void generateTerrain(ChunkManagerRealistic cmr, int cx, int cy, Block[] blocks, byte[] metadata, RealisticBiomeBase[] biomes, float[] n) {
        float[] noise = this.getNewNoise(cmr, cx * 16, cy * 16, biomes);
        for (int i = 0; i < 16; ++i) {
            for (int j = 0; j < 16; ++j) {
                int h = (int)noise[j * 16 + i];
                for (int k = 0; k < 256; ++k) {
                    int p = (j * 16 + i) * 256 + k;
                    if (k > h) {
                        if (k < 63) {
                            blocks[p] = Blocks.field_150355_j;
                            continue;
                        }
                        blocks[p] = Blocks.field_150350_a;
                        continue;
                    }
                    blocks[p] = Blocks.field_150348_b;
                }
                n[j * 16 + i] = noise[j * 16 + i];
            }
        }
    }

    public float[] getNewNoise(ChunkManagerRealistic cmr, int x, int y, RealisticBiomeBase[] biomes) {
        int l;
        int k;
        int j;
        int i;
        for (i = -8; i < 13; ++i) {
            for (j = -8; j < 13; ++j) {
                this.biomeData[(i + 8) * this.sampleArraySize + (j + 8)] = cmr.getBiomeDataAt((int)(x + (i * 8 - 8)), (int)(y + (j * 8 - 8))).biomeID;
            }
        }
        for (i = -1; i < 4; ++i) {
            for (j = -1; j < 4; ++j) {
                this.hugeRender[(i * 2 + 2) * 9 + (j * 2 + 2)] = new float[256];
                for (k = -this.parabolicSize; k <= this.parabolicSize; ++k) {
                    for (l = -this.parabolicSize; l <= this.parabolicSize; ++l) {
                        float[] fArray = this.hugeRender[(i * 2 + 2) * 9 + (j * 2 + 2)];
                        int n = this.biomeData[(i + k + 8 + 1) * this.sampleArraySize + (j + l + 8 + 1)];
                        fArray[n] = fArray[n] + this.parabolicField[k + this.parabolicSize + (l + this.parabolicSize) * this.parabolicArraySize] / this.parabolicFieldTotal;
                    }
                }
            }
        }
        RealisticBiomeBase b = null;
        for (i = 0; i < 256; ++i) {
            if (!(this.hugeRender[40][i] > 0.95f)) continue;
            b = RealisticBiomeBase.getBiome(i);
        }
        for (i = 0; i < 4; ++i) {
            for (j = 0; j < 4; ++j) {
                this.hugeRender[(i * 2 + 1) * 9 + (j * 2 + 1)] = this.mix4(new float[][]{this.hugeRender[i * 2 * 9 + j * 2], this.hugeRender[(i * 2 + 2) * 9 + j * 2], this.hugeRender[i * 2 * 9 + (j * 2 + 2)], this.hugeRender[(i * 2 + 2) * 9 + (j * 2 + 2)]});
            }
        }
        for (i = 0; i < 7; ++i) {
            for (j = 0; j < 7; ++j) {
                this.smallRender[i * 4 * 25 + j * 4] = !(i % 2 == 0 && j % 2 == 0 || i % 2 != 0 && j % 2 != 0) ? this.mix4(new float[][]{this.hugeRender[i * 9 + (j + 1)], this.hugeRender[(i + 1) * 9 + j], this.hugeRender[(i + 1) * 9 + (j + 2)], this.hugeRender[(i + 2) * 9 + (j + 1)]}) : this.hugeRender[(i + 1) * 9 + (j + 1)];
            }
        }
        for (i = 0; i < 6; ++i) {
            for (j = 0; j < 6; ++j) {
                this.smallRender[(i * 4 + 2) * 25 + (j * 4 + 2)] = this.mix4(new float[][]{this.smallRender[i * 4 * 25 + j * 4], this.smallRender[(i * 4 + 4) * 25 + j * 4], this.smallRender[i * 4 * 25 + (j * 4 + 4)], this.smallRender[(i * 4 + 4) * 25 + (j * 4 + 4)]});
            }
        }
        for (i = 0; i < 11; ++i) {
            for (j = 0; j < 11; ++j) {
                if (i % 2 == 0 && j % 2 == 0 || i % 2 != 0 && j % 2 != 0) continue;
                this.smallRender[(i * 2 + 2) * 25 + (j * 2 + 2)] = this.mix4(new float[][]{this.smallRender[i * 2 * 25 + (j * 2 + 2)], this.smallRender[(i * 2 + 2) * 25 + j * 2], this.smallRender[(i * 2 + 2) * 25 + (j * 2 + 4)], this.smallRender[(i * 2 + 4) * 25 + (j * 2 + 2)]});
            }
        }
        for (i = 0; i < 9; ++i) {
            for (j = 0; j < 9; ++j) {
                this.smallRender[(i * 2 + 3) * 25 + (j * 2 + 3)] = this.mix4(new float[][]{this.smallRender[(i * 2 + 2) * 25 + (j * 2 + 2)], this.smallRender[(i * 2 + 4) * 25 + (j * 2 + 2)], this.smallRender[(i * 2 + 2) * 25 + (j * 2 + 4)], this.smallRender[(i * 2 + 4) * 25 + (j * 2 + 4)]});
            }
        }
        for (i = 0; i < 16; ++i) {
            for (j = 0; j < 16; ++j) {
                if (i % 2 == 0 && j % 2 == 0 || i % 2 != 0 && j % 2 != 0) continue;
                this.smallRender[(i + 4) * 25 + (j + 4)] = this.mix4(new float[][]{this.smallRender[(i + 3) * 25 + (j + 4)], this.smallRender[(i + 4) * 25 + (j + 3)], this.smallRender[(i + 4) * 25 + (j + 5)], this.smallRender[(i + 5) * 25 + (j + 4)]});
            }
        }
        boolean randBiome = true;
        float bCount = 0.0f;
        float bRand = 0.0f;
        if (b != null) {
            randBiome = false;
            for (i = 0; i < 256; ++i) {
                biomes[i] = b;
            }
        }
        for (i = 0; i < 16; ++i) {
            for (j = 0; j < 16; ++j) {
                if (randBiome) {
                    bCount = 0.0f;
                    bRand = 0.5f + this.perlin.noise2((float)(x + i) / 15.0f, (float)(y + j) / 15.0f);
                    bRand = bRand < 0.0f ? 0.0f : (bRand > 0.99999f ? 0.99999f : bRand);
                }
                float ocean = cmr.getOceanValue(x + i, y + j);
                l = (i + 4) * 25 + (j + 4);
                this.testHeight[i * 16 + j] = 0.0f;
                float river = cmr.getRiverStrength(x + i, y + j);
                if (l == 312) {
                    this.mapGenBiomes[256] = ocean;
                    this.mapGenBiomes[257] = river;
                }
                for (k = 0; k < 256; ++k) {
                    if (!(this.smallRender[l][k] > 0.0f)) continue;
                    if (randBiome && bCount <= 1.0f && (bCount += this.smallRender[l][k]) > bRand) {
                        biomes[j * 16 + i] = RealisticBiomeBase.getBiome(k);
                        bCount = 2.0f;
                    }
                    if (l == 312) {
                        this.mapGenBiomes[k] = this.smallRender[312][k];
                    }
                    int n = i * 16 + j;
                    this.testHeight[n] = this.testHeight[n] + cmr.calculateRiver(x + i, y + j, river, RealisticBiomeBase.getBiome(k).rNoise(this.perlin, this.cell, x + i, y + j, ocean, this.smallRender[l][k], river + 1.0f)) * this.smallRender[l][k];
                }
            }
        }
        return this.testHeight;
    }

    public float[] mix4(float[][] ingredients) {
        float[] result = new float[256];
        for (int i = 0; i < 256; ++i) {
            for (int j = 0; j < 4; ++j) {
                if (!(ingredients[j][i] > 0.0f)) continue;
                int n = i;
                result[n] = result[n] + ingredients[j][i] / 4.0f;
            }
        }
        return result;
    }

    public void replaceBlocksForBiome(int cx, int cy, Block[] blocks, byte[] metadata, RealisticBiomeBase[] biomes, BiomeGenBase[] base, float[] n) {
        ChunkProviderEvent.ReplaceBiomeBlocks event = new ChunkProviderEvent.ReplaceBiomeBlocks((IChunkProvider)this, cx, cy, blocks, metadata, base, this.worldObj);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (event.getResult() == Event.Result.DENY) {
            return;
        }
        for (int i = 0; i < 16; ++i) {
            for (int j = 0; j < 16; ++j) {
                RealisticBiomeBase biome = biomes[i * 16 + j];
                float river = -this.cmr.getRiverStrength(cx * 16 + j, cy * 16 + i);
                if (river > 0.05f && river + this.perlin.noise2((float)(cx * 16 + j) / 10.0f, (float)(cy * 16 + i) / 10.0f) * 0.15f > 0.8f) {
                    base[i * 16 + j] = biome.riverBiome;
                }
                int depth = -1;
                biome.rReplace(blocks, metadata, cx * 16 + j, cy * 16 + i, i, j, depth, this.worldObj, this.rand, this.perlin, this.cell, n, river, base);
                blocks[(j * 16 + i) * 256] = Blocks.field_150357_h;
                blocks[(j * 16 + i) * 256 + this.rand.nextInt((int)2)] = Blocks.field_150357_h;
                blocks[(j * 16 + i) * 256 + this.rand.nextInt((int)3)] = Blocks.field_150357_h;
                blocks[(j * 16 + i) * 256 + this.rand.nextInt((int)4)] = Blocks.field_150357_h;
                blocks[(j * 16 + i) * 256 + this.rand.nextInt((int)5)] = Blocks.field_150357_h;
            }
        }
    }

    public Chunk func_73158_c(int par1, int par2) {
        return this.func_73154_d(par1, par2);
    }

    private double[] func_4061_a(double[] ad, int i, int j, int k, int l, int i1, int j1) {
        return null;
    }

    public boolean func_73149_a(int par1, int par2) {
        return true;
    }

    public void func_73153_a(IChunkProvider ichunkprovider, int i, int j) {
        int l11;
        int i9;
        int l5;
        int j2;
        BlockFalling.field_149832_M = true;
        this.worldObj.field_72999_e = true;
        int x = i * 16;
        int y = j * 16;
        RealisticBiomeBase biome = this.cmr.getBiomeDataAt(x + 16, y + 16);
        this.rand.setSeed(this.worldObj.func_72905_C());
        long i1 = this.rand.nextLong() / 2L * 2L + 1L;
        long j1 = this.rand.nextLong() / 2L * 2L + 1L;
        this.rand.setSeed((long)i * i1 + (long)j * j1 ^ this.worldObj.func_72905_C());
        boolean flag = false;
        MinecraftForge.EVENT_BUS.post((Event)new PopulateChunkEvent.Pre(ichunkprovider, this.worldObj, this.rand, i, j, flag));
        this.mineshaftGenerator.func_75051_a(this.worldObj, this.rand, i, j);
        this.strongholdGenerator.func_75051_a(this.worldObj, this.rand, i, j);
        this.villageGenerator.func_75051_a(this.worldObj, this.rand, i, j);
        boolean gen = false;
        gen = TerrainGen.populate((IChunkProvider)this, (World)this.worldObj, (Random)this.rand, (int)i, (int)j, (boolean)flag, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.LAKE);
        if (gen && this.rand.nextInt(10) == 0) {
            int i2 = x + this.rand.nextInt(16) + 8;
            int l4 = this.rand.nextInt(50);
            int i8 = y + this.rand.nextInt(16) + 8;
            new WorldGenLakes(Blocks.field_150355_j).func_76484_a(this.worldObj, this.rand, i2, l4, i8);
        }
        if ((gen = TerrainGen.populate((IChunkProvider)this, (World)this.worldObj, (Random)this.rand, (int)i, (int)j, (boolean)flag, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.LAVA)) && this.rand.nextInt(18) == 0) {
            int j22 = x + this.rand.nextInt(16) + 8;
            int i5 = this.rand.nextInt(this.rand.nextInt(45) + 8);
            int j8 = y + this.rand.nextInt(16) + 8;
            if (i5 < 64 || this.rand.nextInt(10) == 0) {
                new WorldGenLakes(Blocks.field_150353_l).func_76484_a(this.worldObj, this.rand, j22, i5, j8);
            }
        }
        gen = TerrainGen.populate((IChunkProvider)this, (World)this.worldObj, (Random)this.rand, (int)i, (int)j, (boolean)flag, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.DUNGEON);
        for (int k1 = 0; k1 < 8 && gen; ++k1) {
            int j5 = x + this.rand.nextInt(16) + 8;
            int k8 = this.rand.nextInt(128);
            int j11 = y + this.rand.nextInt(16) + 8;
            new WorldGenDungeons().func_76484_a(this.worldObj, this.rand, j5, k8, j11);
        }
        MinecraftForge.ORE_GEN_BUS.post((Event)new OreGenEvent.Pre(this.worldObj, this.rand, x, y));
        float river = -this.cmr.getRiverStrength(x + 16, y + 16);
        if (river > 0.85f) {
            for (j2 = 0; j2 < 3; ++j2) {
                l5 = x + this.rand.nextInt(16);
                i9 = 53 + this.rand.nextInt(15);
                l11 = y + this.rand.nextInt(16);
                new DecoClay(Blocks.field_150435_aG, 0, 20).func_76484_a(this.worldObj, this.rand, l5, i9, l11);
            }
        }
        if (TerrainGen.generateOre((World)this.worldObj, (Random)this.rand, (WorldGenerator)this.ore_dirt, (int)x, (int)y, (OreGenEvent.GenerateMinable.EventType)OreGenEvent.GenerateMinable.EventType.DIRT)) {
            for (j2 = 0; j2 < 10; ++j2) {
                l5 = x + this.rand.nextInt(16);
                i9 = this.rand.nextInt(64);
                l11 = y + this.rand.nextInt(16);
                this.ore_dirt.func_76484_a(this.worldObj, this.rand, l5, i9, l11);
            }
        }
        if (TerrainGen.generateOre((World)this.worldObj, (Random)this.rand, (WorldGenerator)this.ore_gravel, (int)x, (int)y, (OreGenEvent.GenerateMinable.EventType)OreGenEvent.GenerateMinable.EventType.GRAVEL)) {
            for (int k2 = 0; k2 < 5; ++k2) {
                int i6 = x + this.rand.nextInt(16);
                int j9 = this.rand.nextInt(64);
                int i12 = y + this.rand.nextInt(16);
                this.ore_gravel.func_76484_a(this.worldObj, this.rand, i6, j9, i12);
            }
        }
        if (TerrainGen.generateOre((World)this.worldObj, (Random)this.rand, (WorldGenerator)this.ore_coal, (int)x, (int)y, (OreGenEvent.GenerateMinable.EventType)OreGenEvent.GenerateMinable.EventType.COAL)) {
            for (int i3 = 0; i3 < 20; ++i3) {
                int j6 = x + this.rand.nextInt(16);
                int k9 = this.rand.nextInt(128);
                int j12 = y + this.rand.nextInt(16);
                this.ore_coal.func_76484_a(this.worldObj, this.rand, j6, k9, j12);
            }
        }
        if (TerrainGen.generateOre((World)this.worldObj, (Random)this.rand, (WorldGenerator)this.ore_iron, (int)x, (int)y, (OreGenEvent.GenerateMinable.EventType)OreGenEvent.GenerateMinable.EventType.IRON)) {
            for (int j3 = 0; j3 < 20; ++j3) {
                int k6 = x + this.rand.nextInt(16);
                int l9 = this.rand.nextInt(64);
                int k12 = y + this.rand.nextInt(16);
                this.ore_iron.func_76484_a(this.worldObj, this.rand, k6, l9, k12);
            }
        }
        if (TerrainGen.generateOre((World)this.worldObj, (Random)this.rand, (WorldGenerator)this.ore_gold, (int)x, (int)y, (OreGenEvent.GenerateMinable.EventType)OreGenEvent.GenerateMinable.EventType.GOLD)) {
            for (int k3 = 0; k3 < 2; ++k3) {
                int l6 = x + this.rand.nextInt(16);
                int i10 = this.rand.nextInt(32);
                int l12 = y + this.rand.nextInt(16);
                this.ore_gold.func_76484_a(this.worldObj, this.rand, l6, i10, l12);
            }
        }
        if (TerrainGen.generateOre((World)this.worldObj, (Random)this.rand, (WorldGenerator)this.ore_redstone, (int)x, (int)y, (OreGenEvent.GenerateMinable.EventType)OreGenEvent.GenerateMinable.EventType.REDSTONE)) {
            for (int l3 = 0; l3 < 8; ++l3) {
                int i7 = x + this.rand.nextInt(16);
                int j10 = this.rand.nextInt(16);
                int i13 = y + this.rand.nextInt(16);
                this.ore_redstone.func_76484_a(this.worldObj, this.rand, i7, j10, i13);
            }
        }
        if (TerrainGen.generateOre((World)this.worldObj, (Random)this.rand, (WorldGenerator)this.ore_diamond, (int)x, (int)y, (OreGenEvent.GenerateMinable.EventType)OreGenEvent.GenerateMinable.EventType.DIAMOND)) {
            for (int i4 = 0; i4 < 1; ++i4) {
                int j7 = x + this.rand.nextInt(16);
                int k10 = this.rand.nextInt(16);
                int j13 = y + this.rand.nextInt(16);
                this.ore_diamond.func_76484_a(this.worldObj, this.rand, j7, k10, j13);
            }
        }
        if (TerrainGen.generateOre((World)this.worldObj, (Random)this.rand, (WorldGenerator)this.ore_lapis, (int)x, (int)y, (OreGenEvent.GenerateMinable.EventType)OreGenEvent.GenerateMinable.EventType.LAPIS)) {
            for (int j4 = 0; j4 < 1; ++j4) {
                int k7 = x + this.rand.nextInt(16);
                int l10 = this.rand.nextInt(16) + this.rand.nextInt(16);
                int k13 = y + this.rand.nextInt(16);
                this.ore_lapis.func_76484_a(this.worldObj, this.rand, k7, l10, k13);
            }
        }
        if (ConfigRWG.generateEmeralds) {
            for (int g12 = 0; g12 < 4; ++g12) {
                int p1;
                int m1;
                int n1 = x + this.rand.nextInt(16);
                if (!this.worldObj.func_147439_a(n1, m1 = this.rand.nextInt(28) + 4, p1 = y + this.rand.nextInt(16)).isReplaceableOreGen(this.worldObj, n1, m1, p1, Blocks.field_150348_b)) continue;
                this.worldObj.func_147465_d(n1, m1, p1, Blocks.field_150412_bA, 0, 2);
            }
        }
        MinecraftForge.ORE_GEN_BUS.post((Event)new OreGenEvent.Post(this.worldObj, this.rand, x, y));
        if (this.rand.nextInt(5) == 0) {
            int k15 = x + this.rand.nextInt(16) + 8;
            int k17 = this.rand.nextInt(64);
            int k20 = y + this.rand.nextInt(16) + 8;
            if (this.rand.nextBoolean()) {
                new WorldGenFlowers((Block)Blocks.field_150338_P).func_76484_a(this.worldObj, this.rand, k15, k17, k20);
            } else {
                new WorldGenFlowers((Block)Blocks.field_150337_Q).func_76484_a(this.worldObj, this.rand, k15, k17, k20);
            }
        }
        for (int bx = -4; bx <= 4; ++bx) {
            for (int by = -4; by <= 4; ++by) {
                int n = this.cmr.getBiomeDataAt((int)(x + 24 + bx * 16), (int)(y + 24 + by * 16)).biomeID;
                this.borderNoise[n] = this.borderNoise[n] + 0.01234569f;
            }
        }
        MinecraftForge.EVENT_BUS.post((Event)new DecorateBiomeEvent.Pre(this.worldObj, this.rand, x, y));
        TerrainGen.decorate((World)this.worldObj, (Random)this.rand, (int)x, (int)y, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.SAND);
        TerrainGen.decorate((World)this.worldObj, (Random)this.rand, (int)x, (int)y, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.CLAY);
        TerrainGen.decorate((World)this.worldObj, (Random)this.rand, (int)x, (int)y, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.SAND_PASS2);
        TerrainGen.decorate((World)this.worldObj, (Random)this.rand, (int)x, (int)y, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.TREE);
        TerrainGen.decorate((World)this.worldObj, (Random)this.rand, (int)x, (int)y, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.BIG_SHROOM);
        float snow = 0.0f;
        for (int bn = 0; bn < 256; ++bn) {
            if (!(this.borderNoise[bn] > 0.0f)) continue;
            if (this.borderNoise[bn] >= 1.0f) {
                this.borderNoise[bn] = 1.0f;
            }
            RealisticBiomeBase b = RealisticBiomeBase.getBiome(bn);
            b.rDecorate(this.worldObj, this.rand, x, y, this.perlin, this.cell, this.borderNoise[bn], river);
            snow = b.baseBiome.field_76750_F < 0.15f ? (snow -= 0.6f * this.borderNoise[bn]) : (snow += 0.6f * this.borderNoise[bn]);
            this.borderNoise[bn] = 0.0f;
        }
        TerrainGen.decorate((World)this.worldObj, (Random)this.rand, (int)x, (int)y, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.FLOWERS);
        TerrainGen.decorate((World)this.worldObj, (Random)this.rand, (int)x, (int)y, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.GRASS);
        TerrainGen.decorate((World)this.worldObj, (Random)this.rand, (int)x, (int)y, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.DEAD_BUSH);
        TerrainGen.decorate((World)this.worldObj, (Random)this.rand, (int)x, (int)y, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.LILYPAD);
        TerrainGen.decorate((World)this.worldObj, (Random)this.rand, (int)x, (int)y, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.SHROOM);
        TerrainGen.decorate((World)this.worldObj, (Random)this.rand, (int)x, (int)y, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.REED);
        TerrainGen.decorate((World)this.worldObj, (Random)this.rand, (int)x, (int)y, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.PUMPKIN);
        TerrainGen.decorate((World)this.worldObj, (Random)this.rand, (int)x, (int)y, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.CACTUS);
        TerrainGen.decorate((World)this.worldObj, (Random)this.rand, (int)x, (int)y, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.LAKE);
        MinecraftForge.EVENT_BUS.post((Event)new DecorateBiomeEvent.Post(this.worldObj, this.rand, x, y));
        for (int l18 = 0; l18 < 50; ++l18) {
            int l21 = x + this.rand.nextInt(16) + 8;
            int k23 = this.rand.nextInt(this.rand.nextInt(120) + 8);
            int l24 = y + this.rand.nextInt(16) + 8;
            new WorldGenLiquids((Block)Blocks.field_150358_i).func_76484_a(this.worldObj, this.rand, l21, k23, l24);
        }
        for (int i19 = 0; i19 < 20; ++i19) {
            int i22 = x + this.rand.nextInt(16) + 8;
            int l23 = this.rand.nextInt(this.rand.nextInt(this.rand.nextInt(112) + 8) + 8);
            int i25 = y + this.rand.nextInt(16) + 8;
            new WorldGenLiquids((Block)Blocks.field_150356_k).func_76484_a(this.worldObj, this.rand, i22, l23, i25);
        }
        if (TerrainGen.populate((IChunkProvider)this, (World)this.worldObj, (Random)this.rand, (int)i, (int)j, (boolean)flag, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.ANIMALS)) {
            SpawnerAnimals.func_77191_a((World)this.worldObj, (BiomeGenBase)this.worldObj.func_72807_a(x + 16, y + 16), (int)(x + 8), (int)(y + 8), (int)16, (int)16, (Random)this.rand);
        }
        MinecraftForge.EVENT_BUS.post((Event)new PopulateChunkEvent.Post(ichunkprovider, this.worldObj, this.rand, i, j, flag));
        TerrainGen.populate((IChunkProvider)this, (World)this.worldObj, (Random)this.rand, (int)i, (int)j, (boolean)flag, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.ICE);
        if (snow < 0.59f) {
            x += 8;
            y += 8;
            for (int sn1 = 0; sn1 < 16; ++sn1) {
                for (int sn2 = 0; sn2 < 16; ++sn2) {
                    float s = snow < -0.59f ? -1.0f : this.perlin.noise2((float)(sn1 + x) / 3.0f, (float)(sn2 + y) / 3.0f) + snow;
                    if (!(s < 0.0f)) continue;
                    int sn3 = this.worldObj.func_72874_g(x + sn1, y + sn2);
                    Block b1 = this.worldObj.func_147439_a(sn1 + x, sn3, sn2 + y);
                    Block b2 = this.worldObj.func_147439_a(sn1 + x, sn3 - 1, sn2 + y);
                    if (b2 == Blocks.field_150355_j || b2 == Blocks.field_150358_i) {
                        this.worldObj.func_147465_d(sn1 + x, sn3 - 1, sn2 + y, Blocks.field_150432_aD, 0, 2);
                    }
                    if (!Blocks.field_150431_aC.func_149742_c(this.worldObj, sn1 + x, sn3, sn2 + y) || b2 == Blocks.field_150432_aD || b2 == Blocks.field_150355_j || sn3 <= 62 || b1 == Blocks.field_150431_aC || b2 == Blocks.field_150403_cj) continue;
                    this.worldObj.func_147465_d(sn1 + x, sn3, sn2 + y, Blocks.field_150431_aC, 0, 2);
                }
            }
        }
        this.worldObj.field_72999_e = false;
        BlockFalling.field_149832_M = false;
    }

    public boolean func_73151_a(boolean par1, IProgressUpdate par2IProgressUpdate) {
        return true;
    }

    public boolean func_73156_b() {
        return false;
    }

    public boolean unload100OldestChunks() {
        return false;
    }

    public boolean func_73157_c() {
        return true;
    }

    public String func_73148_d() {
        return "RandomLevelSource";
    }

    public List func_73155_a(EnumCreatureType par1EnumCreatureType, int par2, int par3, int par4) {
        BiomeGenBase var5 = this.worldObj.func_72807_a(par2, par4);
        return var5 == null ? null : var5.func_76747_a(par1EnumCreatureType);
    }

    public ChunkPosition func_147416_a(World par1World, String par2Str, int par3, int par4, int par5) {
        return "Stronghold".equals(par2Str) && this.strongholdGenerator != null ? this.strongholdGenerator.func_151545_a(par1World, par3, par4, par5) : null;
    }

    public int func_73152_e() {
        return 0;
    }

    public void func_104112_b() {
    }

    public void func_82695_e(int par1, int par2) {
        this.strongholdGenerator.func_151539_a((IChunkProvider)this, this.worldObj, par1, par2, (Block[])null);
        this.mineshaftGenerator.func_151539_a((IChunkProvider)this, this.worldObj, par1, par2, (Block[])null);
        this.villageGenerator.func_151539_a((IChunkProvider)this, this.worldObj, par1, par2, (Block[])null);
    }
}

