/*
 * Decompiled with CFR 0.152.
 */
package rwg.world;

import gnu.trove.map.hash.TLongObjectHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeCache;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.biome.WorldChunkManager;
import rwg.biomes.realistic.RealisticBiomeBase;
import rwg.support.Support;
import rwg.util.CellNoise;
import rwg.util.PerlinNoise;

public class ChunkManagerRealistic
extends WorldChunkManager {
    private BiomeCache biomeCache;
    private List biomesToSpawnIn;
    private PerlinNoise perlin;
    private CellNoise cell;
    private CellNoise biomecell;
    private ArrayList<RealisticBiomeBase> biomes_snow;
    private ArrayList<RealisticBiomeBase> biomes_cold;
    private ArrayList<RealisticBiomeBase> biomes_hot;
    private ArrayList<RealisticBiomeBase> biomes_wet;
    private ArrayList<RealisticBiomeBase> biomes_small;
    private ArrayList<RealisticBiomeBase> biomes_test;
    private int biomes_snowLength;
    private int biomes_coldLength;
    private int biomes_hotLength;
    private int biomes_wetLength;
    private int biomes_smallLength;
    private int biomes_testLength;
    private boolean wetEnabled;
    private boolean smallEnabled;
    private float[] borderNoise;
    private TLongObjectHashMap<RealisticBiomeBase> biomeDataMap = new TLongObjectHashMap();

    protected ChunkManagerRealistic() {
        this.biomeCache = new BiomeCache((WorldChunkManager)this);
        this.biomesToSpawnIn = new ArrayList();
        this.borderNoise = new float[256];
    }

    public ChunkManagerRealistic(World par1World) {
        this();
        long seed = par1World.func_72905_C();
        this.perlin = new PerlinNoise(seed);
        this.cell = new CellNoise(seed, 0);
        this.cell.setUseDistance(true);
        this.biomecell = new CellNoise(seed, 0);
        this.biomes_snow = new ArrayList();
        this.biomes_cold = new ArrayList();
        this.biomes_hot = new ArrayList();
        this.biomes_wet = new ArrayList();
        this.biomes_small = new ArrayList();
        this.biomes_test = new ArrayList();
        this.biomes_snow.add(RealisticBiomeBase.polar);
        this.biomes_snow.add(RealisticBiomeBase.snowHills);
        this.biomes_snow.add(RealisticBiomeBase.snowRivers);
        this.biomes_snow.add(RealisticBiomeBase.snowLakes);
        this.biomes_snow.add(RealisticBiomeBase.redwoodSnow);
        this.biomes_cold.add(RealisticBiomeBase.tundraHills);
        this.biomes_cold.add(RealisticBiomeBase.tundraPlains);
        this.biomes_cold.add(RealisticBiomeBase.taigaHills);
        this.biomes_cold.add(RealisticBiomeBase.taigaPlains);
        this.biomes_cold.add(RealisticBiomeBase.redwood);
        this.biomes_cold.add(RealisticBiomeBase.darkRedwood);
        this.biomes_cold.add(RealisticBiomeBase.darkRedwoodPlains);
        this.biomes_cold.add(RealisticBiomeBase.woodhills);
        this.biomes_cold.add(RealisticBiomeBase.woodmountains);
        this.biomes_cold.add(RealisticBiomeBase.woodhills);
        this.biomes_cold.add(RealisticBiomeBase.woodmountains);
        this.biomes_hot.add(RealisticBiomeBase.duneValleyForest);
        this.biomes_hot.add(RealisticBiomeBase.savanna);
        this.biomes_hot.add(RealisticBiomeBase.savannaForest);
        this.biomes_hot.add(RealisticBiomeBase.savannaDunes);
        this.biomes_hot.add(RealisticBiomeBase.stoneMountains);
        this.biomes_hot.add(RealisticBiomeBase.stoneMountainsCactus);
        this.biomes_hot.add(RealisticBiomeBase.hotForest);
        this.biomes_hot.add(RealisticBiomeBase.hotRedwood);
        this.biomes_hot.add(RealisticBiomeBase.canyonForest);
        this.biomes_hot.add(RealisticBiomeBase.mesaPlains);
        this.biomes_hot.add(RealisticBiomeBase.desert);
        this.biomes_hot.add(RealisticBiomeBase.desertMountains);
        this.biomes_hot.add(RealisticBiomeBase.duneValley);
        this.biomes_hot.add(RealisticBiomeBase.oasis);
        this.biomes_hot.add(RealisticBiomeBase.redDesertMountains);
        this.biomes_hot.add(RealisticBiomeBase.redDesertOasis);
        this.biomes_hot.add(RealisticBiomeBase.canyon);
        this.biomes_hot.add(RealisticBiomeBase.mesa);
        this.biomes_snow.addAll(Support.biomes_snow);
        this.biomes_cold.addAll(Support.biomes_cold);
        this.biomes_hot.addAll(Support.biomes_hot);
        this.biomes_wet.addAll(Support.biomes_wet);
        this.biomes_small.addAll(Support.biomes_small);
        this.biomes_test.addAll(Support.biomes_test);
        this.biomes_snowLength = this.biomes_snow.size();
        this.biomes_coldLength = this.biomes_cold.size();
        this.biomes_hotLength = this.biomes_hot.size();
        this.biomes_wetLength = this.biomes_wet.size();
        this.biomes_smallLength = this.biomes_small.size();
        this.biomes_testLength = this.biomes_test.size();
        this.wetEnabled = false;
        if (this.biomes_wetLength > 0) {
            this.wetEnabled = true;
        }
        this.smallEnabled = false;
        if (this.biomes_smallLength > 1) {
            this.smallEnabled = true;
        }
    }

    public int[] getBiomesGens(int par1, int par2, int par3, int par4) {
        int[] d = new int[par3 * par4];
        for (int i = 0; i < par3; ++i) {
            for (int j = 0; j < par4; ++j) {
                d[j * par3 + i] = this.func_76935_a((int)(par1 + i), (int)(par2 + j)).field_76756_M;
            }
        }
        return d;
    }

    public RealisticBiomeBase[] getBiomesGensData(int par1, int par2, int par3, int par4) {
        RealisticBiomeBase[] data = new RealisticBiomeBase[par3 * par4];
        for (int i = 0; i < par3; ++i) {
            for (int j = 0; j < par4; ++j) {
                data[j * par3 + i] = this.getBiomeDataAt(par1 + i, par2 + j);
            }
        }
        return data;
    }

    public float getOceanValue(int x, int y) {
        float base = 0.0f;
        float sample1 = this.perlin.noise2((float)x / 1200.0f, (float)y / 1200.0f) + base;
        float sample2 = 0.0f;
        float sa = 0.0f;
        float highest = 0.0f;
        if (sample1 == 0.0f) {
            highest = 1.0f;
        }
        if (this.diff(sample1, sample2 = this.perlin.noise2(((float)x - 100.0f) / 1200.0f, (float)y / 1200.0f) + base, base)) {
            sa = sample1 * (1.0f / Math.abs(sample1 - sample2));
            highest = 1.0f - Math.abs(sa) > highest ? 1.0f - Math.abs(sa) : highest;
        } else {
            sample2 = this.perlin.noise2(((float)x + 100.0f) / 1200.0f, (float)y / 1200.0f) + base;
            if (this.diff(sample1, sample2, base)) {
                sa = sample1 * (1.0f / Math.abs(sample1 - sample2));
                highest = 1.0f - Math.abs(sa) > highest ? 1.0f - Math.abs(sa) : highest;
            }
        }
        sample2 = this.perlin.noise2((float)x / 1200.0f, ((float)y + 100.0f) / 1200.0f) + base;
        if (this.diff(sample1, sample2, base)) {
            sa = sample1 * (1.0f / Math.abs(sample1 - sample2));
            highest = 1.0f - Math.abs(sa) > highest ? 1.0f - Math.abs(sa) : highest;
        } else {
            sample2 = this.perlin.noise2((float)x / 1200.0f, ((float)y - 100.0f) / 1200.0f) + base;
            if (this.diff(sample1, sample2, base)) {
                sa = sample1 * (1.0f / Math.abs(sample1 - sample2));
                float f = highest = 1.0f - Math.abs(sa) > highest ? 1.0f - Math.abs(sa) : highest;
            }
        }
        if (sample1 > 0.0f) {
            highest = 2.0f - highest;
        }
        return highest;
    }

    public boolean diff(float sample1, float sample2, float base) {
        return sample1 < base && sample2 > base || sample1 > base && sample2 < base;
    }

    public BiomeGenBase func_76935_a(int par1, int par2) {
        return this.getBiomeDataAt((int)par1, (int)par2, (float)this.getOceanValue((int)par1, (int)par2)).baseBiome;
    }

    public RealisticBiomeBase getBiomeDataAt(int par1, int par2) {
        return this.getBiomeDataAt(par1, par2, this.getOceanValue(par1, par2));
    }

    public RealisticBiomeBase getBiomeDataAt(int par1, int par2, float ocean) {
        float s;
        long coords = ChunkCoordIntPair.func_77272_a((int)par1, (int)par2);
        if (this.biomeDataMap.containsKey(coords)) {
            return (RealisticBiomeBase)this.biomeDataMap.get(coords);
        }
        RealisticBiomeBase output = null;
        float b = this.biomecell.noise((double)((float)par1 + 4000.0f) / 1200.0, (double)par2 / 1200.0, 1.0) * 0.5f + 0.5f;
        b = b < 0.0f ? 0.0f : (b >= 0.9999999f ? 0.9999999f : b);
        float f = s = this.smallEnabled ? this.biomecell.noise((double)par1 / 140.0, (double)par2 / 140.0, 1.0) * 0.5f + 0.5f : 0.0f;
        if (this.smallEnabled && s > 0.975f) {
            float h = (s - 0.975f) * 40.0f;
            h = h < 0.0f ? 0.0f : (h >= 0.9999999f ? 0.9999999f : h);
            output = this.biomes_small.get((int)(h *= (float)this.biomes_smallLength));
        } else if (this.wetEnabled && b < 0.25f || !this.wetEnabled && b < 0.33f) {
            float h = this.biomecell.noise((double)par1 / 450.0, (double)par2 / 450.0, 1.0) * 0.5f + 0.5f;
            h = h < 0.0f ? 0.0f : (h >= 0.9999999f ? 0.9999999f : h);
            output = this.biomes_snow.get((int)(h *= (float)this.biomes_snowLength));
        } else if (this.wetEnabled && b < 0.5f || !this.wetEnabled && b < 0.66f) {
            float h = this.biomecell.noise((double)par1 / 450.0, (double)par2 / 450.0, 1.0) * 0.5f + 0.5f;
            h = h < 0.0f ? 0.0f : (h >= 0.9999999f ? 0.9999999f : h);
            output = this.biomes_cold.get((int)(h *= (float)this.biomes_coldLength));
        } else if (this.wetEnabled && b < 0.75f || !this.wetEnabled && b < 1.0f) {
            float h = this.biomecell.noise((double)par1 / 450.0, (double)par2 / 450.0, 1.0) * 0.5f + 0.5f;
            h = h < 0.0f ? 0.0f : (h >= 0.9999999f ? 0.9999999f : h);
            output = this.biomes_hot.get((int)(h *= (float)this.biomes_hotLength));
        } else if (this.wetEnabled) {
            float h = this.biomecell.noise((double)par1 / 450.0, (double)par2 / 450.0, 1.0) * 0.5f + 0.5f;
            h = h < 0.0f ? 0.0f : (h >= 0.9999999f ? 0.9999999f : h);
            output = this.biomes_wet.get((int)(h *= (float)this.biomes_wetLength));
        } else {
            float h = this.biomecell.noise((double)par1 / 450.0, (double)par2 / 450.0, 1.0) * 0.5f + 0.5f;
            h = h < 0.0f ? 0.0f : (h >= 0.9999999f ? 0.9999999f : h);
            output = this.biomes_hot.get((int)(h *= (float)this.biomes_hotLength));
        }
        if (this.biomeDataMap.size() > 4096) {
            this.biomeDataMap.clear();
        }
        this.biomeDataMap.put(coords, (Object)output);
        return output;
    }

    public float getNoiseAt(int x, int y) {
        float river = this.getRiverStrength(x, y) + 1.0f;
        if (river < 0.5f) {
            return 59.0f;
        }
        float ocean = this.getOceanValue(x, y);
        return this.getBiomeDataAt(x, y, ocean).rNoise(this.perlin, this.cell, x, y, ocean, 1.0f, river);
    }

    public float getNoiseWithRiverOceanAt(int x, int y, float river, float ocean) {
        return this.getBiomeDataAt(x, y, ocean).rNoise(this.perlin, this.cell, x, y, ocean, 1.0f, river);
    }

    public float calculateRiver(int x, int y, float st, float biomeHeight) {
        if (st < 0.0f && biomeHeight > 59.0f) {
            float pX = (float)x + this.perlin.noise1((float)y / 240.0f) * 220.0f;
            float pY = (float)y + this.perlin.noise1((float)x / 240.0f) * 220.0f;
            float r = this.cell.border((double)pX / 1250.0, (double)pY / 1250.0, 0.038461538461538464, 1.0f);
            return biomeHeight * (r + 1.0f) + (59.0f + this.perlin.noise2((float)x / 12.0f, (float)y / 12.0f) * 2.0f + this.perlin.noise2((float)x / 8.0f, (float)y / 8.0f) * 1.5f) * -r;
        }
        return biomeHeight;
    }

    public float getRiverStrength(int x, int y) {
        return this.cell.border((double)((float)x + this.perlin.noise1((float)y / 240.0f) * 220.0f) / 1250.0, (double)((float)y + this.perlin.noise1((float)x / 240.0f) * 220.0f) / 1250.0, 0.16666666666666666, 1.0f);
    }

    public boolean isBorderlessAt(int x, int y) {
        int by;
        int bx;
        for (bx = -2; bx <= 2; ++bx) {
            for (by = -2; by <= 2; ++by) {
                int n = this.getBiomeDataAt((int)(x + bx * 16), (int)(y + by * 16)).biomeID;
                this.borderNoise[n] = this.borderNoise[n] + 0.04f;
            }
        }
        by = 0;
        for (bx = 0; bx < 256; ++bx) {
            if (this.borderNoise[bx] > 0.98f) {
                by = 1;
            }
            this.borderNoise[bx] = 0.0f;
        }
        return by == 1;
    }

    public List func_76932_a() {
        return this.biomesToSpawnIn;
    }

    public float[] func_76936_a(float[] par1ArrayOfFloat, int par2, int par3, int par4, int par5) {
        if (par1ArrayOfFloat == null || par1ArrayOfFloat.length < par4 * par5) {
            par1ArrayOfFloat = new float[par4 * par5];
        }
        int[] var6 = this.getBiomesGens(par2, par3, par4, par5);
        for (int var7 = 0; var7 < par4 * par5; ++var7) {
            float var8 = (float)BiomeGenBase.func_150568_d((int)var6[var7]).func_76744_g() / 65536.0f;
            if (var8 > 1.0f) {
                var8 = 1.0f;
            }
            par1ArrayOfFloat[var7] = var8;
        }
        return par1ArrayOfFloat;
    }

    public float func_76939_a(float par1, int par2) {
        return par1;
    }

    public BiomeGenBase[] func_76937_a(BiomeGenBase[] par1ArrayOfBiomeGenBase, int par2, int par3, int par4, int par5) {
        if (par1ArrayOfBiomeGenBase == null || par1ArrayOfBiomeGenBase.length < par4 * par5) {
            par1ArrayOfBiomeGenBase = new BiomeGenBase[par4 * par5];
        }
        int[] var7 = this.getBiomesGens(par2, par3, par4, par5);
        for (int var8 = 0; var8 < par4 * par5; ++var8) {
            par1ArrayOfBiomeGenBase[var8] = BiomeGenBase.func_150568_d((int)var7[var8]);
        }
        return par1ArrayOfBiomeGenBase;
    }

    public BiomeGenBase[] func_76933_b(BiomeGenBase[] par1ArrayOfBiomeGenBase, int par2, int par3, int par4, int par5) {
        return this.func_76931_a(par1ArrayOfBiomeGenBase, par2, par3, par4, par5, true);
    }

    public BiomeGenBase[] func_76931_a(BiomeGenBase[] par1ArrayOfBiomeGenBase, int par2, int par3, int par4, int par5, boolean par6) {
        if (par1ArrayOfBiomeGenBase == null || par1ArrayOfBiomeGenBase.length < par4 * par5) {
            par1ArrayOfBiomeGenBase = new BiomeGenBase[par4 * par5];
        }
        int[] var7 = this.getBiomesGens(par2, par3, par4, par5);
        for (int var8 = 0; var8 < par4 * par5; ++var8) {
            par1ArrayOfBiomeGenBase[var8] = BiomeGenBase.func_150568_d((int)var7[var8]);
        }
        return par1ArrayOfBiomeGenBase;
    }

    public boolean func_76940_a(int x, int y, int par3, List par4List) {
        float centerNoise = this.getNoiseAt(x, y);
        if (centerNoise < 62.0f) {
            return false;
        }
        float lowestNoise = centerNoise;
        float highestNoise = centerNoise;
        for (int i = -2; i <= 2; ++i) {
            for (int j = -2; j <= 2; ++j) {
                if (i == 0 || j == 0) continue;
                float n = this.getNoiseAt(x + i * 16, y + j * 16);
                if (n < lowestNoise) {
                    lowestNoise = n;
                }
                if (!(n > highestNoise)) continue;
                highestNoise = n;
            }
        }
        return highestNoise - lowestNoise < 22.0f;
    }

    public ChunkPosition func_150795_a(int p_150795_1_, int p_150795_2_, int p_150795_3_, List p_150795_4_, Random p_150795_5_) {
        return null;
    }

    public void func_76938_b() {
        this.biomeCache.func_76838_a();
    }
}

