/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.machine.alpha;

import buildcraft.api.statements.IActionExternal;
import cofh.api.energy.EnergyStorage;
import cofh.api.energy.IEnergyHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import mods.railcraft.common.blocks.RailcraftBlocks;
import mods.railcraft.common.blocks.machine.IEnumMachine;
import mods.railcraft.common.blocks.machine.MultiBlockPattern;
import mods.railcraft.common.blocks.machine.TileMultiBlockInventory;
import mods.railcraft.common.blocks.machine.alpha.EnumMachineAlpha;
import mods.railcraft.common.core.RailcraftConfig;
import mods.railcraft.common.plugins.buildcraft.triggers.IHasWork;
import mods.railcraft.common.plugins.forge.WorldPlugin;
import mods.railcraft.common.util.inventory.InvTools;
import mods.railcraft.common.util.inventory.wrappers.InventoryMapper;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileRockCrusher
extends TileMultiBlockInventory
implements IEnergyHandler,
IHasWork,
ISidedInventory {
    public static final int SLOT_INPUT = 0;
    public static final int SLOT_OUTPUT = 9;
    private static final int PROCESS_TIME = 100;
    private static final int CRUSHING_POWER_COST_PER_TICK = 160;
    private static final int SUCKING_POWER_COST = 5000;
    private static final int KILLING_POWER_COST = 10000;
    private static final int MAX_RECEIVE = 5000;
    private static final int MAX_ENERGY = 16000;
    private static final int[] SLOTS_INPUT = InvTools.buildSlotArray(0, 9);
    private static final int[] SLOTS_OUTPUT = InvTools.buildSlotArray(9, 9);
    private static final List<MultiBlockPattern> patterns = new ArrayList<MultiBlockPattern>();
    private final IInventory invInput = new InventoryMapper(this, 0, 9);
    private final IInventory invOutput = new InventoryMapper(this, 9, 9, false);
    private final Set<IActionExternal> actions = new HashSet<IActionExternal>();
    private int processTime;
    private EnergyStorage energyStorage;
    private boolean isWorking = false;
    private boolean paused = false;

    public TileRockCrusher() {
        super(EnumMachineAlpha.ROCK_CRUSHER.getTag() + ".name", 18, patterns);
        if (RailcraftConfig.machinesRequirePower()) {
            this.energyStorage = new EnergyStorage(16000, 5000, 10000);
        }
    }

    public static void placeRockCrusher(World world, int x, int y, int z, int patternIndex, List<ItemStack> input, List<ItemStack> output) {
        MultiBlockPattern pattern = patterns.get(patternIndex);
        HashMap<Character, Integer> blockMapping = new HashMap<Character, Integer>();
        blockMapping.put(Character.valueOf('B'), EnumMachineAlpha.ROCK_CRUSHER.ordinal());
        blockMapping.put(Character.valueOf('D'), EnumMachineAlpha.ROCK_CRUSHER.ordinal());
        blockMapping.put(Character.valueOf('a'), EnumMachineAlpha.ROCK_CRUSHER.ordinal());
        blockMapping.put(Character.valueOf('b'), EnumMachineAlpha.ROCK_CRUSHER.ordinal());
        blockMapping.put(Character.valueOf('c'), EnumMachineAlpha.ROCK_CRUSHER.ordinal());
        blockMapping.put(Character.valueOf('d'), EnumMachineAlpha.ROCK_CRUSHER.ordinal());
        blockMapping.put(Character.valueOf('e'), EnumMachineAlpha.ROCK_CRUSHER.ordinal());
        blockMapping.put(Character.valueOf('f'), EnumMachineAlpha.ROCK_CRUSHER.ordinal());
        blockMapping.put(Character.valueOf('h'), EnumMachineAlpha.ROCK_CRUSHER.ordinal());
        TileEntity tile = pattern.placeStructure(world, x, y, z, RailcraftBlocks.getBlockMachineAlpha(), blockMapping);
        if (tile instanceof TileRockCrusher) {
            TileRockCrusher master = (TileRockCrusher)tile;
            for (int slot = 0; slot < 9; ++slot) {
                if (input != null && slot < input.size()) {
                    master.inv.func_70299_a(0 + slot, input.get(slot));
                }
                if (output == null || slot >= output.size()) continue;
                master.inv.func_70299_a(9 + slot, output.get(slot));
            }
        }
    }

    @Override
    public IEnumMachine getMachineType() {
        return EnumMachineAlpha.ROCK_CRUSHER;
    }

    @Override
    protected boolean isMapPositionValid(int x, int y, int z, char mapPos) {
        Block block = WorldPlugin.getBlock((IBlockAccess)this.field_145850_b, x, y, z);
        switch (mapPos) {
            case 'O': {
                if (block != this.func_145838_q() || this.field_145850_b.func_72805_g(x, y, z) != this.func_145832_p()) break;
                return false;
            }
            case 'B': 
            case 'D': 
            case 'a': 
            case 'b': 
            case 'c': 
            case 'd': 
            case 'e': 
            case 'f': 
            case 'g': 
            case 'h': {
                if (block == this.func_145838_q() && this.field_145850_b.func_72805_g(x, y, z) == this.func_145832_p()) break;
                return false;
            }
            case 'A': {
                if (this.field_145850_b.func_147437_c(x, y, z)) break;
                return false;
            }
        }
        return true;
    }

    private boolean useMasterEnergy(int amount, boolean doRemove) {
        TileRockCrusher mBlock = (TileRockCrusher)this.getMasterBlock();
        if (mBlock != null) {
            if (mBlock.energyStorage == null) {
                return true;
            }
            return mBlock.energyStorage.extractEnergy(amount, !doRemove) == amount;
        }
        return false;
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
    }

    @Override
    public boolean openGui(EntityPlayer player) {
        return false;
    }

    @Override
    public IIcon getIcon(int side) {
        if (this.isStructureValid()) {
            if (side > 1 && this.getPatternMarker() == 'D') {
                return this.getMachineType().getTexture(6);
            }
            if (side == 1) {
                char m = this.getPatternMarker();
                return this.getMachineType().getTexture(m - 97 + 7);
            }
        }
        if (side > 1) {
            return this.getMachineType().getTexture(0);
        }
        return this.getMachineType().getTexture(side);
    }

    @Override
    public void func_145841_b(NBTTagCompound data) {
        super.func_145841_b(data);
        data.func_74768_a("processTime", this.processTime);
        if (this.energyStorage != null) {
            this.energyStorage.writeToNBT(data);
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound data) {
        super.func_145839_a(data);
        this.processTime = data.func_74762_e("processTime");
        if (this.energyStorage != null) {
            this.energyStorage.readFromNBT(data);
        }
    }

    public int getProcessTime() {
        return -1;
    }

    public void setProcessTime(int processTime) {
    }

    public int getProgressScaled(int i) {
        return this.getProcessTime() * i / 100;
    }

    @Override
    public boolean hasWork() {
        return false;
    }

    private void processActions() {
        this.actions.clear();
    }

    @Override
    public void actionActivated(IActionExternal action) {
    }

    public int[] func_94128_d(int side) {
        if (side == ForgeDirection.UP.ordinal()) {
            return SLOTS_INPUT;
        }
        return SLOTS_OUTPUT;
    }

    public boolean func_102007_a(int slot, ItemStack stack, int side) {
        return false;
    }

    public boolean func_102008_b(int slot, ItemStack stack, int side) {
        return false;
    }

    @Override
    public boolean func_94041_b(int slot, ItemStack stack) {
        return false;
    }

    public EnergyStorage getEnergyStorage() {
        TileRockCrusher mBlock = (TileRockCrusher)this.getMasterBlock();
        if (mBlock != null && mBlock.energyStorage != null) {
            return mBlock.energyStorage;
        }
        return this.energyStorage;
    }

    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        return 0;
    }

    public int extractEnergy(ForgeDirection from, int maxExtract, boolean simulate) {
        return 0;
    }

    public int getEnergyStored(ForgeDirection from) {
        return 0;
    }

    public int getMaxEnergyStored(ForgeDirection from) {
        return 0;
    }

    public boolean canConnectEnergy(ForgeDirection from) {
        return false;
    }

    static {
        char[][][] map1 = new char[][][]{new char[][]{{'O', 'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O', 'O'}}, new char[][]{{'O', 'O', 'O', 'O', 'O'}, {'O', 'B', 'D', 'B', 'O'}, {'O', 'B', 'D', 'B', 'O'}, {'O', 'O', 'O', 'O', 'O'}}, new char[][]{{'O', 'O', 'O', 'O', 'O'}, {'O', 'a', 'd', 'f', 'O'}, {'O', 'c', 'e', 'h', 'O'}, {'O', 'O', 'O', 'O', 'O'}}, new char[][]{{'O', 'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O', 'O'}}};
        patterns.add(new MultiBlockPattern(map1));
        char[][][] map2 = new char[][][]{new char[][]{{'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O'}}, new char[][]{{'O', 'O', 'O', 'O'}, {'O', 'B', 'B', 'O'}, {'O', 'D', 'D', 'O'}, {'O', 'B', 'B', 'O'}, {'O', 'O', 'O', 'O'}}, new char[][]{{'O', 'O', 'O', 'O'}, {'O', 'a', 'f', 'O'}, {'O', 'b', 'g', 'O'}, {'O', 'c', 'h', 'O'}, {'O', 'O', 'O', 'O'}}, new char[][]{{'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O'}}};
        patterns.add(new MultiBlockPattern(map2));
    }
}

