/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.carts;

import com.mojang.authlib.GameProfile;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import mods.railcraft.api.core.items.IMinecartItem;
import mods.railcraft.common.carts.CartUtils;
import mods.railcraft.common.carts.EntityCartFiltered;
import mods.railcraft.common.carts.ICartType;
import mods.railcraft.common.core.RailcraftConfig;
import mods.railcraft.common.gui.tooltips.ToolTip;
import mods.railcraft.common.plugins.forge.LocalizationPlugin;
import mods.railcraft.common.util.misc.Game;
import mods.railcraft.common.util.misc.MiscTools;
import net.minecraft.block.BlockDispenser;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemMinecart;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.World;

public class ItemCart
extends ItemMinecart
implements IMinecartItem {
    private final ICartType type;
    private int rarity = 0;

    public ItemCart(ICartType cart) {
        super(0);
        this.field_77777_bU = RailcraftConfig.getMinecartStackSize();
        this.type = cart;
        this.func_77655_b(cart.getTag());
        this.func_77656_e(0);
        this.func_77627_a(true);
        BlockDispenser.field_149943_a.func_82595_a((Object)this, null);
    }

    public void func_94581_a(IIconRegister iconRegister) {
        this.field_77791_bV = iconRegister.func_94245_a("railcraft:" + MiscTools.cleanTag(this.func_77658_a()));
    }

    public ItemCart setRarity(int rarity) {
        this.rarity = rarity;
        return this;
    }

    @SideOnly(value=Side.CLIENT)
    public EnumRarity func_77613_e(ItemStack par1ItemStack) {
        return EnumRarity.values()[this.rarity];
    }

    public boolean func_77648_a(ItemStack stack, EntityPlayer player, World world, int i, int j, int k, int l, float par8, float par9, float par10) {
        if (Game.isNotHost(world)) {
            return false;
        }
        EntityMinecart placedCart = this.placeCart(player.func_146103_bH(), stack, world, i, j, k);
        if (placedCart != null) {
            --stack.field_77994_a;
            return true;
        }
        return false;
    }

    public ICartType getCartType() {
        return this.type;
    }

    @Override
    public boolean canBePlacedByNonPlayer(ItemStack cart) {
        return true;
    }

    @Override
    public EntityMinecart placeCart(GameProfile owner, ItemStack cartStack, World world, int x, int y, int z) {
        return CartUtils.placeCart(this.type, owner, cartStack, world, x, y, z);
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List info, boolean adv) {
        ItemStack filter;
        super.func_77624_a(stack, player, info, adv);
        ToolTip tip = ToolTip.buildToolTip(stack.func_77977_a() + ".tip", new String[0]);
        if (tip != null) {
            info.addAll(tip.convertToStrings());
        }
        if ((filter = EntityCartFiltered.getFilterFromCartItem(stack)) != null) {
            info.add(EnumChatFormatting.BLUE + LocalizationPlugin.translate("railcraft.gui.filter") + ": " + filter.func_82833_r());
        }
    }
}

