/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.aesthetics.brick;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import mods.railcraft.client.util.textures.TextureAtlasSheet;
import mods.railcraft.common.blocks.aesthetics.brick.BrickVariant;
import mods.railcraft.common.blocks.aesthetics.brick.EnumBrick;
import mods.railcraft.common.plugins.forge.CreativePlugin;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;

public class BlockBrick
extends Block {
    private final EnumBrick theme;
    private IIcon[] icons;

    public BlockBrick(EnumBrick theme) {
        super(Material.field_151576_e);
        this.theme = theme;
        this.func_149752_b(15.0f);
        this.func_149711_c(5.0f);
        this.func_149672_a(Block.field_149769_e);
        this.func_149647_a(CreativePlugin.RAILCRAFT_TAB);
        this.setHarvestLevel("pickaxe", 0);
    }

    public int func_149692_a(int meta) {
        return meta;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        this.icons = TextureAtlasSheet.unstitchIcons(iconRegister, "railcraft:brick." + this.theme.themeTag(), BrickVariant.VALUES.length);
    }

    public IIcon func_149691_a(int side, int meta) {
        if (meta >= this.icons.length) {
            meta = 0;
        }
        return this.icons[meta];
    }

    public void func_149666_a(Item item, CreativeTabs tab, List list) {
        for (BrickVariant variant : BrickVariant.VALUES) {
            list.add(this.theme.get(variant, 1));
        }
    }

    public boolean canBeReplacedByLeaves(IBlockAccess world, int x, int y, int z) {
        return false;
    }
}

