/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.aesthetics;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mods.railcraft.client.sounds.RailcraftSound;
import mods.railcraft.common.blocks.aesthetics.IDerivedBlock;
import mods.railcraft.common.blocks.aesthetics.brick.EnumBrick;
import mods.railcraft.common.blocks.aesthetics.cube.BlockCube;
import mods.railcraft.common.blocks.aesthetics.cube.EnumCube;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;

public enum EnumBlockMaterial implements IDerivedBlock
{
    SANDY_BRICK,
    INFERNAL_BRICK,
    CONCRETE,
    SNOW,
    ICE,
    PACKED_ICE,
    IRON,
    GOLD,
    DIAMOND,
    FROSTBOUND_BRICK,
    QUARRIED_BRICK,
    BLEACHEDBONE_BRICK,
    BLOODSTAINED_BRICK,
    ABYSSAL_BRICK,
    SANDY_FITTED,
    INFERNAL_FITTED,
    FROSTBOUND_FITTED,
    QUARRIED_FITTED,
    BLEACHEDBONE_FITTED,
    BLOODSTAINED_FITTED,
    ABYSSAL_FITTED,
    NETHER_FITTED,
    SANDY_BLOCK,
    INFERNAL_BLOCK,
    FROSTBOUND_BLOCK,
    QUARRIED_BLOCK,
    BLEACHEDBONE_BLOCK,
    BLOODSTAINED_BLOCK,
    ABYSSAL_BLOCK,
    NETHER_BLOCK,
    SANDY_COBBLE,
    INFERNAL_COBBLE,
    FROSTBOUND_COBBLE,
    QUARRIED_COBBLE,
    BLEACHEDBONE_COBBLE,
    BLOODSTAINED_COBBLE,
    ABYSSAL_COBBLE,
    NETHER_COBBLE,
    CREOSOTE,
    OBSIDIAN,
    COPPER,
    TIN,
    LEAD,
    STEEL;

    public static final EnumBlockMaterial[] VALUES;
    public static final Map<String, EnumBlockMaterial> NAMES;
    public static final List<EnumBlockMaterial> creativeList;
    private static boolean needsInit;
    private Block.SoundType sound;
    private Block source;
    private int sourceMeta = 0;
    private String oreTag = null;
    private String toolClass = "pickaxe";
    private int toolLevel = 0;

    public static void initialize() {
        if (!needsInit) {
            return;
        }
        needsInit = false;
        EnumBlockMaterial.INFERNAL_BRICK.source = EnumBrick.INFERNAL.getBlock();
        EnumBlockMaterial.SANDY_BRICK.source = EnumBrick.SANDY.getBlock();
        EnumBlockMaterial.FROSTBOUND_BRICK.source = EnumBrick.FROSTBOUND.getBlock();
        EnumBlockMaterial.QUARRIED_BRICK.source = EnumBrick.QUARRIED.getBlock();
        EnumBlockMaterial.BLEACHEDBONE_BRICK.source = EnumBrick.BLEACHEDBONE.getBlock();
        EnumBlockMaterial.BLOODSTAINED_BRICK.source = EnumBrick.BLOODSTAINED.getBlock();
        EnumBlockMaterial.ABYSSAL_BRICK.source = EnumBrick.ABYSSAL.getBlock();
        EnumBlockMaterial.SANDY_FITTED.source = EnumBrick.SANDY.getBlock();
        EnumBlockMaterial.SANDY_FITTED.sourceMeta = 1;
        EnumBlockMaterial.INFERNAL_FITTED.source = EnumBrick.INFERNAL.getBlock();
        EnumBlockMaterial.INFERNAL_FITTED.sourceMeta = 1;
        EnumBlockMaterial.FROSTBOUND_FITTED.source = EnumBrick.FROSTBOUND.getBlock();
        EnumBlockMaterial.FROSTBOUND_FITTED.sourceMeta = 1;
        EnumBlockMaterial.QUARRIED_FITTED.source = EnumBrick.QUARRIED.getBlock();
        EnumBlockMaterial.QUARRIED_FITTED.sourceMeta = 1;
        EnumBlockMaterial.BLEACHEDBONE_FITTED.source = EnumBrick.BLEACHEDBONE.getBlock();
        EnumBlockMaterial.BLEACHEDBONE_FITTED.sourceMeta = 1;
        EnumBlockMaterial.BLOODSTAINED_FITTED.source = EnumBrick.BLOODSTAINED.getBlock();
        EnumBlockMaterial.BLOODSTAINED_FITTED.sourceMeta = 1;
        EnumBlockMaterial.ABYSSAL_FITTED.source = EnumBrick.ABYSSAL.getBlock();
        EnumBlockMaterial.ABYSSAL_FITTED.sourceMeta = 1;
        EnumBlockMaterial.NETHER_FITTED.source = EnumBrick.NETHER.getBlock();
        EnumBlockMaterial.NETHER_FITTED.sourceMeta = 1;
        EnumBlockMaterial.SANDY_BLOCK.source = EnumBrick.SANDY.getBlock();
        EnumBlockMaterial.SANDY_BLOCK.sourceMeta = 2;
        EnumBlockMaterial.INFERNAL_BLOCK.source = EnumBrick.INFERNAL.getBlock();
        EnumBlockMaterial.INFERNAL_BLOCK.sourceMeta = 2;
        EnumBlockMaterial.FROSTBOUND_BLOCK.source = EnumBrick.FROSTBOUND.getBlock();
        EnumBlockMaterial.FROSTBOUND_BLOCK.sourceMeta = 2;
        EnumBlockMaterial.QUARRIED_BLOCK.source = EnumBrick.QUARRIED.getBlock();
        EnumBlockMaterial.QUARRIED_BLOCK.sourceMeta = 2;
        EnumBlockMaterial.BLEACHEDBONE_BLOCK.source = EnumBrick.BLEACHEDBONE.getBlock();
        EnumBlockMaterial.BLEACHEDBONE_BLOCK.sourceMeta = 2;
        EnumBlockMaterial.BLOODSTAINED_BLOCK.source = EnumBrick.BLOODSTAINED.getBlock();
        EnumBlockMaterial.BLOODSTAINED_BLOCK.sourceMeta = 2;
        EnumBlockMaterial.ABYSSAL_BLOCK.source = EnumBrick.ABYSSAL.getBlock();
        EnumBlockMaterial.ABYSSAL_BLOCK.sourceMeta = 2;
        EnumBlockMaterial.NETHER_BLOCK.source = EnumBrick.NETHER.getBlock();
        EnumBlockMaterial.NETHER_BLOCK.sourceMeta = 2;
        EnumBlockMaterial.SANDY_COBBLE.source = EnumBrick.SANDY.getBlock();
        EnumBlockMaterial.SANDY_COBBLE.sourceMeta = 5;
        EnumBlockMaterial.INFERNAL_COBBLE.source = EnumBrick.INFERNAL.getBlock();
        EnumBlockMaterial.INFERNAL_COBBLE.sourceMeta = 5;
        EnumBlockMaterial.FROSTBOUND_COBBLE.source = EnumBrick.FROSTBOUND.getBlock();
        EnumBlockMaterial.FROSTBOUND_COBBLE.sourceMeta = 5;
        EnumBlockMaterial.QUARRIED_COBBLE.source = EnumBrick.QUARRIED.getBlock();
        EnumBlockMaterial.QUARRIED_COBBLE.sourceMeta = 5;
        EnumBlockMaterial.BLEACHEDBONE_COBBLE.source = EnumBrick.BLEACHEDBONE.getBlock();
        EnumBlockMaterial.BLEACHEDBONE_COBBLE.sourceMeta = 5;
        EnumBlockMaterial.BLOODSTAINED_COBBLE.source = EnumBrick.BLOODSTAINED.getBlock();
        EnumBlockMaterial.BLOODSTAINED_COBBLE.sourceMeta = 5;
        EnumBlockMaterial.ABYSSAL_COBBLE.source = EnumBrick.ABYSSAL.getBlock();
        EnumBlockMaterial.ABYSSAL_COBBLE.sourceMeta = 5;
        EnumBlockMaterial.NETHER_COBBLE.source = EnumBrick.NETHER.getBlock();
        EnumBlockMaterial.NETHER_COBBLE.sourceMeta = 5;
        EnumBlockMaterial.CONCRETE.source = BlockCube.getBlock();
        EnumBlockMaterial.CONCRETE.sourceMeta = EnumCube.CONCRETE_BLOCK.ordinal();
        EnumBlockMaterial.CREOSOTE.source = BlockCube.getBlock();
        EnumBlockMaterial.CREOSOTE.sourceMeta = EnumCube.CREOSOTE_BLOCK.ordinal();
        EnumBlockMaterial.SNOW.source = Blocks.field_150433_aE;
        EnumBlockMaterial.SNOW.toolClass = "shovel";
        EnumBlockMaterial.ICE.source = Blocks.field_150432_aD;
        EnumBlockMaterial.PACKED_ICE.source = Blocks.field_150403_cj;
        EnumBlockMaterial.IRON.source = Blocks.field_150339_S;
        EnumBlockMaterial.GOLD.source = Blocks.field_150340_R;
        EnumBlockMaterial.DIAMOND.source = Blocks.field_150484_ah;
        EnumBlockMaterial.OBSIDIAN.source = Blocks.field_150343_Z;
        EnumBlockMaterial.COPPER.source = BlockCube.getBlock();
        EnumBlockMaterial.COPPER.sourceMeta = EnumCube.COPPER_BLOCK.ordinal();
        EnumBlockMaterial.COPPER.oreTag = "blockCopper";
        EnumBlockMaterial.TIN.source = BlockCube.getBlock();
        EnumBlockMaterial.TIN.sourceMeta = EnumCube.TIN_BLOCK.ordinal();
        EnumBlockMaterial.TIN.oreTag = "blockTin";
        EnumBlockMaterial.LEAD.source = BlockCube.getBlock();
        EnumBlockMaterial.LEAD.sourceMeta = EnumCube.LEAD_BLOCK.ordinal();
        EnumBlockMaterial.LEAD.oreTag = "blockLead";
        EnumBlockMaterial.STEEL.source = BlockCube.getBlock();
        EnumBlockMaterial.STEEL.sourceMeta = EnumCube.STEEL_BLOCK.ordinal();
        EnumBlockMaterial.STEEL.oreTag = "blockSteel";
        for (EnumBlockMaterial mat : VALUES) {
            NAMES.put(mat.name(), mat);
            switch (mat) {
                case CONCRETE: {
                    mat.sound = Block.field_149769_e;
                    break;
                }
                case CREOSOTE: {
                    mat.sound = Block.field_149766_f;
                    break;
                }
                case COPPER: 
                case TIN: 
                case LEAD: 
                case STEEL: {
                    mat.sound = Block.field_149777_j;
                    break;
                }
                default: {
                    mat.sound = mat.source.field_149762_H;
                }
            }
            if (mat.sound != RailcraftSound.getInstance()) continue;
            throw new RuntimeException("Invalid Sound Defined!");
        }
        creativeList.add(SNOW);
        creativeList.add(ICE);
        creativeList.add(PACKED_ICE);
        creativeList.add(IRON);
        creativeList.add(STEEL);
        creativeList.add(COPPER);
        creativeList.add(TIN);
        creativeList.add(LEAD);
        creativeList.add(GOLD);
        creativeList.add(DIAMOND);
        creativeList.add(OBSIDIAN);
        creativeList.add(CONCRETE);
        creativeList.add(CREOSOTE);
        creativeList.add(ABYSSAL_BRICK);
        creativeList.add(ABYSSAL_FITTED);
        creativeList.add(ABYSSAL_BLOCK);
        creativeList.add(ABYSSAL_COBBLE);
        creativeList.add(INFERNAL_BRICK);
        creativeList.add(INFERNAL_FITTED);
        creativeList.add(INFERNAL_BLOCK);
        creativeList.add(INFERNAL_COBBLE);
        creativeList.add(BLOODSTAINED_BRICK);
        creativeList.add(BLOODSTAINED_FITTED);
        creativeList.add(BLOODSTAINED_BLOCK);
        creativeList.add(BLOODSTAINED_COBBLE);
        creativeList.add(SANDY_BRICK);
        creativeList.add(SANDY_FITTED);
        creativeList.add(SANDY_BLOCK);
        creativeList.add(SANDY_COBBLE);
        creativeList.add(BLEACHEDBONE_BRICK);
        creativeList.add(BLEACHEDBONE_FITTED);
        creativeList.add(BLEACHEDBONE_BLOCK);
        creativeList.add(BLEACHEDBONE_COBBLE);
        creativeList.add(NETHER_FITTED);
        creativeList.add(NETHER_BLOCK);
        creativeList.add(NETHER_COBBLE);
        creativeList.add(QUARRIED_BRICK);
        creativeList.add(QUARRIED_FITTED);
        creativeList.add(QUARRIED_BLOCK);
        creativeList.add(QUARRIED_COBBLE);
        creativeList.add(FROSTBOUND_BRICK);
        creativeList.add(FROSTBOUND_FITTED);
        creativeList.add(FROSTBOUND_BLOCK);
        creativeList.add(FROSTBOUND_COBBLE);
    }

    public static EnumBlockMaterial fromOrdinal(int id) {
        if (id < 0 || id >= VALUES.length) {
            return VALUES[0];
        }
        return VALUES[id];
    }

    public static EnumBlockMaterial fromName(String name) {
        EnumBlockMaterial stair = NAMES.get(name);
        if (stair != null) {
            return stair;
        }
        return SANDY_BRICK;
    }

    public IIcon getIcon(int side) {
        return this.getSourceBlock().func_149691_a(side, this.sourceMeta);
    }

    @Override
    public Block getSourceBlock() {
        if (this.source == null) {
            return Blocks.field_150417_aV;
        }
        return this.source;
    }

    @Override
    public int getSourceMeta() {
        return this.sourceMeta;
    }

    public String getOreTag() {
        return this.oreTag;
    }

    public Block.SoundType getSound() {
        return this.sound;
    }

    public ItemStack getSourceItem() {
        if (this.source == null) {
            return null;
        }
        return new ItemStack(this.source, 1, this.sourceMeta);
    }

    public Object getCraftingEquivelent() {
        if (this.oreTag != null) {
            return this.oreTag;
        }
        if (this.source == null) {
            return null;
        }
        return new ItemStack(this.source, 1, this.sourceMeta);
    }

    public boolean isTransparent() {
        return this == ICE;
    }

    public float getBlockHardness(World world, int x, int y, int z) {
        switch (this) {
            case CONCRETE: {
                return EnumCube.CONCRETE_BLOCK.getHardness();
            }
            case COPPER: {
                return EnumCube.COPPER_BLOCK.getHardness();
            }
            case TIN: {
                return EnumCube.TIN_BLOCK.getHardness();
            }
            case LEAD: {
                return EnumCube.LEAD_BLOCK.getHardness();
            }
            case STEEL: {
                return EnumCube.STEEL_BLOCK.getHardness();
            }
        }
        Block block = this.getSourceBlock();
        if (block == null) {
            return Blocks.field_150336_V.func_149712_f(world, x, y, z);
        }
        return block.func_149712_f(world, x, y, z);
    }

    public float getExplosionResistance(Entity entity) {
        switch (this) {
            case CONCRETE: {
                return EnumCube.CONCRETE_BLOCK.getResistance() * 3.0f / 5.0f;
            }
            case COPPER: {
                return EnumCube.COPPER_BLOCK.getResistance() * 3.0f / 5.0f;
            }
            case TIN: {
                return EnumCube.TIN_BLOCK.getResistance() * 3.0f / 5.0f;
            }
            case LEAD: {
                return EnumCube.LEAD_BLOCK.getResistance() * 3.0f / 5.0f;
            }
            case STEEL: {
                return EnumCube.STEEL_BLOCK.getResistance() * 3.0f / 5.0f;
            }
        }
        Block block = this.getSourceBlock();
        if (block == null) {
            return Blocks.field_150336_V.func_149638_a(entity);
        }
        return block.func_149638_a(entity);
    }

    static {
        VALUES = EnumBlockMaterial.values();
        NAMES = new HashMap<String, EnumBlockMaterial>();
        creativeList = new ArrayList<EnumBlockMaterial>();
        needsInit = true;
    }
}

