/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.modules;

import java.util.ArrayList;
import mods.railcraft.api.crafting.IRockCrusherRecipe;
import mods.railcraft.api.crafting.RailcraftCraftingManager;
import mods.railcraft.common.blocks.aesthetics.brick.BrickVariant;
import mods.railcraft.common.blocks.aesthetics.brick.EnumBrick;
import mods.railcraft.common.blocks.aesthetics.cube.BlockCube;
import mods.railcraft.common.blocks.aesthetics.cube.EnumCube;
import mods.railcraft.common.blocks.anvil.BlockRCAnvil;
import mods.railcraft.common.blocks.machine.alpha.EnumMachineAlpha;
import mods.railcraft.common.blocks.machine.beta.EnumMachineBeta;
import mods.railcraft.common.core.RailcraftConfig;
import mods.railcraft.common.fluids.FluidHelper;
import mods.railcraft.common.fluids.Fluids;
import mods.railcraft.common.items.ItemDust;
import mods.railcraft.common.items.ItemGear;
import mods.railcraft.common.items.ItemNugget;
import mods.railcraft.common.items.ItemPlate;
import mods.railcraft.common.items.ItemTie;
import mods.railcraft.common.items.Metal;
import mods.railcraft.common.items.RailcraftItem;
import mods.railcraft.common.items.RailcraftToolItems;
import mods.railcraft.common.modules.ModuleManager;
import mods.railcraft.common.modules.RailcraftModule;
import mods.railcraft.common.plugins.forestry.ForestryPlugin;
import mods.railcraft.common.plugins.forge.CraftingPlugin;
import mods.railcraft.common.plugins.forge.LootPlugin;
import mods.railcraft.common.plugins.ic2.IC2Plugin;
import mods.railcraft.common.util.crafting.RollingMachineCraftingManager;
import mods.railcraft.common.util.misc.BallastRegistry;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;

public class ModuleFactory
extends RailcraftModule {
    private static final int COKE_COOK_TIME = 1800;
    private static final int COKE_COOK_CREOSOTE = 500;

    private static void registerAltSteelFurnaceRecipe() {
        ArrayList iron = OreDictionary.getOres((String)"nuggetIron");
        for (ItemStack nugget : iron) {
            CraftingPlugin.addFurnaceRecipe(nugget, RailcraftItem.nugget.getStack(ItemNugget.EnumNugget.STEEL), 0.0f);
        }
    }

    @Override
    public void initFirst() {
        ItemStack stack;
        EnumMachineAlpha alpha;
        BlockCube.registerBlock();
        RailcraftToolItems.registerCoalCoke();
        BlockRCAnvil.registerBlock();
        if (BlockRCAnvil.getBlock() != null) {
            CraftingPlugin.addShapedRecipe(new ItemStack(BlockRCAnvil.getBlock(), 1, 0), "BBB", " I ", "III", Character.valueOf('B'), "blockSteel", Character.valueOf('I'), "ingotSteel");
        }
        if ((alpha = EnumMachineAlpha.COKE_OVEN).register()) {
            stack = alpha.getItem();
            CraftingPlugin.addShapedRecipe(stack, "MBM", "BMB", "MBM", Character.valueOf('B'), "ingotBrick", Character.valueOf('M'), "sand");
            if (RailcraftToolItems.getCoalCoke() != null) {
                RailcraftCraftingManager.cokeOven.addRecipe(new ItemStack(Items.field_151044_h, 1, 0), true, false, RailcraftToolItems.getCoalCoke(), Fluids.CREOSOTE.get(500), 1800);
            }
        }
        if ((alpha = EnumMachineAlpha.STEAM_OVEN).register()) {
            CraftingPlugin.addShapedRecipe(alpha.getItem(4), "SSS", "SFS", "SSS", Character.valueOf('F'), new ItemStack(Blocks.field_150460_al), Character.valueOf('S'), RailcraftItem.plate.getRecipeObject(ItemPlate.EnumPlate.STEEL));
        }
        RailcraftCraftingManager.blastFurnace.addRecipe(new ItemStack(Items.field_151044_h, 1, 0), true, false, 20, RailcraftToolItems.getCoalCoke());
        RailcraftCraftingManager.blastFurnace.addRecipe(new ItemStack(Blocks.field_150402_ci), false, false, 180, EnumCube.COKE_BLOCK.getItem());
        alpha = EnumMachineAlpha.ROCK_CRUSHER;
        if (alpha.register()) {
            stack = alpha.getItem(4);
            CraftingPlugin.addShapedRecipe(stack, "PDP", "DSD", "PDP", Character.valueOf('D'), "gemDiamond", Character.valueOf('P'), new ItemStack((Block)Blocks.field_150331_J), Character.valueOf('S'), "blockSteel");
        }
        if ((alpha = EnumMachineAlpha.ROLLING_MACHINE).register()) {
            stack = alpha.getItem();
            CraftingPlugin.addShapedRecipe(stack, "IPI", "PCP", "IPI", Character.valueOf('I'), "ingotIron", Character.valueOf('P'), Blocks.field_150331_J, Character.valueOf('C'), "craftingTableWood");
        } else {
            RollingMachineCraftingManager.copyRecipesToWorkbench();
        }
        EnumMachineBeta metalsChest = EnumMachineBeta.METALS_CHEST;
        if (metalsChest.register()) {
            CraftingPlugin.addShapedRecipe(metalsChest.getItem(), "GPG", "PAP", "GPG", Character.valueOf('A'), new ItemStack(Blocks.field_150467_bQ), Character.valueOf('P'), new ItemStack((Block)Blocks.field_150331_J), Character.valueOf('G'), RailcraftItem.gear.getRecipeObject(ItemGear.EnumGear.STEEL));
        }
        if (BlockCube.getBlock() != null) {
            EnumCube type = EnumCube.STEEL_BLOCK;
            if (RailcraftConfig.isSubBlockEnabled(type.getTag())) {
                this.initMetalBlock(Metal.STEEL);
                LootPlugin.addLootTool(type.getItem(), 1, 1, "steel.block");
            }
            if (RailcraftConfig.isSubBlockEnabled((type = EnumCube.COPPER_BLOCK).getTag())) {
                this.initMetalBlock(Metal.COPPER);
            }
            if (RailcraftConfig.isSubBlockEnabled((type = EnumCube.TIN_BLOCK).getTag())) {
                this.initMetalBlock(Metal.TIN);
            }
            if (RailcraftConfig.isSubBlockEnabled((type = EnumCube.LEAD_BLOCK).getTag())) {
                this.initMetalBlock(Metal.LEAD);
            }
            if (RailcraftConfig.isSubBlockEnabled((type = EnumCube.CRUSHED_OBSIDIAN).getTag())) {
                ItemStack stack2 = type.getItem();
                BallastRegistry.registerBallast(BlockCube.getBlock(), type.ordinal());
                if (IC2Plugin.isModInstalled() && RailcraftConfig.addObsidianRecipesToMacerator() && RailcraftItem.dust.isEnabled()) {
                    IC2Plugin.addMaceratorRecipe(new ItemStack(Blocks.field_150343_Z), stack2);
                    IC2Plugin.addMaceratorRecipe(stack2, RailcraftItem.dust.getStack(ItemDust.EnumDust.OBSIDIAN));
                }
            }
            if (RailcraftConfig.isSubBlockEnabled((type = EnumCube.COKE_BLOCK).getTag())) {
                BlockCube.registerBlock();
                BlockCube cube = BlockCube.getBlock();
                if (cube != null) {
                    ItemStack stack3 = type.getItem();
                    CraftingPlugin.addShapedRecipe(stack3, "CCC", "CCC", "CCC", Character.valueOf('C'), RailcraftToolItems.getCoalCoke());
                    CraftingPlugin.addShapelessRecipe(RailcraftToolItems.getCoalCoke(9), stack3);
                }
            }
        }
    }

    private void addAnchorOutputs(IRockCrusherRecipe recipe) {
        if (EnumCube.CRUSHED_OBSIDIAN.isEnabled()) {
            recipe.addOutput(EnumCube.CRUSHED_OBSIDIAN.getItem(), 1.0f);
            recipe.addOutput(EnumCube.CRUSHED_OBSIDIAN.getItem(), 0.5f);
        } else {
            recipe.addOutput(new ItemStack(Blocks.field_150343_Z), 1.0f);
            recipe.addOutput(new ItemStack(Blocks.field_150343_Z), 0.5f);
        }
        recipe.addOutput(new ItemStack(Blocks.field_150343_Z), 0.25f);
        if (RailcraftItem.dust.isEnabled()) {
            recipe.addOutput(RailcraftItem.dust.getStack(ItemDust.EnumDust.OBSIDIAN), 0.25f);
        }
        recipe.addOutput(new ItemStack(Items.field_151074_bl, 16), 1.0f);
        recipe.addOutput(new ItemStack(Items.field_151074_bl, 8), 0.5f);
        recipe.addOutput(new ItemStack(Items.field_151074_bl, 8), 0.5f);
        recipe.addOutput(new ItemStack(Items.field_151074_bl, 4), 0.5f);
    }

    @Override
    public void initSecond() {
        if (ModuleManager.isModuleLoaded(ModuleManager.Module.STRUCTURES)) {
            ItemStack stack;
            if (EnumMachineAlpha.BLAST_FURNACE.isAvaliable() && EnumBrick.INFERNAL.getBlock() != null) {
                stack = EnumMachineAlpha.BLAST_FURNACE.getItem(4);
                CraftingPlugin.addShapedRecipe(stack, " B ", "BPB", " B ", Character.valueOf('B'), EnumBrick.INFERNAL.get(BrickVariant.BRICK, 1), Character.valueOf('P'), Items.field_151064_bs);
            }
            if (EnumMachineAlpha.COKE_OVEN.isAvaliable() && EnumBrick.SANDY.getBlock() != null) {
                stack = EnumMachineAlpha.COKE_OVEN.getItem();
                CraftingPlugin.addShapedRecipe(stack, " B ", " S ", " B ", Character.valueOf('B'), EnumBrick.SANDY.get(BrickVariant.BRICK, 1), Character.valueOf('S'), "sand");
            }
        }
        if (EnumCube.COKE_BLOCK.isEnabled()) {
            RailcraftCraftingManager.cokeOven.addRecipe(new ItemStack(Blocks.field_150402_ci), false, false, EnumCube.COKE_BLOCK.getItem(), Fluids.CREOSOTE.get(4500), 16200);
        }
        if (Fluids.CREOSOTE.get() != null && RailcraftConfig.creosoteTorchOutput() > 0) {
            FluidStack creosote = Fluids.CREOSOTE.get(1000);
            for (ItemStack container : FluidHelper.getContainersFilledWith(creosote)) {
                CraftingPlugin.addShapedRecipe(new ItemStack(Blocks.field_150478_aa, RailcraftConfig.creosoteTorchOutput()), "C", "W", "S", Character.valueOf('C'), container, Character.valueOf('W'), Blocks.field_150325_L, Character.valueOf('S'), "stickWood");
            }
            ForestryPlugin.instance().addCarpenterRecipe("torches", 10, Fluids.CREOSOTE.get(1000), null, new ItemStack(Blocks.field_150478_aa, RailcraftConfig.creosoteTorchOutput()), "#", "|", Character.valueOf('#'), Blocks.field_150325_L, Character.valueOf('|'), Items.field_151055_y);
        }
    }

    @Override
    public void postInit() {
        if (OreDictionary.getOres((String)"blockSteel").isEmpty()) {
            OreDictionary.registerOre((String)"blockSteel", (Block)Blocks.field_150339_S);
        }
        if (!EnumMachineAlpha.BLAST_FURNACE.isAvaliable()) {
            ModuleFactory.registerAltSteelFurnaceRecipe();
        }
        ArrayList logs = new ArrayList(25);
        logs.addAll(OreDictionary.getOres((String)"logWood"));
        logs.addAll(OreDictionary.getOres((String)"woodRubber"));
        for (ItemStack log : logs) {
            RailcraftCraftingManager.cokeOven.addRecipe(log, true, false, new ItemStack(Items.field_151044_h, 1, 1), Fluids.CREOSOTE.get(250), 1800);
            RailcraftCraftingManager.blastFurnace.addRecipe(log, false, false, 20, new ItemStack(Items.field_151044_h, 1, 1));
        }
        if (IC2Plugin.isModInstalled()) {
            boolean classic = IC2Plugin.isClassic();
            ItemStack crushedIron = IC2Plugin.getItem(classic ? "ironDust" : "crushedIronOre");
            ItemStack crushedGold = IC2Plugin.getItem(classic ? "goldDust" : "crushedGoldOre");
            ItemStack crushedCopper = IC2Plugin.getItem(classic ? "copperDust" : "crushedCopperOre");
            ItemStack crushedTin = IC2Plugin.getItem(classic ? "tinDust" : "crushedTinOre");
            ItemStack crushedSilver = IC2Plugin.getItem(classic ? "silverDust" : "crushedSilverOre");
            ItemStack crushedLead = IC2Plugin.getItem("crushedLeadOre");
            ItemStack crushedUranium = IC2Plugin.getItem(classic ? "uraniumDrop" : "crushedUraniumOre");
            if (!RailcraftConfig.getRecipeConfig("ic2.macerator.ores")) {
                IC2Plugin.removeMaceratorDustRecipes(crushedIron, crushedGold, crushedCopper, crushedTin, crushedSilver, crushedLead, crushedUranium);
            }
            if (!RailcraftConfig.getRecipeConfig("ic2.macerator.bones")) {
                IC2Plugin.removeMaceratorRecipes(new ItemStack(Items.field_151100_aR, 1, 15));
            }
            if (!RailcraftConfig.getRecipeConfig("ic2.macerator.blaze")) {
                IC2Plugin.removeMaceratorRecipes(new ItemStack(Items.field_151065_br));
            }
            if (!RailcraftConfig.getRecipeConfig("ic2.macerator.cobble")) {
                IC2Plugin.removeMaceratorRecipes(new ItemStack(Blocks.field_150347_e));
            }
            if (!RailcraftConfig.getRecipeConfig("ic2.macerator.dirt")) {
                IC2Plugin.removeMaceratorRecipes(new ItemStack(Blocks.field_150346_d));
            }
        }
        ForestryPlugin.instance().addCarpenterRecipe("ties", 40, Fluids.CREOSOTE.get(750), null, RailcraftItem.tie.getStack(1, ItemTie.EnumTie.WOOD), "###", Character.valueOf('#'), "slabWood");
    }

    @Override
    public void postInitNotLoaded() {
        RollingMachineCraftingManager.copyRecipesToWorkbench();
        ModuleFactory.registerAltSteelFurnaceRecipe();
    }

    private void initMetalBlock(Metal m) {
        OreDictionary.registerOre((String)m.getBlockTag(), (ItemStack)m.getBlock());
        CraftingPlugin.addShapedRecipe(m.getBlock(), "III", "III", "III", Character.valueOf('I'), m.getIngotTag());
        CraftingPlugin.addShapelessRecipe(m.getIngot(9), m.getBlockTag());
    }
}

