/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.api.tracks;

import cpw.mods.fml.common.FMLLog;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import mods.railcraft.api.core.ITextureLoader;
import mods.railcraft.api.tracks.TrackSpec;
import org.apache.logging.log4j.Level;

public class TrackRegistry {
    private static final Map<Short, TrackSpec> trackSpecsFromID = new HashMap<Short, TrackSpec>();
    private static final Map<String, TrackSpec> trackSpecsFromTag = new HashMap<String, TrackSpec>();
    private static final Set<Short> invalidSpecIDs = new HashSet<Short>();
    private static final Set<String> invalidSpecTags = new HashSet<String>();
    private static final List<ITextureLoader> iconLoaders = new ArrayList<ITextureLoader>();

    public static void registerIconLoader(ITextureLoader iconLoader) {
        iconLoaders.add(iconLoader);
    }

    public static List<ITextureLoader> getIconLoaders() {
        return iconLoaders;
    }

    public static void registerTrackSpec(TrackSpec trackSpec) {
        if (trackSpecsFromID.put(trackSpec.getTrackId(), trackSpec) != null) {
            throw new TrackSpecConflictException("TrackId conflict detected, please adjust your config or contact the author of the " + trackSpec.getTrackTag());
        }
        if (trackSpecsFromTag.put(trackSpec.getTrackTag(), trackSpec) != null) {
            throw new TrackSpecConflictException("TrackTag conflict detected, please adjust your config or contact the author of the " + trackSpec.getTrackTag());
        }
    }

    public static TrackSpec getTrackSpec(int trackId) {
        Short id = (short)trackId;
        TrackSpec spec = trackSpecsFromID.get(id);
        if (spec == null) {
            if (!invalidSpecIDs.contains(id)) {
                FMLLog.log((String)"Railcraft", (Level)Level.WARN, (String)"Unknown Track Spec ID(%d), reverting to normal track", (Object[])new Object[]{trackId});
                StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
                for (int i = 1; i < stackTrace.length && i < 9; ++i) {
                    FMLLog.log((Level)Level.DEBUG, (String)stackTrace[i].toString(), (Object[])new Object[0]);
                }
                invalidSpecIDs.add(id);
            }
            id = -1;
            spec = trackSpecsFromID.get(id);
        }
        return spec;
    }

    public static TrackSpec getTrackSpec(String trackTag) {
        TrackSpec spec = trackSpecsFromTag.get(trackTag = trackTag.toLowerCase(Locale.ENGLISH));
        if (spec == null) {
            if (!invalidSpecTags.contains(trackTag)) {
                FMLLog.log((String)"Railcraft", (Level)Level.WARN, (String)"Unknown Track Spec Tag(%s), reverting to normal track", (Object[])new Object[]{trackTag});
                StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
                for (int i = 1; i < stackTrace.length && i < 9; ++i) {
                    FMLLog.log((Level)Level.DEBUG, (String)stackTrace[i].toString(), (Object[])new Object[0]);
                }
                invalidSpecTags.add(trackTag);
            }
            spec = trackSpecsFromTag.get("railcraft:default");
        }
        return spec;
    }

    public static Map<Short, TrackSpec> getTrackSpecIDs() {
        return trackSpecsFromID;
    }

    public static Map<String, TrackSpec> getTrackSpecTags() {
        return trackSpecsFromTag;
    }

    public static class TrackSpecConflictException
    extends RuntimeException {
        public TrackSpecConflictException(String msg) {
            super(msg);
        }
    }
}

