/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.signals;

import cpw.mods.fml.common.Optional;
import ic2.api.item.IBoxable;
import mods.railcraft.api.core.WorldCoordinate;
import mods.railcraft.api.signals.IControllerTile;
import mods.railcraft.api.signals.IReceiverTile;
import mods.railcraft.api.signals.SignalController;
import mods.railcraft.api.signals.SignalReceiver;
import mods.railcraft.common.core.RailcraftConfig;
import mods.railcraft.common.items.IActivationBlockingItem;
import mods.railcraft.common.items.ItemCircuit;
import mods.railcraft.common.items.ItemRailcraft;
import mods.railcraft.common.items.RailcraftItem;
import mods.railcraft.common.plugins.forge.ChatPlugin;
import mods.railcraft.common.plugins.forge.CraftingPlugin;
import mods.railcraft.common.plugins.forge.CreativePlugin;
import mods.railcraft.common.plugins.forge.LootPlugin;
import mods.railcraft.common.plugins.forge.RailcraftRegistry;
import mods.railcraft.common.util.misc.Game;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.DimensionManager;

@Optional.InterfaceList(value={@Optional.Interface(iface="ic2.api.item.IBoxable", modid="IC2")})
public class ItemSignalTuner
extends ItemRailcraft
implements IBoxable,
IActivationBlockingItem {
    private static Item item;

    private ItemSignalTuner() {
        this.func_77656_e(0);
        this.func_77627_a(true);
        this.func_77625_d(1);
        this.func_77637_a(CreativePlugin.RAILCRAFT_TAB);
    }

    public static void registerItem() {
        String tag;
        if (item == null && RailcraftConfig.isItemEnabled(tag = "railcraft.tool.signal.tuner")) {
            item = new ItemSignalTuner().func_77655_b(tag);
            RailcraftRegistry.register(item);
            CraftingPlugin.addShapedRecipe(new ItemStack(item), new Object[]{" T ", "BRB", "   ", Character.valueOf('B'), Blocks.field_150430_aB, Character.valueOf('R'), RailcraftItem.circuit, ItemCircuit.EnumCircuit.RECEIVER, Character.valueOf('T'), Blocks.field_150429_aA});
            LootPlugin.addLootWorkshop(new ItemStack(item), 1, 1, "tool.signal.tuner");
        }
    }

    public static ItemStack getItem() {
        if (item == null) {
            return null;
        }
        return new ItemStack(item);
    }

    public boolean func_77648_a(ItemStack item, EntityPlayer player, World world, int i, int j, int k, int side, float par8, float par9, float par10) {
        if (Game.isHost(world) && item.func_77942_o() && player.func_70093_af()) {
            TileEntity tile;
            WorldCoordinate cPos = this.getControllerData(item);
            if (cPos != null && (tile = DimensionManager.getWorld((int)cPos.dimension).func_147438_o(cPos.x, cPos.y, cPos.z)) instanceof IControllerTile) {
                ((IControllerTile)tile).getController().endPairing();
            }
            ChatPlugin.sendLocalizedChatFromServer(player, "railcraft.gui.tuner.abandon.player", new Object[0]);
            item.func_77982_d(null);
            return false;
        }
        TileEntity tile = world.func_147438_o(i, j, k);
        if (tile != null) {
            WorldCoordinate cPos = this.getControllerData(item);
            if (tile instanceof IReceiverTile && cPos != null) {
                if (Game.isHost(world)) {
                    SignalReceiver receiver = ((IReceiverTile)tile).getReceiver();
                    if (i != cPos.x || j != cPos.y || k != cPos.z) {
                        tile = world.func_147438_o(cPos.x, cPos.y, cPos.z);
                        if (tile != null && tile instanceof IControllerTile) {
                            SignalController controller = ((IControllerTile)tile).getController();
                            if (receiver.getTile() != controller.getTile()) {
                                controller.registerReceiver(receiver);
                                controller.endPairing();
                                ChatPlugin.sendLocalizedChatFromServer(player, "railcraft.gui.tuner.success", controller.getLocalizationTag(), receiver.getLocalizationTag());
                                item.func_77982_d(null);
                                return true;
                            }
                        } else if (world.func_72899_e(cPos.x, cPos.y, cPos.z)) {
                            ChatPlugin.sendLocalizedChatFromServer(player, "railcraft.gui.tuner.abandon.gone", new Object[0]);
                            item.func_77982_d(null);
                        } else {
                            ChatPlugin.sendLocalizedChatFromServer(player, "railcraft.gui.tuner.abandon.chunk", new Object[0]);
                            item.func_77982_d(null);
                        }
                    }
                }
            } else if (tile instanceof IControllerTile) {
                if (Game.isHost(world)) {
                    SignalController controller = ((IControllerTile)tile).getController();
                    if (cPos == null || i != cPos.x || j != cPos.y || k != cPos.z) {
                        ChatPlugin.sendLocalizedChatFromServer(player, "railcraft.gui.tuner.start", controller.getLocalizationTag());
                        this.setControllerData(item, tile);
                        controller.startPairing();
                    } else {
                        ChatPlugin.sendLocalizedChatFromServer(player, "railcraft.gui.tuner.stop", controller.getLocalizationTag());
                        controller.endPairing();
                        item.func_77982_d(null);
                    }
                }
            } else {
                return false;
            }
            return true;
        }
        return false;
    }

    private WorldCoordinate getControllerData(ItemStack item) {
        WorldCoordinate cPos = null;
        NBTTagCompound data = item.func_77978_p();
        if (data != null) {
            int cDim = data.func_74762_e("controllerDim");
            int cx = data.func_74762_e("controllerX");
            int cy = data.func_74762_e("controllerY");
            int cz = data.func_74762_e("controllerZ");
            cPos = new WorldCoordinate(cDim, cx, cy, cz);
        }
        return cPos;
    }

    private void setControllerData(ItemStack item, TileEntity tile) {
        NBTTagCompound data = new NBTTagCompound();
        data.func_74768_a("controllerDim", tile.func_145831_w().field_73011_w.field_76574_g);
        data.func_74768_a("controllerX", tile.field_145851_c);
        data.func_74768_a("controllerY", tile.field_145848_d);
        data.func_74768_a("controllerZ", tile.field_145849_e);
        item.func_77982_d(data);
    }

    public boolean canBeStoredInToolbox(ItemStack itemstack) {
        return true;
    }
}

