/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.machine.gamma;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import mods.railcraft.api.carts.CartTools;
import mods.railcraft.common.blocks.machine.IEnumMachine;
import mods.railcraft.common.blocks.machine.gamma.EnumMachineGamma;
import mods.railcraft.common.blocks.machine.gamma.TileLoaderItemBase;
import mods.railcraft.common.gui.EnumGui;
import mods.railcraft.common.gui.GuiHandler;
import mods.railcraft.common.gui.slots.SlotOutput;
import mods.railcraft.common.util.inventory.AdjacentInventoryCache;
import mods.railcraft.common.util.inventory.InvFilteredHelper;
import mods.railcraft.common.util.inventory.InvTools;
import mods.railcraft.common.util.inventory.InventorySorter;
import mods.railcraft.common.util.inventory.ItemStackMap;
import mods.railcraft.common.util.inventory.ItemStackSet;
import mods.railcraft.common.util.inventory.wrappers.InventoryMapper;
import mods.railcraft.common.util.misc.Game;
import mods.railcraft.common.util.misc.ITileFilter;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraftforge.common.util.ForgeDirection;

public class TileItemUnloader
extends TileLoaderItemBase {
    private static final TileLoaderItemBase.EnumRedstoneMode[] REDSTONE_MODES = new TileLoaderItemBase.EnumRedstoneMode[]{TileLoaderItemBase.EnumRedstoneMode.IMMEDIATE, TileLoaderItemBase.EnumRedstoneMode.COMPLETE, TileLoaderItemBase.EnumRedstoneMode.MANUAL};
    private final IInventory invBuffer;
    private final Map<ItemStack, Short> transferedItems = new ItemStackMap<Short>();
    private final Set<ItemStack> checkedItems = new ItemStackSet();
    private final LinkedList<IInventory> chests = new LinkedList();
    private AdjacentInventoryCache invCache = new AdjacentInventoryCache(this, this.tileCache, new ITileFilter(){

        @Override
        public boolean matches(TileEntity tile) {
            return !(tile instanceof TileItemUnloader);
        }
    }, InventorySorter.SIZE_DECENDING);

    public TileItemUnloader() {
        this.setInventorySize(9);
        this.invBuffer = new InventoryMapper((IInventory)this.getInventory(), false);
    }

    @Override
    public TileLoaderItemBase.EnumRedstoneMode[] getValidRedstoneModes() {
        return REDSTONE_MODES;
    }

    @Override
    public IEnumMachine getMachineType() {
        return EnumMachineGamma.ITEM_UNLOADER;
    }

    @Override
    public Slot getBufferSlot(int id, int x, int y) {
        return new SlotOutput(this, id, x, y);
    }

    @Override
    public IIcon getIcon(int side) {
        return this.getMachineType().getTexture(side);
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (Game.isNotHost(this.getWorld())) {
            return;
        }
        this.emptyCart();
        this.clearInv();
    }

    private void emptyCart() {
        this.movedItemCart = false;
        EntityMinecart cart = CartTools.getMinecartOnSide(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, 0.1f, this.getOrientation());
        if (cart == null) {
            this.setPowered(false);
            this.currentCart = null;
            return;
        }
        if (cart != this.currentCart) {
            this.setPowered(false);
            this.currentCart = cart;
            this.transferedItems.clear();
            this.cartWasSent();
        }
        if (!this.canHandleCart(cart)) {
            this.sendCart(cart);
            return;
        }
        if (this.isPaused()) {
            return;
        }
        this.chests.clear();
        this.chests.addAll(this.invCache.getAdjacentInventories());
        this.chests.addFirst(this.invBuffer);
        this.checkedItems.clear();
        IInventory cartInv = (IInventory)cart;
        block0 : switch (this.getMode()) {
            case TRANSFER: {
                ItemStack moved;
                boolean hasFilter = false;
                for (ItemStack filter : this.getItemFilters().getContents()) {
                    ItemStack moved2;
                    if (filter == null || !this.checkedItems.add(filter)) continue;
                    hasFilter = true;
                    Short numMoved = this.transferedItems.get(filter);
                    if (numMoved == null) {
                        numMoved = 0;
                    }
                    InvFilteredHelper helper = InvFilteredHelper.filteredByStacks(this.isMatchByNBT(), this.isMatchByMetadata(), filter);
                    if (numMoved >= helper.countItems(this.getItemFilters()) || (moved2 = helper.moveOneItem(cartInv, this.chests)) == null) continue;
                    this.movedItemCart = true;
                    Short s = numMoved;
                    Short s2 = numMoved = Short.valueOf((short)(numMoved + 1));
                    this.transferedItems.put(moved2, numMoved);
                    break;
                }
                if (hasFilter || (moved = InvTools.moveOneItem(cartInv, this.chests, new ItemStack[0])) == null) break;
                this.movedItemCart = true;
                break;
            }
            case STOCK: {
                for (ItemStack filter : this.getItemFilters().getContents()) {
                    ItemStack moved;
                    InvFilteredHelper helper;
                    int stocked;
                    if (filter == null || !this.checkedItems.add(filter) || (stocked = (helper = InvFilteredHelper.filteredByStacks(this.isMatchByNBT(), this.isMatchByMetadata(), filter)).countItems(this.chests)) >= helper.countItems(this.getItemFilters()) || (moved = helper.moveOneItem(cartInv, this.chests)) == null) continue;
                    this.movedItemCart = true;
                    break block0;
                }
                break;
            }
            case EXCESS: {
                for (ItemStack filter : this.getItemFilters().getContents()) {
                    ItemStack moved;
                    InvFilteredHelper helper;
                    int stocked;
                    if (filter == null || !this.checkedItems.add(filter) || (stocked = (helper = InvFilteredHelper.filteredByStacks(this.isMatchByNBT(), this.isMatchByMetadata(), filter)).countItems(cartInv)) <= helper.countItems(this.getItemFilters()) || (moved = helper.moveOneItem(cartInv, this.chests)) == null) continue;
                    this.movedItemCart = true;
                    break;
                }
                if (this.movedItemCart) break;
                this.movedItemCart = InvFilteredHelper.filteredByStacks(this.getItemFilters().getContents()).invert().moveOneItem(cartInv, this.chests) != null;
                break;
            }
            case ALL: {
                boolean hasFilter = false;
                ItemStack moved = this.getItemFilters().getContents();
                int n = ((ItemStack[])moved).length;
                for (int i = 0; i < n; ++i) {
                    ItemStack filter = moved[i];
                    if (filter == null || !this.checkedItems.add(filter)) continue;
                    hasFilter = true;
                    ItemStack moved3 = InvFilteredHelper.filteredByStacks(this.isMatchByNBT(), this.isMatchByMetadata(), filter).moveOneItem(cartInv, this.chests);
                    if (moved3 == null) continue;
                    this.movedItemCart = true;
                    break;
                }
                if (hasFilter || (moved = InvTools.moveOneItem(cartInv, this.chests, new ItemStack[0])) == null) break;
                this.movedItemCart = true;
                break;
            }
        }
        TileLoaderItemBase.EnumRedstoneMode state = this.getRedstoneModeController().getButtonState();
        if (state != TileLoaderItemBase.EnumRedstoneMode.MANUAL && !this.isPowered() && this.shouldSendCart(cart)) {
            this.sendCart(cart);
        }
    }

    @Override
    public boolean canHandleCart(EntityMinecart cart) {
        if (!super.canHandleCart(cart)) {
            return false;
        }
        return !InvTools.isInventoryEmpty((IInventory)cart);
    }

    @Override
    protected boolean shouldSendCart(EntityMinecart cart) {
        if (!(cart instanceof IInventory)) {
            return true;
        }
        IInventory cartInv = (IInventory)cart;
        TileLoaderItemBase.EnumRedstoneMode state = this.getRedstoneModeController().getButtonState();
        if (!this.movedItemCart && state != TileLoaderItemBase.EnumRedstoneMode.COMPLETE) {
            return true;
        }
        if (this.getMode() == TileLoaderItemBase.EnumTransferMode.TRANSFER && this.isTransferComplete(this.getItemFilters().getContents())) {
            return true;
        }
        if (this.getMode() == TileLoaderItemBase.EnumTransferMode.STOCK && this.isStockComplete(this.chests, this.getItemFilters().getContents())) {
            return true;
        }
        if (this.getMode() == TileLoaderItemBase.EnumTransferMode.EXCESS && this.isExcessComplete(cartInv, this.getItemFilters().getContents())) {
            return true;
        }
        if (this.getMode() == TileLoaderItemBase.EnumTransferMode.ALL && this.isAllComplete(this.chests, this.getItemFilters().getContents())) {
            return true;
        }
        return !this.movedItemCart && InvTools.isAccessibleInventoryEmpty(cartInv, this.getOrientation().getOpposite());
    }

    private boolean isTransferComplete(ItemStack[] filters) {
        this.checkedItems.clear();
        boolean hasFilter = false;
        for (ItemStack filter : filters) {
            if (filter == null || !this.checkedItems.add(filter)) continue;
            hasFilter = true;
            Short numMoved = this.transferedItems.get(filter);
            if (numMoved != null && numMoved >= InvFilteredHelper.filteredByStacks(this.isMatchByNBT(), this.isMatchByMetadata(), filter).countItems(this.getItemFilters())) continue;
            return false;
        }
        return hasFilter;
    }

    private boolean isStockComplete(List<IInventory> chests, ItemStack[] filters) {
        this.checkedItems.clear();
        for (ItemStack filter : filters) {
            InvFilteredHelper helper;
            int stocked;
            if (filter == null || !this.checkedItems.add(filter) || (stocked = (helper = InvFilteredHelper.filteredByStacks(this.isMatchByNBT(), this.isMatchByMetadata(), filter)).countItems(chests)) >= helper.countItems(this.getItemFilters())) continue;
            return false;
        }
        return true;
    }

    private boolean isExcessComplete(IInventory cartInv, ItemStack[] filters) {
        this.checkedItems.clear();
        int max = 0;
        for (ItemStack filter : filters) {
            if (filter == null || !this.checkedItems.add(filter)) continue;
            InvFilteredHelper helper = InvFilteredHelper.filteredByStacks(this.isMatchByNBT(), this.isMatchByMetadata(), filter);
            int stocked = helper.countItems(cartInv);
            max += filter.field_77994_a;
            if (stocked <= helper.countItems(this.getItemFilters())) continue;
            return false;
        }
        return InvTools.countItems(cartInv) <= max;
    }

    private boolean isAllComplete(List<IInventory> chests, ItemStack[] filters) {
        this.checkedItems.clear();
        boolean hasFilter = false;
        for (ItemStack filter : filters) {
            if (filter == null || !this.checkedItems.add(filter)) continue;
            hasFilter = true;
            if (InvFilteredHelper.filteredByStacks(this.isMatchByNBT(), this.isMatchByMetadata(), filter).countItems(chests) <= 0) continue;
            return false;
        }
        return hasFilter;
    }

    private void clearInv() {
        if (!InvTools.isInventoryEmpty(this.invBuffer)) {
            InvTools.moveOneItem(this.invBuffer, this.invCache.getAdjacentInventories(), new ItemStack[0]);
        }
    }

    @Override
    public boolean openGui(EntityPlayer player) {
        GuiHandler.openGui(EnumGui.LOADER_ITEM, player, this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        return true;
    }

    public ForgeDirection getOrientation() {
        return ForgeDirection.UP;
    }

    public boolean func_102008_b(int slot, ItemStack stack, int side) {
        return true;
    }

    @Override
    public boolean func_94041_b(int slot, ItemStack stack) {
        return false;
    }
}

