/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.api.electricity;

import java.util.EnumSet;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import mods.railcraft.api.core.WorldCoordinate;
import mods.railcraft.api.electricity.IElectricGrid;
import mods.railcraft.api.tracks.ITrackInstance;
import mods.railcraft.api.tracks.ITrackTile;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;

public class GridTools {
    public static Set<IElectricGrid> getMutuallyConnectedObjects(IElectricGrid gridObject) {
        HashSet<IElectricGrid> connectedObjects = new HashSet<IElectricGrid>();
        WorldCoordinate myPos = new WorldCoordinate(gridObject.getTile());
        for (Map.Entry<WorldCoordinate, EnumSet<IElectricGrid.ChargeHandler.ConnectType>> position : gridObject.getChargeHandler().getPossibleConnectionLocations().entrySet()) {
            EnumSet<IElectricGrid.ChargeHandler.ConnectType> otherType;
            IElectricGrid otherObj = GridTools.getGridObjectAt((IBlockAccess)gridObject.getTile().func_145831_w(), position.getKey());
            if (otherObj == null || !position.getValue().contains((Object)otherObj.getChargeHandler().getType()) || (otherType = otherObj.getChargeHandler().getPossibleConnectionLocations().get(myPos)) == null || !otherType.contains((Object)gridObject.getChargeHandler().getType())) continue;
            connectedObjects.add(otherObj);
        }
        return connectedObjects;
    }

    public static IElectricGrid getGridObjectAt(IBlockAccess world, WorldCoordinate pos) {
        return GridTools.getGridObjectAt(world, pos.x, pos.y, pos.z);
    }

    public static IElectricGrid getGridObjectAt(IBlockAccess world, int x, int y, int z) {
        ITrackInstance track;
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile == null) {
            return null;
        }
        if (tile instanceof IElectricGrid) {
            return (IElectricGrid)tile;
        }
        if (tile instanceof ITrackTile && (track = ((ITrackTile)tile).getTrackInstance()) instanceof IElectricGrid) {
            return (IElectricGrid)((Object)track);
        }
        return null;
    }
}

