/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.plugins.buildcraft.actions;

import buildcraft.api.statements.IActionExternal;
import buildcraft.api.statements.IStatement;
import buildcraft.api.statements.IStatementContainer;
import buildcraft.api.statements.IStatementParameter;
import buildcraft.api.statements.StatementManager;
import cpw.mods.fml.common.Optional;
import mods.railcraft.common.plugins.buildcraft.actions.IActionReceptor;
import mods.railcraft.common.plugins.forge.LocalizationPlugin;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraftforge.common.util.ForgeDirection;

@Optional.InterfaceList(value={@Optional.Interface(iface="buildcraft.api.statements.IActionExternal", modid="BuildCraft|Core")})
public enum Actions implements IActionExternal
{
    PAUSE("pause"),
    SEND_CART("sendcart");

    public static final Actions[] VALUES;
    private final String tag;
    private IIcon icon;

    private Actions(String tag) {
        this.tag = tag;
    }

    @Optional.Method(modid="BuildCraft|Core")
    public static void init() {
        for (Actions action : VALUES) {
            StatementManager.registerStatement((IStatement)action);
            StatementManager.statements.put("railcraft." + action.tag, action);
        }
    }

    public String getUniqueTag() {
        return "railcraft:" + this.tag;
    }

    public final IIcon getIcon() {
        return this.icon;
    }

    public String getDescription() {
        return LocalizationPlugin.translate("gates.action." + this.tag);
    }

    public void registerIcons(IIconRegister iconRegister) {
        this.icon = iconRegister.func_94245_a("railcraft:buildcraft.gate.action." + this.tag);
    }

    public IActionExternal rotateLeft() {
        return this;
    }

    @Optional.Method(modid="BuildCraft|Core")
    public void actionActivate(TileEntity tile, ForgeDirection side, IStatementContainer isc, IStatementParameter[] isps) {
        if (tile instanceof IActionReceptor) {
            ((IActionReceptor)tile).actionActivated(this);
        }
    }

    public int maxParameters() {
        return 0;
    }

    public int minParameters() {
        return 0;
    }

    public IStatementParameter createParameter(int i) {
        return null;
    }

    static {
        VALUES = Actions.values();
    }
}

