/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.worldgen;

import com.kuba6000.mobsinfo.api.IVillagerInfoProvider;
import com.kuba6000.mobsinfo.api.VillagerTrade;
import cpw.mods.fml.common.ObfuscationReflectionHelper;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.common.registry.VillagerRegistry;
import java.util.ArrayList;
import java.util.Random;
import javax.annotation.Nonnull;
import mods.railcraft.common.blocks.signals.ItemSignalBlockSurveyor;
import mods.railcraft.common.blocks.signals.ItemSignalTuner;
import mods.railcraft.common.blocks.tracks.EnumTrack;
import mods.railcraft.common.carts.EnumCart;
import mods.railcraft.common.items.ItemCrowbar;
import mods.railcraft.common.items.ItemCrowbarReinforced;
import mods.railcraft.common.items.ItemGoggles;
import mods.railcraft.common.items.ItemMagnifyingGlass;
import mods.railcraft.common.items.ItemWhistleTuner;
import mods.railcraft.common.items.RailcraftToolItems;
import net.minecraft.block.Block;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MathHelper;
import net.minecraft.village.MerchantRecipe;
import net.minecraft.village.MerchantRecipeList;

@Optional.Interface(iface="com.kuba6000.mobsinfo.api.IVillagerInfoProvider", modid="mobsinfo")
public class VillagerTradeHandler
implements VillagerRegistry.IVillageTradeHandler,
IVillagerInfoProvider {
    private float baseChance;

    public void manipulateTradesForVillager(EntityVillager villager, MerchantRecipeList recipeList, Random rand) {
        this.baseChance = ((Float)ObfuscationReflectionHelper.getPrivateValue(EntityVillager.class, (Object)villager, (String[])new String[]{"field_82191_bN"})).floatValue();
        this.addRecipes(recipeList, rand);
    }

    @Optional.Method(modid="mobsinfo")
    public void provideTrades(@Nonnull EntityVillager villager, int profession, @Nonnull ArrayList<VillagerTrade> trades) {
        this.addRecipes(trades, null);
    }

    protected void addRecipes(Object recipeList, Random rand) {
        this.addTrade(recipeList, rand, 0.7f, new Offer(Items.field_151166_bC), new Offer(Items.field_151044_h, 24, 32));
        this.addTrade(recipeList, rand, 0.4f, new Offer(RailcraftToolItems.getCoalCoke(), 8, 12), new Offer(Items.field_151166_bC));
        this.addTrade(recipeList, rand, 0.4f, new Offer(Items.field_151166_bC), new Offer(RailcraftToolItems.getCoalCoke(), 12, 16));
        this.addTrade(recipeList, rand, 0.7f, new Offer(Blocks.field_150448_aq, 30, 34), new Offer(Items.field_151166_bC, 2, 3));
        this.addTrade(recipeList, rand, 0.1f, new Offer(Blocks.field_150408_cc, 14, 18), new Offer(Items.field_151166_bC, 2, 3));
        this.addTrade(recipeList, rand, 0.1f, new Offer(Blocks.field_150318_D, 14, 18), new Offer(Items.field_151166_bC, 2, 3));
        this.addTrade(recipeList, rand, 0.1f, new Offer(Blocks.field_150319_E, 14, 18), new Offer(Items.field_151166_bC, 2, 3));
        for (EnumTrack track : EnumTrack.VALUES) {
            if (!track.isEnabled()) continue;
            this.addTrade(recipeList, rand, 0.1f, new Offer(track.getItem(), track.recipeOutput - 2, track.recipeOutput + 2), new Offer(Items.field_151166_bC, 2, 3));
        }
        this.addTrade(recipeList, rand, 0.3f, new Offer(Items.field_151143_au), new Offer(Items.field_151166_bC, 8, 10));
        this.addTrade(recipeList, rand, 0.3f, new Offer(Items.field_151166_bC, 6, 8), new Offer(Items.field_151143_au));
        this.addTrade(recipeList, rand, 0.1f, new Offer(EnumCart.LOCO_STEAM_SOLID.getCartItem()), new Offer(Items.field_151166_bC, 32, 40));
        this.addTrade(recipeList, rand, 0.3f, new Offer(ItemCrowbar.getItem()), new Offer(Items.field_151166_bC, 7, 9));
        this.addTrade(recipeList, rand, 0.1f, new Offer(ItemCrowbarReinforced.getItem()), new Offer(Items.field_151166_bC, 14, 18));
        this.addTrade(recipeList, rand, 0.3f, new Offer(ItemWhistleTuner.getItem()), new Offer(Items.field_151166_bC, 1, 2));
        this.addTrade(recipeList, rand, 0.3f, new Offer(ItemMagnifyingGlass.getItem()), new Offer(Items.field_151166_bC, 1, 2));
        this.addTrade(recipeList, rand, 0.3f, new Offer(ItemSignalBlockSurveyor.getItem()), new Offer(Items.field_151166_bC, 6, 8));
        this.addTrade(recipeList, rand, 0.3f, new Offer(ItemSignalTuner.getItem()), new Offer(Items.field_151166_bC, 6, 8));
        this.addTrade(recipeList, rand, 0.4f, new Offer(ItemGoggles.getItem()), new Offer(Items.field_151166_bC, 4, 8));
        this.addTrade(recipeList, rand, 0.5f, new Offer(RailcraftToolItems.getOveralls()), new Offer(Items.field_151166_bC, 2, 4));
    }

    private void addTrade(Object recipeList, Random rand, float chance, Offer sale, Offer ... offers) {
        if (offers.length == 0 || sale.obj == null) {
            return;
        }
        for (Offer offer : offers) {
            if (offer.obj != null) continue;
            return;
        }
        if (recipeList instanceof MerchantRecipeList) {
            if (rand.nextFloat() < this.adjustProbability(chance)) {
                ItemStack sellStack = this.prepareStack(rand, sale);
                ItemStack buyStack1 = this.prepareStack(rand, offers[0]);
                ItemStack buyStack2 = null;
                if (offers.length >= 2) {
                    buyStack2 = this.prepareStack(rand, offers[1]);
                }
                ((MerchantRecipeList)recipeList).add((Object)new MerchantRecipe(buyStack1, buyStack2, sellStack));
            }
        } else {
            VillagerTrade trade = VillagerTrade.create((VillagerTrade.TradeItem)VillagerTrade.createItem((ItemStack)this.prepareStack(offers[0])).withPossibleSizes(offers[0].min, offers[0].max), (VillagerTrade.TradeItem)VillagerTrade.createItem((ItemStack)this.prepareStack(sale)).withPossibleSizes(sale.min, sale.max));
            if (offers.length >= 2) {
                trade.withSecondaryInput(VillagerTrade.createItem((ItemStack)this.prepareStack(offers[1])).withPossibleSizes(offers[1].min, offers[1].max));
            }
            ((ArrayList)recipeList).add(trade.withChance((double)chance));
        }
    }

    private ItemStack prepareStack(Random rand, Offer offer) throws IllegalArgumentException {
        if (offer.obj instanceof ItemStack) {
            ItemStack stack = (ItemStack)offer.obj;
            stack.field_77994_a = this.stackSize(rand, offer.min, offer.max);
            return stack;
        }
        if (offer.obj instanceof Item) {
            return new ItemStack((Item)offer.obj, this.stackSize(rand, offer.min, offer.max));
        }
        if (offer.obj instanceof Block) {
            return new ItemStack((Block)offer.obj, this.stackSize(rand, offer.min, offer.max));
        }
        throw new IllegalArgumentException("Unrecongnized object passed to villager trade setup");
    }

    private ItemStack prepareStack(Offer offer) throws IllegalArgumentException {
        if (offer.obj instanceof ItemStack) {
            ItemStack stack = (ItemStack)offer.obj;
            stack.field_77994_a = 1;
            return stack;
        }
        if (offer.obj instanceof Item) {
            return new ItemStack((Item)offer.obj);
        }
        if (offer.obj instanceof Block) {
            return new ItemStack((Block)offer.obj);
        }
        throw new IllegalArgumentException("Unrecongnized object passed to villager trade setup");
    }

    private int stackSize(Random rand, int min, int max) {
        return MathHelper.func_76136_a((Random)rand, (int)min, (int)max);
    }

    private float adjustProbability(float chance) {
        float adjustedChance = chance + this.baseChance;
        return adjustedChance > 0.9f ? 0.9f - (adjustedChance - 0.9f) : adjustedChance;
    }

    private static class Offer {
        public final Object obj;
        public final int min;
        public final int max;

        public Offer(Object obj, int min, int max) {
            this.obj = obj;
            this.min = min;
            this.max = max;
        }

        public Offer(Object obj, int amount) {
            this(obj, amount, amount);
        }

        public Offer(Object obj) {
            this(obj, 1);
        }
    }
}

