/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.machine.alpha;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import mods.railcraft.api.core.items.IStackFilter;
import mods.railcraft.api.crafting.IBlastFurnaceRecipe;
import mods.railcraft.api.crafting.RailcraftCraftingManager;
import mods.railcraft.common.blocks.RailcraftBlocks;
import mods.railcraft.common.blocks.machine.IEnumMachine;
import mods.railcraft.common.blocks.machine.MultiBlockPattern;
import mods.railcraft.common.blocks.machine.TileMultiBlock;
import mods.railcraft.common.blocks.machine.TileMultiBlockOven;
import mods.railcraft.common.blocks.machine.alpha.EnumMachineAlpha;
import mods.railcraft.common.gui.EnumGui;
import mods.railcraft.common.gui.GuiHandler;
import mods.railcraft.common.plugins.forge.FuelPlugin;
import mods.railcraft.common.util.inventory.AdjacentInventoryCache;
import mods.railcraft.common.util.inventory.InvTools;
import mods.railcraft.common.util.inventory.InventorySorter;
import mods.railcraft.common.util.inventory.wrappers.InventoryMapper;
import mods.railcraft.common.util.misc.Game;
import mods.railcraft.common.util.misc.ITileFilter;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class TileBlastFurnace
extends TileMultiBlockOven
implements ISidedInventory {
    public static final IStackFilter INPUT_FILTER = new IStackFilter(){

        @Override
        public boolean matches(ItemStack stack) {
            return RailcraftCraftingManager.blastFurnace.getRecipe(stack) != null;
        }
    };
    public static final IStackFilter FUEL_FILTER = new IStackFilter(){

        @Override
        public boolean matches(ItemStack stack) {
            return stack != null && InvTools.isItemEqual(stack, RailcraftCraftingManager.blastFurnace.getFuels());
        }
    };
    public static final int SLOT_INPUT = 0;
    public static final int SLOT_FUEL = 1;
    public static final int SLOT_OUTPUT = 2;
    private static final int FUEL_PER_TICK = 5;
    private static final int[] SLOTS = InvTools.buildSlotArray(0, 3);
    private static final List<MultiBlockPattern> patterns = new ArrayList<MultiBlockPattern>();
    private final IInventory invFuel = new InventoryMapper(this, 1, 1);
    private final IInventory invInput = new InventoryMapper(this, 0, 1);
    private final IInventory invOutput = new InventoryMapper(this, 2, 1);
    private final AdjacentInventoryCache invCache = new AdjacentInventoryCache(this, this.tileCache, new ITileFilter(){

        @Override
        public boolean matches(TileEntity tile) {
            if (tile instanceof TileBlastFurnace) {
                return false;
            }
            if (tile instanceof IInventory) {
                return ((IInventory)tile).func_70302_i_() >= 27;
            }
            return false;
        }
    }, InventorySorter.SIZE_DECENDING);
    public int burnTime = 0;
    public int currentItemBurnTime = 0;
    public boolean clientBurning = false;
    private int finishedAt;

    public TileBlastFurnace() {
        super("railcraft.gui.blast.furnace", 3, patterns);
    }

    public static void placeBlastFurnace(World world, int x, int y, int z, ItemStack input, ItemStack output, ItemStack fuel) {
        Iterator<MultiBlockPattern> iterator = patterns.iterator();
        if (iterator.hasNext()) {
            MultiBlockPattern pattern = iterator.next();
            HashMap<Character, Integer> blockMapping = new HashMap<Character, Integer>();
            blockMapping.put(Character.valueOf('B'), EnumMachineAlpha.BLAST_FURNACE.ordinal());
            blockMapping.put(Character.valueOf('W'), EnumMachineAlpha.BLAST_FURNACE.ordinal());
            TileEntity tile = pattern.placeStructure(world, x, y, z, RailcraftBlocks.getBlockMachineAlpha(), blockMapping);
            if (tile instanceof TileBlastFurnace) {
                TileBlastFurnace master = (TileBlastFurnace)tile;
                master.inv.func_70299_a(0, input);
                master.inv.func_70299_a(2, output);
            }
            return;
        }
    }

    @Override
    public IEnumMachine getMachineType() {
        return EnumMachineAlpha.BLAST_FURNACE;
    }

    @Override
    public IIcon getIcon(int side) {
        if (side > 1 && this.getPatternMarker() == 'W' && this.isStructureValid()) {
            if (this.isBurning()) {
                return this.getMachineType().getTexture(7);
            }
            return this.getMachineType().getTexture(6);
        }
        return this.getMachineType().getTexture(0);
    }

    @Override
    protected boolean isMapPositionValid(int i, int j, int k, char mapPos) {
        Block block = this.field_145850_b.func_147439_a(i, j, k);
        switch (mapPos) {
            case 'O': {
                if (block == RailcraftBlocks.getBlockMachineAlpha() && this.field_145850_b.func_72805_g(i, j, k) == this.func_145832_p()) break;
                return true;
            }
            case 'B': 
            case 'W': {
                if (block != RailcraftBlocks.getBlockMachineAlpha() || this.field_145850_b.func_72805_g(i, j, k) != this.func_145832_p()) break;
                return true;
            }
            case 'A': {
                if (!block.isAir((IBlockAccess)this.field_145850_b, i, j, k) && block.func_149688_o() != Material.field_151587_i) break;
                return true;
            }
        }
        return false;
    }

    @Override
    public int getTotalCookTime() {
        ItemStack input = this.func_70301_a(0);
        IBlastFurnaceRecipe recipe = RailcraftCraftingManager.blastFurnace.getRecipe(input);
        if (recipe != null) {
            return recipe.getCookTime();
        }
        return 1;
    }

    @Override
    public int getBurnProgressScaled(int i) {
        if (this.burnTime <= 0 || this.currentItemBurnTime <= 0) {
            return 0;
        }
        int scale = this.burnTime * i / this.currentItemBurnTime;
        scale = Math.min(scale, i);
        scale = Math.max(scale, 0);
        return scale;
    }

    private void setLavaIdle() {
        int xLava = this.field_145851_c + 1;
        int yLava = this.field_145848_d + 1;
        int zLava = this.field_145849_e + 1;
        if (this.field_145850_b.func_147437_c(xLava, yLava, zLava)) {
            this.field_145850_b.func_147465_d(xLava, yLava, zLava, Blocks.field_150353_l, 7, 3);
        }
    }

    private void setLavaBurn() {
        int xLava = this.field_145851_c + 1;
        int yLava = this.field_145848_d + 1;
        int zLava = this.field_145849_e + 1;
        if (this.field_145850_b.func_147437_c(xLava, yLava, zLava)) {
            this.field_145850_b.func_147465_d(xLava, yLava, zLava, (Block)Blocks.field_150356_k, 1, 3);
        }
        if (this.field_145850_b.func_147437_c(xLava, ++yLava, zLava)) {
            this.field_145850_b.func_147465_d(xLava, yLava, zLava, (Block)Blocks.field_150356_k, 1, 3);
        }
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (Game.isNotHost(this.getWorld())) {
            return;
        }
        TileBlastFurnace mBlock = (TileBlastFurnace)this.getMasterBlock();
        if (mBlock != null) {
            InvTools.moveOneItem(this.invCache.getAdjacentInventories(), mBlock.invFuel, FUEL_FILTER);
        }
        if (this.isMaster()) {
            boolean wasBurning = this.isBurning();
            if (this.clock > this.finishedAt + 10 && this.cookTime <= 0) {
                this.setCooking(false);
            }
            this.burnTime = this.burnTime >= 5 ? (this.burnTime -= 5) : 0;
            if (this.isBurning()) {
                this.setLavaBurn();
            } else {
                this.setLavaIdle();
            }
            ItemStack input = this.func_70301_a(0);
            if (input != null && input.field_77994_a > 0) {
                ItemStack output = this.func_70301_a(2);
                IBlastFurnaceRecipe recipe = RailcraftCraftingManager.blastFurnace.getRecipe(input);
                if (recipe != null && recipe.isRoomForOutput(output)) {
                    int itemBurnTime;
                    ItemStack fuel;
                    if (this.paused) {
                        return;
                    }
                    if (this.burnTime <= 10 && FUEL_FILTER.matches(fuel = this.func_70301_a(1)) && (itemBurnTime = FuelPlugin.getBurnTime(fuel)) > 0) {
                        this.burnTime = this.currentItemBurnTime = itemBurnTime + this.burnTime;
                        this.func_70299_a(1, InvTools.depleteItem(fuel));
                    }
                    if (this.isBurning()) {
                        ++this.cookTime;
                        this.setCooking(true);
                        if (this.cookTime >= recipe.getCookTime()) {
                            this.cookTime = 0;
                            this.finishedAt = this.clock;
                            if (output == null) {
                                this.func_70299_a(2, recipe.getOutput());
                            } else {
                                output.field_77994_a += recipe.getOutputStackSize();
                            }
                            this.func_70298_a(0, 1);
                        }
                    }
                } else {
                    this.cookTime = 0;
                    this.setCooking(false);
                }
            } else {
                this.cookTime = 0;
                this.setCooking(false);
            }
            if (wasBurning != this.isBurning()) {
                this.sendUpdateToClient();
            }
        }
    }

    @Override
    public boolean openGui(EntityPlayer player) {
        TileMultiBlock masterBlock = this.getMasterBlock();
        if (masterBlock != null) {
            GuiHandler.openGui(EnumGui.BLAST_FURNACE, player, this.field_145850_b, masterBlock.field_145851_c, masterBlock.field_145848_d, masterBlock.field_145849_e);
            return true;
        }
        return false;
    }

    @Override
    public void func_145841_b(NBTTagCompound data) {
        super.func_145841_b(data);
        data.func_74768_a("burnTime", this.burnTime);
        data.func_74768_a("currentItemBurnTime", this.currentItemBurnTime);
    }

    @Override
    public void func_145839_a(NBTTagCompound data) {
        super.func_145839_a(data);
        this.burnTime = data.func_74762_e("burnTime");
        this.currentItemBurnTime = data.func_74762_e("currentItemBurnTime");
    }

    @Override
    public void writePacketData(DataOutputStream data) throws IOException {
        super.writePacketData(data);
        data.writeBoolean(this.burnTime > 0);
    }

    @Override
    public void readPacketData(DataInputStream data) throws IOException {
        super.readPacketData(data);
        this.clientBurning = data.readBoolean();
    }

    @Override
    public boolean needsFuel() {
        ItemStack fuel = this.func_70301_a(1);
        return fuel == null || fuel.field_77994_a < 8;
    }

    @Override
    public boolean isBurning() {
        TileBlastFurnace mBlock = (TileBlastFurnace)this.getMasterBlock();
        if (mBlock != null) {
            if (this.field_145850_b.field_72995_K) {
                return mBlock.clientBurning;
            }
            return mBlock.burnTime > 0;
        }
        return false;
    }

    @Override
    public boolean func_94041_b(int slot, ItemStack stack) {
        if (!super.func_94041_b(slot, stack)) {
            return false;
        }
        switch (slot) {
            case 2: {
                return false;
            }
            case 1: {
                return FUEL_FILTER.matches(stack);
            }
            case 0: {
                return INPUT_FILTER.matches(stack);
            }
        }
        return false;
    }

    public int[] func_94128_d(int var1) {
        return SLOTS;
    }

    public boolean func_102007_a(int slot, ItemStack stack, int side) {
        return this.func_94041_b(slot, stack);
    }

    public boolean func_102008_b(int slot, ItemStack stack, int side) {
        return slot == 2;
    }

    static {
        char[][][] map = new char[][][]{new char[][]{{'O', 'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O', 'O'}}, new char[][]{{'O', 'O', 'O', 'O', 'O'}, {'O', 'B', 'W', 'B', 'O'}, {'O', 'W', 'B', 'W', 'O'}, {'O', 'B', 'W', 'B', 'O'}, {'O', 'O', 'O', 'O', 'O'}}, new char[][]{{'O', 'O', 'O', 'O', 'O'}, {'O', 'B', 'B', 'B', 'O'}, {'O', 'B', 'A', 'B', 'O'}, {'O', 'B', 'B', 'B', 'O'}, {'O', 'O', 'O', 'O', 'O'}}, new char[][]{{'O', 'O', 'O', 'O', 'O'}, {'O', 'B', 'B', 'B', 'O'}, {'O', 'B', 'A', 'B', 'O'}, {'O', 'B', 'B', 'B', 'O'}, {'O', 'O', 'O', 'O', 'O'}}, new char[][]{{'O', 'O', 'O', 'O', 'O'}, {'O', 'B', 'B', 'B', 'O'}, {'O', 'B', 'B', 'B', 'O'}, {'O', 'B', 'B', 'B', 'O'}, {'O', 'O', 'O', 'O', 'O'}}, new char[][]{{'O', 'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O', 'O'}}};
        patterns.add(new MultiBlockPattern(map, 2, 1, 2));
    }
}

