/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.signals;

import mods.railcraft.api.core.IPostConnection;
import mods.railcraft.api.signals.SignalTools;
import mods.railcraft.common.blocks.signals.ISignalTile;
import mods.railcraft.common.blocks.signals.ISignalTileDefinition;
import mods.railcraft.common.blocks.signals.MaterialStructure;
import mods.railcraft.common.blocks.signals.TileSignalFoundation;
import mods.railcraft.common.items.IActivationBlockingItem;
import mods.railcraft.common.util.misc.Game;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import org.apache.logging.log4j.Level;

public abstract class BlockSignalBase
extends BlockContainer
implements IPostConnection {
    private final int renderType;

    public BlockSignalBase(int renderType) {
        super((Material)new MaterialStructure());
        this.renderType = renderType;
        this.func_149672_a(Block.field_149777_j);
        this.func_149752_b(50.0f);
        this.func_149647_a(CreativeTabs.field_78029_e);
        this.setHarvestLevel("crowbar", 0);
    }

    public abstract ISignalTileDefinition getSignalType(int var1);

    public abstract IIcon func_149691_a(int var1, int var2);

    public int func_149692_a(int meta) {
        return meta;
    }

    public boolean func_149727_a(World world, int i, int j, int k, EntityPlayer player, int side, float u1, float u2, float u3) {
        ItemStack current = player.func_71045_bC();
        if (current != null && current.func_77973_b() instanceof IActivationBlockingItem) {
            return false;
        }
        TileEntity tile = world.func_147438_o(i, j, k);
        if (tile instanceof TileSignalFoundation) {
            return ((TileSignalFoundation)tile).blockActivated(side, player);
        }
        return false;
    }

    public boolean rotateBlock(World world, int x, int y, int z, ForgeDirection axis) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof TileSignalFoundation) {
            return ((TileSignalFoundation)tile).rotateBlock(axis);
        }
        return false;
    }

    public ForgeDirection[] getValidRotations(World world, int x, int y, int z) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof TileSignalFoundation) {
            return ((TileSignalFoundation)tile).getValidRotations();
        }
        return super.getValidRotations(world, x, y, z);
    }

    public void func_149714_e(World world, int x, int y, int z, int meta) {
        TileEntity tile;
        super.func_149714_e(world, x, y, z, meta);
        if (SignalTools.printSignalDebug) {
            Game.logTrace(Level.INFO, 10, "Signal Block onPostBlockPlaced. [{0}, {1}, {2}]", x, y, y);
        }
        if ((tile = world.func_147438_o(x, y, z)) instanceof TileSignalFoundation) {
            ((TileSignalFoundation)tile).onBlockPlaced();
        }
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase entityliving, ItemStack stack) {
        TileEntity tile;
        if (SignalTools.printSignalDebug) {
            Game.logTrace(Level.INFO, 10, "Signal Block onBlockPlacedBy. [{0}, {1}, {2}]", x, y, z);
        }
        if ((tile = world.func_147438_o(x, y, z)) instanceof TileSignalFoundation) {
            ((TileSignalFoundation)tile).onBlockPlacedBy(entityliving, stack);
        }
    }

    public void func_149695_a(World world, int x, int y, int z, Block block) {
        try {
            TileEntity tile = world.func_147438_o(x, y, z);
            if (tile instanceof TileSignalFoundation) {
                TileSignalFoundation structure = (TileSignalFoundation)tile;
                if (structure.getSignalType().needsSupport() && !world.isSideSolid(x, y - 1, z, ForgeDirection.UP)) {
                    world.func_147480_a(x, y, z, true);
                } else {
                    structure.onNeighborBlockChange(block);
                }
            }
        }
        catch (StackOverflowError error) {
            Game.logThrowable(Level.ERROR, "Error in BlockSignalBase.onNeighborBlockChange()", 10, error, new Object[0]);
            throw error;
        }
    }

    public void func_149749_a(World world, int x, int y, int z, Block block, int meta) {
        TileEntity tile;
        if (SignalTools.printSignalDebug) {
            Game.logTrace(Level.INFO, 10, "Signal Block breakBlock. [{0}, {1}, {2}]", x, y, z);
        }
        if ((tile = world.func_147438_o(x, y, z)) instanceof TileSignalFoundation) {
            ((TileSignalFoundation)tile).onBlockRemoval();
        }
        super.func_149749_a(world, x, y, z, block, meta);
    }

    public void func_149719_a(IBlockAccess world, int i, int j, int k) {
        TileEntity tile = world.func_147438_o(i, j, k);
        if (tile instanceof TileSignalFoundation) {
            ((TileSignalFoundation)tile).setBlockBoundsBasedOnState(world, i, j, k);
        } else {
            this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        }
    }

    public AxisAlignedBB func_149668_a(World world, int i, int j, int k) {
        TileEntity tile = world.func_147438_o(i, j, k);
        if (tile instanceof TileSignalFoundation) {
            return ((TileSignalFoundation)tile).getCollisionBoundingBoxFromPool(world, i, j, k);
        }
        this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        return super.func_149668_a(world, i, j, k);
    }

    public AxisAlignedBB func_149633_g(World world, int x, int y, int z) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof TileSignalFoundation) {
            return ((TileSignalFoundation)tile).getSelectedBoundingBoxFromPool(world, x, y, z);
        }
        return AxisAlignedBB.func_72330_a((double)((double)x + this.field_149759_B), (double)((double)y + this.field_149760_C), (double)((double)z + this.field_149754_D), (double)((double)x + this.field_149755_E), (double)((double)y + this.field_149756_F), (double)((double)z + this.field_149757_G));
    }

    public int getLightValue(IBlockAccess world, int x, int y, int z) {
        if (y < 0) {
            return 0;
        }
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof ISignalTile) {
            return ((ISignalTile)tile).getLightValue();
        }
        return 0;
    }

    public float func_149712_f(World world, int x, int y, int z) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof TileSignalFoundation) {
            return ((TileSignalFoundation)tile).getHardness();
        }
        return 3.0f;
    }

    public boolean isSideSolid(IBlockAccess world, int i, int j, int k, ForgeDirection side) {
        TileEntity tile = world.func_147438_o(i, j, k);
        if (tile instanceof TileSignalFoundation) {
            return ((TileSignalFoundation)tile).isSideSolid(world, i, j, k, side);
        }
        return false;
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public int func_149645_b() {
        return this.renderType;
    }

    public TileEntity func_149915_a(World var1, int meta) {
        return null;
    }

    public abstract TileEntity createTileEntity(World var1, int var2);

    public boolean func_149744_f() {
        return true;
    }

    public boolean canConnectRedstone(IBlockAccess world, int i, int j, int k, int dir) {
        TileEntity tile = world.func_147438_o(i, j, k);
        if (tile instanceof TileSignalFoundation) {
            return ((TileSignalFoundation)tile).canConnectRedstone(dir);
        }
        return false;
    }

    public boolean func_149637_q() {
        return false;
    }

    public boolean func_149646_a(IBlockAccess world, int x, int y, int z, int side) {
        return true;
    }

    public int func_149709_b(IBlockAccess world, int i, int j, int k, int side) {
        TileEntity tile = world.func_147438_o(i, j, k);
        if (tile instanceof TileSignalFoundation) {
            return ((TileSignalFoundation)tile).getPowerOutput(side);
        }
        return 0;
    }

    public boolean hasTileEntity(int metadata) {
        return true;
    }

    public boolean canBeReplacedByLeaves(IBlockAccess world, int x, int y, int z) {
        return false;
    }

    public boolean canCreatureSpawn(EnumCreatureType type, IBlockAccess world, int x, int y, int z) {
        return false;
    }

    @Override
    public IPostConnection.ConnectStyle connectsToPost(IBlockAccess world, int x, int y, int z, ForgeDirection side) {
        TileEntity t = world.func_147438_o(x, y, z);
        if (t instanceof ISignalTile) {
            return IPostConnection.ConnectStyle.TWO_THIN;
        }
        return IPostConnection.ConnectStyle.NONE;
    }
}

