/*
 * Decompiled with CFR 0.152.
 */
package serverutils.data;

import serverutils.data.ClaimedChunks;
import serverutils.data.ServerUtilitiesTeamData;
import serverutils.lib.data.ForgeTeam;
import serverutils.lib.math.ChunkDimPos;

public final class ClaimedChunk {
    private final ChunkDimPos pos;
    private final ServerUtilitiesTeamData teamData;
    private boolean loaded;
    private boolean invalid;
    public boolean preDecay;
    public Boolean forced;

    public ClaimedChunk(ChunkDimPos c, ServerUtilitiesTeamData t) {
        this.pos = c;
        this.teamData = t;
        this.loaded = false;
        this.preDecay = false;
        this.invalid = false;
        this.forced = null;
    }

    public boolean isInvalid() {
        return this.invalid || !this.getTeam().isValid();
    }

    public void setInvalid() {
        if (!this.invalid) {
            this.invalid = true;
            this.getTeam().markDirty();
        }
    }

    public ChunkDimPos getPos() {
        return this.pos;
    }

    public ForgeTeam getTeam() {
        return this.teamData.team;
    }

    public ServerUtilitiesTeamData getData() {
        return this.teamData;
    }

    public boolean setLoaded(boolean v) {
        if (this.loaded != v) {
            this.loaded = v;
            if (ClaimedChunks.isActive()) {
                ClaimedChunks.instance.markDirty();
            }
            this.getTeam().markDirty();
            return true;
        }
        return false;
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public boolean hasExplosions() {
        return this.teamData.hasExplosions();
    }

    public String toString() {
        return this.pos.toString() + '+' + this.loaded;
    }

    public int hashCode() {
        return this.pos.hashCode();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && o.getClass() == ClaimedChunk.class) {
            return this.pos.equalsChunkDimPos(((ClaimedChunk)o).pos);
        }
        return false;
    }
}

