/*
 * Decompiled with CFR 0.152.
 */
package serverutils.invsee.inventories;

import cpw.mods.fml.common.Loader;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;
import serverutils.invsee.inventories.AdventureBackpackInv;
import serverutils.invsee.inventories.BattlegearInventory;
import serverutils.invsee.inventories.BaublesInventory;
import serverutils.invsee.inventories.EnderInventory;
import serverutils.invsee.inventories.GalacticraftInventory;
import serverutils.invsee.inventories.IModdedInventory;
import serverutils.invsee.inventories.MainInventory;
import serverutils.invsee.inventories.MinecraftBackpackInv;
import serverutils.invsee.inventories.TiCInventory;

public enum InvSeeInventories {
    MAIN(null, MainInventory.class),
    ENDER_CHEST(null, EnderInventory.class),
    ADVENTURE_BACKPACK("adventurebackpack", AdventureBackpackInv.class),
    BAUBLES("Baubles", BaublesInventory.class),
    BATTLE_GEAR("battlegear2", BattlegearInventory.class),
    BACKPACK("Backpack", MinecraftBackpackInv.class),
    GALACTICRAFT("GalacticraftCore", GalacticraftInventory.class),
    TINKERS_CONSTRUCT("TConstruct", TiCInventory.class);

    public static final InvSeeInventories[] VALUES;
    private final String modId;
    private final Class<? extends IModdedInventory> inventory;
    private IModdedInventory instance;
    private final boolean loaded;
    private static List<InvSeeInventories> inventories;

    private InvSeeInventories(String modId, Class<? extends IModdedInventory> inventory) {
        this.modId = modId;
        this.inventory = inventory;
        this.loaded = modId == null || Loader.isModLoaded((String)modId);
    }

    @Nullable
    public IModdedInventory getNullableInventory() {
        if (this.loaded && this.instance == null) {
            try {
                this.instance = this.inventory.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.instance;
    }

    public IModdedInventory getInventory() {
        if (!this.loaded) {
            throw new IllegalStateException("Trying to get IModdedInventory for unloaded mod: " + this.modId);
        }
        if (this.instance == null) {
            try {
                this.instance = this.inventory.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.instance;
    }

    public static List<InvSeeInventories> getActiveInventories() {
        if (inventories == null) {
            inventories = new ArrayList<InvSeeInventories>();
            for (InvSeeInventories inv : VALUES) {
                if (!inv.loaded) continue;
                inventories.add(inv);
            }
        }
        return inventories;
    }

    static {
        VALUES = InvSeeInventories.values();
    }
}

