/*
 * Decompiled with CFR 0.152.
 */
package serverutils.mixins.early.minecraft;

import net.minecraft.network.NetworkSystem;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.server.management.ServerConfigurationManager;
import net.minecraftforge.common.chunkio.ChunkIOExecutor;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import serverutils.ServerUtilities;
import serverutils.data.IPauseWhenEmpty;

@Mixin(value={MinecraftServer.class})
public abstract class MixinMinecraftServer_PauseWhenEmpty {
    @Shadow
    private ServerConfigurationManager field_71318_t;
    @Unique
    private int serverUtilities$emptyTicks = 0;
    @Unique
    private boolean serverUtilities$wasPaused = false;

    @Shadow
    public abstract int func_71233_x();

    @Shadow
    protected abstract void func_71267_a(boolean var1);

    @Shadow
    public abstract NetworkSystem func_147137_ag();

    @Shadow
    public abstract int func_71259_af();

    @Inject(method={"tick"}, at={@At(value="HEAD")}, cancellable=true, order=9000)
    public void serverUtilities$tick(CallbackInfo ci) {
        DedicatedServer ds;
        MixinMinecraftServer_PauseWhenEmpty mixinMinecraftServer_PauseWhenEmpty = this;
        if (mixinMinecraftServer_PauseWhenEmpty instanceof DedicatedServer && (ds = (DedicatedServer)mixinMinecraftServer_PauseWhenEmpty) instanceof IPauseWhenEmpty) {
            IPauseWhenEmpty p = (IPauseWhenEmpty)ds;
            int pauseTicks = p.serverUtilities$getPauseWhenEmptySeconds() * 20;
            if (pauseTicks > 0) {
                this.serverUtilities$emptyTicks = this.func_71233_x() == 0 ? ++this.serverUtilities$emptyTicks : 0;
                if (this.serverUtilities$emptyTicks >= pauseTicks) {
                    if (!this.serverUtilities$wasPaused) {
                        ServerUtilities.LOGGER.info("Server empty for {} seconds, saving and pausing", new Object[]{p.serverUtilities$getPauseWhenEmptySeconds()});
                        this.field_71318_t.func_72389_g();
                        this.func_71267_a(true);
                        this.serverUtilities$wasPaused = true;
                    }
                    ChunkIOExecutor.tick();
                    this.func_147137_ag().func_151269_c();
                    ds.func_71333_ah();
                    ci.cancel();
                    return;
                }
            }
            if (this.serverUtilities$wasPaused) {
                ServerUtilities.LOGGER.info("Resuming server");
                this.serverUtilities$wasPaused = false;
                p.serverUtilities$setPauseWhenEmptySeconds(-1, true);
            }
        }
    }
}

