/*
 * Decompiled with CFR 0.152.
 */
package serverutils.lib.gui;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import serverutils.lib.client.GlStateManager;
import serverutils.lib.gui.Button;
import serverutils.lib.gui.GuiBase;
import serverutils.lib.gui.GuiHelper;
import serverutils.lib.gui.GuiIcons;
import serverutils.lib.gui.Panel;
import serverutils.lib.gui.Theme;
import serverutils.lib.gui.WidgetType;
import serverutils.lib.gui.misc.GuiButtonListBase;
import serverutils.lib.icon.Color4I;
import serverutils.lib.util.misc.MouseButton;

public class CheckBoxList
extends Button {
    public final boolean radioButtons;
    protected final List<CheckBoxEntry> entries;

    public CheckBoxList(Panel gui, boolean radiobutton) {
        super(gui);
        this.setSize(10, 2);
        this.radioButtons = radiobutton;
        this.entries = new ArrayList<CheckBoxEntry>();
    }

    public int getValueCount() {
        return 2;
    }

    @Override
    public void drawBackground(Theme theme, int x, int y, int w, int h) {
    }

    public void drawCheckboxBackground(Theme theme, int x, int y, int w, int h) {
        theme.drawCheckboxBackground(x, y, w, h, this.radioButtons);
    }

    public void getCheckboxIcon(Theme theme, int x, int y, int w, int h, int index, int value) {
        if (value > 0) {
            GuiIcons.BLANK.withColor(Color4I.BLACK.withAlpha(150)).draw(x, y, w, h);
        }
    }

    public void addBox(CheckBoxEntry checkBox) {
        checkBox.checkBoxList = this;
        this.entries.add(checkBox);
        this.entries.sort((e1, e2) -> e1.name.compareToIgnoreCase(e2.name));
        this.setWidth(Math.max(this.width, this.getGui().getTheme().getStringWidth(checkBox.name)));
        this.setHeight(this.height + 11);
    }

    public CheckBoxEntry addBox(String name) {
        CheckBoxEntry entry = new CheckBoxEntry(name);
        this.addBox(entry);
        return entry;
    }

    @Override
    public void onClicked(MouseButton button) {
        CheckBoxEntry entry = this.getEntryUnderMouse();
        if (entry != null) {
            entry.onClicked(button, this.getActiveEntries().indexOf(entry));
        }
    }

    @Override
    public void addMouseOverText(List<String> list) {
        CheckBoxEntry entry = this.getEntryUnderMouse();
        if (entry != null) {
            entry.addMouseOverText(list);
        }
    }

    public List<CheckBoxEntry> getActiveEntries() {
        GuiButtonListBase btnList;
        GuiBase guiBase = this.getGui();
        if (guiBase instanceof GuiButtonListBase && (btnList = (GuiButtonListBase)guiBase).hasSearchBox() && !btnList.getTextInSearchBox().isEmpty()) {
            return this.entries.stream().filter(entry -> entry.name.toLowerCase().contains(btnList.getTextInSearchBox())).collect(Collectors.toList());
        }
        return this.entries;
    }

    @Override
    public void draw(Theme theme, int x, int y, int w, int h) {
        this.drawBackground(theme, x, y, w, h);
        for (int i = 0; i < this.getActiveEntries().size(); ++i) {
            CheckBoxEntry entry = this.getActiveEntries().get(i);
            int ey = y + i * 11 + 1;
            this.drawCheckboxBackground(theme, x, ey, 10, 10);
            this.getCheckboxIcon(theme, x + 1, ey + 1, 8, 8, i, entry.value);
            if (this.parent.isMouseOver && this.getEntryUnderMouse() == entry) {
                theme.drawString(entry.getDisplayName(), x + 12, ey + 1, theme.getContentColor(WidgetType.mouseOver(true)), 2);
            } else {
                theme.drawString(entry.getDisplayName(), x + 12, ey + 1, 2);
            }
            GlStateManager.color(1.0f, 1.0f, 1.0f, 1.0f);
        }
    }

    public CheckBoxEntry getEntryUnderMouse() {
        int y = this.getMouseY() - this.getY();
        if (y % 11 == 10) {
            return null;
        }
        int i = y / 11;
        if (i >= 0 && i < this.getActiveEntries().size()) {
            return this.getActiveEntries().get(i);
        }
        return null;
    }

    public static class CheckBoxEntry {
        public String name;
        public String displayName;
        public int value = 0;
        protected boolean locked = false;
        protected CheckBoxList checkBoxList;

        public CheckBoxEntry(String n) {
            this.name = n;
            this.displayName = n;
        }

        public void onClicked(MouseButton button, int index) {
            this.select((this.value + 1) % this.checkBoxList.getValueCount());
            GuiHelper.playClickSound();
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public CheckBoxEntry setDisplayName(String name) {
            this.displayName = name;
            return this;
        }

        public CheckBoxEntry setLocked(boolean state) {
            this.locked = state;
            return this;
        }

        public void addMouseOverText(List<String> list) {
        }

        public CheckBoxEntry select(int v) {
            if (this.locked) {
                return this;
            }
            if (this.checkBoxList.radioButtons) {
                if (v > 0) {
                    for (CheckBoxEntry entry : this.checkBoxList.getActiveEntries()) {
                        boolean old1 = entry.value > 0;
                        entry.value = 0;
                        if (!old1) continue;
                        entry.onValueChanged();
                    }
                } else {
                    return this;
                }
            }
            int old = this.value;
            this.value = v;
            if (old != this.value) {
                this.onValueChanged();
            }
            return this;
        }

        public void onValueChanged() {
        }
    }
}

