/*
 * Decompiled with CFR 0.152.
 */
package serverutils.lib.gui;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import serverutils.lib.gui.GuiBase;
import serverutils.lib.gui.IGuiWrapper;
import serverutils.lib.gui.Panel;
import serverutils.lib.gui.Theme;
import serverutils.lib.gui.WidgetType;
import serverutils.lib.util.misc.MouseButton;

public class Widget
implements IGuiWrapper {
    public Panel parent;
    public int posX;
    public int posY;
    public int width;
    public int height;
    protected boolean isMouseOver;

    public Widget(Panel p) {
        this.parent = p;
    }

    @Override
    public GuiBase getGui() {
        return this.parent.getGui();
    }

    public void setX(int v) {
        this.posX = v;
    }

    public void setY(int v) {
        this.posY = v;
    }

    public void setWidth(int v) {
        this.width = Math.max(v, 0);
    }

    public void setHeight(int v) {
        this.height = Math.max(v, 0);
    }

    public final void setPos(int x, int y) {
        this.setX(x);
        this.setY(y);
    }

    public final void setSize(int w, int h) {
        this.setWidth(w);
        this.setHeight(h);
    }

    public final Widget setPosAndSize(int x, int y, int w, int h) {
        this.setX(x);
        this.setY(y);
        this.setWidth(w);
        this.setHeight(h);
        return this;
    }

    public int getX() {
        return this.parent.getX() + this.posX;
    }

    public int getY() {
        return this.parent.getY() + this.posY;
    }

    public boolean collidesWith(int x, int y, int w, int h) {
        int ay = this.getY();
        if (ay >= y + h || ay + this.height <= y) {
            return false;
        }
        int ax = this.getX();
        return ax < x + w && ax + this.width > x;
    }

    public boolean isEnabled() {
        return true;
    }

    public boolean shouldDraw() {
        return true;
    }

    public String getTitle() {
        return "";
    }

    public WidgetType getWidgetType() {
        return WidgetType.mouseOver(this.isMouseOver());
    }

    public void addMouseOverText(List<String> list) {
        String title = this.getTitle();
        if (!title.isEmpty()) {
            list.add(title);
        }
    }

    public final boolean isMouseOver() {
        return this.isMouseOver;
    }

    public boolean checkMouseOver(int mouseX, int mouseY) {
        if (this.parent == null) {
            return true;
        }
        if (!this.parent.isMouseOver()) {
            return false;
        }
        int ax = this.getX();
        int ay = this.getY();
        return mouseX >= ax && mouseY >= ay && mouseX < ax + this.width && mouseY < ay + this.height;
    }

    public void updateMouseOver(int mouseX, int mouseY) {
        this.isMouseOver = this.checkMouseOver(mouseX, mouseY);
    }

    public boolean shouldAddMouseOverText() {
        return this.isEnabled() && this.isMouseOver();
    }

    public void draw(Theme theme, int x, int y, int w, int h) {
    }

    public boolean mousePressed(MouseButton button) {
        return false;
    }

    public void mouseReleased(MouseButton button) {
    }

    public boolean mouseScrolled(int scroll) {
        return false;
    }

    public boolean keyPressed(int key, char keyChar) {
        return false;
    }

    public void keyReleased(int key) {
    }

    public ScaledResolution getScreen() {
        return this.parent.getScreen();
    }

    public int getMouseX() {
        return this.parent.getMouseX();
    }

    public int getMouseY() {
        return this.parent.getMouseY();
    }

    public float getPartialTicks() {
        return this.parent.getPartialTicks();
    }

    public boolean handleClick(String scheme, String path) {
        return this.parent.handleClick(scheme, path);
    }

    public final boolean handleClick(String click) {
        int index = click.indexOf(58);
        if (index == -1) {
            return this.handleClick("", click);
        }
        return this.handleClick(click.substring(0, index), click.substring(index + 1));
    }

    public void onClosed() {
    }

    @Nullable
    public Object getIngredientUnderMouse() {
        return null;
    }

    public boolean isGhostIngredientTarget(Object ingredient) {
        return false;
    }

    public void acceptGhostIngredient(Object ingredient) {
    }

    public static boolean isMouseButtonDown(MouseButton button) {
        return Mouse.isButtonDown((int)button.id);
    }

    public static boolean isKeyDown(int key) {
        return Keyboard.isKeyDown((int)key);
    }

    public static String getClipboardString() {
        return GuiScreen.func_146277_j();
    }

    public static void setClipboardString(String string) {
        GuiScreen.func_146275_d((String)string);
    }

    public static boolean isShiftKeyDown() {
        return GuiScreen.func_146272_n();
    }

    public static boolean isCtrlKeyDown() {
        return GuiScreen.func_146271_m();
    }

    public static boolean isAltKeyDown() {
        return Keyboard.isKeyDown((int)56) || Keyboard.isKeyDown((int)184);
    }

    public static boolean isKeyComboCtrlX(int key) {
        return Widget.isCtrlKeyDown() && Keyboard.isKeyDown((int)45);
    }

    public static boolean isKeyComboCtrlV(int key) {
        return Widget.isCtrlKeyDown() && Keyboard.isKeyDown((int)47);
    }

    public static boolean isKeyComboCtrlC(int key) {
        return Widget.isCtrlKeyDown() && Keyboard.isKeyDown((int)46);
    }

    public static boolean isKeyComboCtrlA(int key) {
        return Widget.isCtrlKeyDown() && Keyboard.isKeyDown((int)30);
    }

    public void tick() {
    }

    public String toString() {
        String s = this.getClass().getSimpleName();
        if (s.isEmpty()) {
            s = this.getClass().getSuperclass().getSimpleName();
        }
        return s;
    }
}

